/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public final class BiomeRepository {
    private static final Random generator = new Random();
    private static final HashMap<class_1959, Integer> IDtoColor = new HashMap(256);
    private static final TreeMap<String, Integer> nameToColor = new TreeMap();
    private static boolean dirty;

    private BiomeRepository() {
    }

    public static void loadBiomeColors() {
        File saveDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/");
        File settingsFile = new File(saveDir, "biomecolors.txt");
        if (settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] curLine = sCurrentLine.split("=");
                    if (curLine.length != 2) continue;
                    String name = curLine[0];
                    int color = 0;
                    try {
                        color = Integer.decode(curLine[1]);
                    }
                    catch (NumberFormatException var10) {
                        VoxelConstants.getLogger().warn("Error decoding integer string for biome colors; " + curLine[1]);
                    }
                    if (nameToColor.put(name, color) == null) continue;
                    dirty = true;
                }
                br.close();
            }
            catch (IOException var12) {
                VoxelConstants.getLogger().error("biome load error: " + var12.getLocalizedMessage(), (Throwable)var12);
            }
        }
        try {
            String sCurrentLine;
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(class_2960.method_60655((String)"voxelmap", (String)"conf/biomecolors.txt")).get()).method_14482();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((sCurrentLine = br.readLine()) != null) {
                int color;
                String[] curLine = sCurrentLine.split("=");
                if (curLine.length != 2) continue;
                String name = curLine[0];
                try {
                    color = Integer.decode(curLine[1]);
                }
                catch (NumberFormatException var9) {
                    VoxelConstants.getLogger().warn("Error decoding integer string for biome colors; " + curLine[1]);
                    color = 0;
                }
                if (nameToColor.get(name) != null) continue;
                nameToColor.put(name, color);
                dirty = true;
            }
            br.close();
            is.close();
        }
        catch (IOException var11) {
            VoxelConstants.getLogger().error("Error loading biome color config file from litemod!", (Throwable)var11);
        }
    }

    public static void saveBiomeColors() {
        if (dirty) {
            File saveDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File settingsFile = new File(saveDir, "biomecolors.txt");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                for (Map.Entry<String, Integer> entry : nameToColor.entrySet()) {
                    String name = entry.getKey();
                    Integer color = entry.getValue();
                    StringBuilder hexColor = new StringBuilder(Integer.toHexString(color));
                    while (hexColor.length() < 6) {
                        hexColor.insert(0, "0");
                    }
                    hexColor.insert(0, "0x");
                    out.println(name + "=" + String.valueOf(hexColor));
                }
                out.close();
            }
            catch (IOException var8) {
                VoxelConstants.getLogger().error("biome save error: " + var8.getLocalizedMessage(), (Throwable)var8);
            }
        }
        dirty = false;
    }

    public static int getBiomeColor(class_1959 biome) {
        String friendlyName;
        Integer color = IDtoColor.get(biome);
        if (color != null) {
            return color;
        }
        if (biome == null) {
            VoxelConstants.getLogger().warn("non biome");
            return 0;
        }
        String identifier = VoxelConstants.getPlayer().method_73183().method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome).toString();
        color = nameToColor.get(identifier);
        if (color == null && (color = nameToColor.get(friendlyName = BiomeRepository.getName(biome))) != null) {
            nameToColor.remove(friendlyName);
            nameToColor.put(identifier, color);
            dirty = true;
        }
        if (color == null) {
            int r = generator.nextInt(255);
            int g = generator.nextInt(255);
            int b = generator.nextInt(255);
            color = r << 16 | g << 8 | b;
            nameToColor.put(identifier, color);
            dirty = true;
        }
        IDtoColor.put(biome, color);
        return color;
    }

    @NotNull
    public static String getName(class_1959 biome) {
        class_2960 resourceLocation = VoxelConstants.getPlayer().method_73183().method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        String translationKey = class_156.method_646((String)"biome", (class_2960)resourceLocation);
        String name = class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        if (name.equals(translationKey)) {
            return TextUtils.prettify(resourceLocation.method_12832());
        }
        return name;
    }

    @NotNull
    public static String getName(int biomeID) {
        class_1959 biome = (class_1959)VoxelConstants.getPlayer().method_73183().method_30349().method_30530(class_7924.field_41236).method_10200(biomeID);
        if (biome != null) {
            return BiomeRepository.getName(biome);
        }
        return "Unknown";
    }
}

