/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.google.common.collect.BiMap;
import java.util.Optional;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class BlockStateParser {
    private BlockStateParser() {
    }

    public static void parseLine(String line, BiMap<class_2680, Integer> map) {
        String[] lineParts = line.split(" ");
        int id = Integer.parseInt(lineParts[0]);
        class_2680 blockState = BlockStateParser.parseStateString(lineParts[1]);
        if (blockState != null) {
            map.forcePut((Object)blockState, (Object)id);
        }
    }

    @Nullable
    private static class_2680 parseStateString(String stateString) {
        String[] propertiesStringParts;
        int bracketIndex = stateString.indexOf(91);
        String resourceString = stateString.substring(0, bracketIndex == -1 ? stateString.length() : bracketIndex);
        int curlyBracketOpenIndex = resourceString.indexOf(123);
        int curlyBracketCloseIndex = resourceString.indexOf(125);
        resourceString = resourceString.substring(curlyBracketOpenIndex == -1 ? 0 : curlyBracketOpenIndex + 1, curlyBracketCloseIndex == -1 ? resourceString.length() : curlyBracketCloseIndex);
        String[] resourceStringParts = resourceString.split(":");
        class_2960 resourceLocation = null;
        if (resourceStringParts.length == 1) {
            resourceLocation = class_2960.method_60654((String)resourceStringParts[0]);
        } else if (resourceStringParts.length == 2) {
            resourceLocation = class_2960.method_60655((String)resourceStringParts[0], (String)resourceStringParts[1]);
        }
        class_6880.class_6883 blockRef = class_7923.field_41175.method_10223(resourceLocation).orElse(null);
        if (blockRef == null) {
            return null;
        }
        class_2248 block = (class_2248)blockRef.comp_349();
        if (block instanceof class_2189 && !resourceString.equals("minecraft:air")) {
            return null;
        }
        class_2680 blockState = block.method_9564();
        if (bracketIndex == -1) {
            return blockState;
        }
        String propertiesString = stateString.substring(stateString.indexOf(91) + 1, stateString.lastIndexOf(93));
        for (String propertiesStringPart : propertiesStringParts = propertiesString.split(",")) {
            String[] propertyStringParts = propertiesStringPart.split("=");
            class_2769 property = block.method_9595().method_11663(propertyStringParts[0]);
            if (property == null) continue;
            blockState = BlockStateParser.withValue(blockState, property, propertyStringParts[1]);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 withValue(class_2680 state, class_2769<T> property, String string) {
        Optional value = property.method_11900(string);
        return value.isPresent() ? (class_2680)state.method_11657(property, (Comparable)value.get()) : state;
    }
}

