/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_638;

public class MapUtils {
    private static MapSettingsManager options;
    private static Random slimeRandom;
    private static String lastSeed;
    private static long lastSeedLong;
    private static int lastSlimeX;
    private static int lastSlimeZ;
    private static boolean isSlimeChunk;

    public static void reset() {
        options = VoxelConstants.getVoxelMapInstance().getMapOptions();
    }

    public static int doSlimeAndGrid(int color24, class_638 world, int mcX, int mcZ) {
        if (MapUtils.options.slimeChunks && MapUtils.isSlimeChunk(mcX, mcZ)) {
            color24 = ColorUtils.colorAdder(2097217280, color24);
        }
        if (MapUtils.options.chunkGrid) {
            if (mcX % 512 != 0 && mcZ % 512 != 0) {
                if (mcX % 16 == 0 || mcZ % 16 == 0) {
                    color24 = ColorUtils.colorAdder(0x7D000000, color24);
                }
            } else {
                color24 = ColorUtils.colorAdder(2113863680, color24);
            }
        }
        return color24;
    }

    public static synchronized boolean isSlimeChunk(int mcX, int mcZ) {
        int xPosition = mcX >> 4;
        int zPosition = mcZ >> 4;
        String seedString = VoxelConstants.getVoxelMapInstance().getWorldSeed();
        if (seedString.isEmpty()) {
            return false;
        }
        if (!Objects.equals(lastSeed, seedString)) {
            lastSeed = seedString;
            lastSlimeX = Integer.MIN_VALUE;
            try {
                lastSeedLong = Long.parseLong(seedString);
            }
            catch (NumberFormatException var8) {
                lastSeedLong = seedString.hashCode();
            }
        }
        if (xPosition != lastSlimeX || zPosition != lastSlimeZ) {
            lastSlimeX = xPosition;
            lastSlimeZ = zPosition;
            slimeRandom.setSeed(lastSeedLong + (long)(xPosition * xPosition * 4987142) + (long)(xPosition * 5947611) + (long)(zPosition * zPosition) * 4392871L + (long)(zPosition * 389711) ^ 0x3AD8025FL);
            isSlimeChunk = slimeRandom.nextInt(10) == 0;
        }
        return isSlimeChunk;
    }

    static {
        slimeRandom = new Random();
    }
}

