/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.util.DynamicMoveableTexture;

public class ScaledDynamicMutableTexture
extends DynamicMoveableTexture {
    private final int scale;

    public ScaledDynamicMutableTexture(String label, int width, int height, boolean clear) {
        super(label, 512, 512, clear);
        this.scale = 512 / width;
    }

    @Override
    public int getWidth() {
        return this.method_4525().method_4307();
    }

    @Override
    public int getHeight() {
        return this.method_4525().method_4323();
    }

    @Override
    public void moveX(int offset) {
        super.moveX(offset * this.scale);
    }

    @Override
    public void moveY(int offset) {
        super.moveY(offset * this.scale);
    }

    @Override
    public void setRGB(int x, int y, int color24) {
        int alpha = color24 >> 24 & 0xFF;
        int a = -1;
        byte r = (byte)((color24 & 0xFF) * alpha / 255);
        byte g = (byte)((color24 >> 8 & 0xFF) * alpha / 255);
        byte b = (byte)((color24 >> 16 & 0xFF) * alpha / 255);
        int color = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        for (int t = 0; t < this.scale; ++t) {
            for (int s = 0; s < this.scale; ++s) {
                this.method_4525().method_61941(x * this.scale + t, y * this.scale + s, color);
            }
        }
    }
}

