/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.MobCategory;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_1011;
import net.minecraft.class_10539;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_9848;
import org.joml.Quaternionfc;

public class RadarSimple
implements IRadar {
    private LayoutVariables layoutVariables;
    public final MapSettingsManager minimapOptions;
    public final RadarSettingsManager options;
    private final TextureAtlas textureAtlas;
    public static final class_2960 resourceTextureAtlasMarker = class_2960.method_60655((String)"voxelmap", (String)"atlas/radarsimple/marker");
    private boolean completedLoading;
    private int timer = 500;
    private float direction;
    private final ArrayList<Contact> contacts = new ArrayList(40);

    public RadarSimple() {
        this.minimapOptions = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.options = VoxelConstants.getVoxelMapInstance().getRadarOptions();
        this.textureAtlas = new TextureAtlas("pings", resourceTextureAtlasMarker);
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        this.loadTexturePackIcons();
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            this.textureAtlas.reset();
            class_1011 contact = class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)class_2960.method_60655((String)"voxelmap", (String)"images/radar/contact.png")).comp_3447();
            contact = ImageUtils.fillOutline(contact, false, true, 32.0f, 32.0f, 0);
            this.textureAtlas.registerIconForBufferedImage((Object)"contact", contact);
            class_1011 facing = class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)class_2960.method_60655((String)"voxelmap", (String)"images/radar/contact_facing.png")).comp_3447();
            facing = ImageUtils.fillOutline(facing, false, true, 32.0f, 32.0f, 0);
            this.textureAtlas.registerIconForBufferedImage((Object)"facing", facing);
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception var4) {
            VoxelConstants.getLogger().error("Failed getting mobs " + var4.getLocalizedMessage(), (Throwable)var4);
        }
    }

    @Override
    public void onTickInGame(class_332 guiGraphics, LayoutVariables layoutVariables, float scaleProj) {
        if (this.options.radarAllowed || this.options.radarMobsAllowed || this.options.radarPlayersAllowed) {
            this.layoutVariables = layoutVariables;
            if (this.options.isChanged()) {
                this.timer = 500;
            }
            this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
            while (this.direction >= 360.0f) {
                this.direction -= 360.0f;
            }
            while (this.direction < 0.0f) {
                this.direction += 360.0f;
            }
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(guiGraphics, this.layoutVariables.mapX, this.layoutVariables.mapY, scaleProj);
            }
        }
    }

    public void calculateMobs() {
        this.contacts.clear();
        for (class_1297 entity : VoxelConstants.getClientWorld().method_18112()) {
            try {
                if (entity == null || entity.method_5756((class_1657)VoxelConstants.getPlayer()) || (!this.options.showHostiles || !this.options.radarAllowed && !this.options.radarMobsAllowed || !MobCategory.isHostile(entity)) && (!this.options.showPlayers || !this.options.radarAllowed && !this.options.radarPlayersAllowed || !MobCategory.isPlayer(entity)) && (!this.options.showNeutrals || !this.options.radarMobsAllowed || !MobCategory.isNeutral(entity))) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.method_19538().method_10216();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.method_19538().method_10215();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.method_19538().method_10214();
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                Contact contact2 = new Contact((class_1309)entity, MobCategory.forEntity(entity));
                this.contacts.add(contact2);
            }
            catch (Exception var11) {
                VoxelConstants.getLogger().error(var11.getLocalizedMessage(), (Throwable)var11);
            }
        }
        this.contacts.sort(Comparator.comparingDouble(contact -> contact.y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(class_332 guiGraphics, int x, int y, float scaleProj) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        for (Contact contact : this.contacts) {
            boolean inRange;
            int color;
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            double contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            double wayY = (double)GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - Math.abs(wayY);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            int n = color = wayY < 0.0 ? class_9848.method_61318((float)contact.brightness, (float)1.0f, (float)1.0f, (float)1.0f) : class_9848.method_61318((float)1.0f, (float)contact.brightness, (float)contact.brightness, (float)contact.brightness);
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            if (!this.minimapOptions.squareMap) {
                inRange = contact.distance < 31.0;
            } else {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                boolean bl = inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            }
            if (!inRange) continue;
            try {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(scaleProj, scaleProj, 1.0f);
                float contactFacing = contact.entity.method_5791();
                if (this.minimapOptions.rotates) {
                    contactFacing -= this.direction;
                } else if (this.minimapOptions.oldNorth) {
                    contactFacing += 90.0f;
                }
                guiGraphics.method_51448().method_46416((float)x, (float)y, 0.0f);
                guiGraphics.method_51448().method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-contact.angle));
                guiGraphics.method_51448().method_46416(0.0f, (float)(-contact.distance), 0.0f);
                guiGraphics.method_51448().method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(contact.angle + contactFacing));
                guiGraphics.method_51448().method_46416((float)(-x), (float)(-y), 0.0f);
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 125.0f);
                this.textureAtlas.getAtlasSprite("contact").blit(guiGraphics, GLUtils.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH, x - 4, y - 4, 8.0f, 8.0f, color);
                if (!this.options.showFacing) continue;
                this.textureAtlas.getAtlasSprite("facing").blit(guiGraphics, GLUtils.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH, x - 4, y - 4, 8.0f, 8.0f, color);
            }
            catch (Exception e) {
                VoxelConstants.getLogger().error("Error rendering mob icon! " + e.getLocalizedMessage() + " contact type " + String.valueOf(class_7923.field_41177.method_10221((Object)contact.entity.method_5864())));
            }
            finally {
                guiGraphics.method_51448().method_22909();
            }
        }
    }
}

