/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiSlotDimensions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.HashMap;
import net.minecraft.class_1074;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;

public class GuiAddWaypoint
extends GuiScreenMinimap
implements IPopupGuiScreen {
    private static final class_2960 BLANK = class_2960.method_60654((String)"textures/misc/white.png");
    private static final class_2960 PICKER = class_2960.method_60654((String)"voxelmap:images/colorpicker.png");
    private static final class_2960 TARGET = class_2960.method_60654((String)"voxelmap:images/waypoints/target.png");
    final WaypointManager waypointManager;
    final ColorManager colorManager;
    private final IGuiWaypoints parentGui;
    private PopupGuiButton doneButton;
    private GuiSlotDimensions dimensionList;
    protected DimensionContainer selectedDimension;
    private class_2561 tooltip;
    private class_342 waypointName;
    private class_342 waypointX;
    private class_342 waypointY;
    private class_342 waypointZ;
    private PopupGuiButton buttonEnabled;
    protected final Waypoint waypoint;
    private boolean choosingColor;
    private boolean choosingIcon;
    private final float red;
    private final float green;
    private final float blue;
    private final String suffix;
    private final boolean enabled;
    private final boolean editing;
    private HashMap<String, class_2960> waypointIconMap = new HashMap();

    public GuiAddWaypoint(IGuiWaypoints par1GuiScreen, Waypoint par2Waypoint, boolean editing) {
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.colorManager = VoxelConstants.getVoxelMapInstance().getColorManager();
        this.parentGui = par1GuiScreen;
        this.waypoint = par2Waypoint;
        this.red = this.waypoint.red;
        this.green = this.waypoint.green;
        this.blue = this.waypoint.blue;
        this.suffix = this.waypoint.imageSuffix;
        this.enabled = this.waypoint.enabled;
        this.editing = editing;
    }

    public void method_25393() {
    }

    public void method_25426() {
        this.method_37067();
        this.waypointName = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 13, 200, 20, (class_2561)class_2561.method_43470((String)""));
        this.waypointName.method_1852(this.waypoint.name);
        this.waypointX = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41 + 13, 56, 20, (class_2561)class_2561.method_43470((String)""));
        this.waypointX.method_1880(128);
        this.waypointX.method_1852(String.valueOf(this.waypoint.getX()));
        this.waypointY = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41 + 13, 56, 20, (class_2561)class_2561.method_43470((String)""));
        this.waypointY.method_1880(128);
        this.waypointY.method_1852(String.valueOf(this.waypoint.getY()));
        this.waypointZ = new class_342(this.getFontRenderer(), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41 + 13, 56, 20, (class_2561)class_2561.method_43470((String)""));
        this.waypointZ.method_1880(128);
        this.waypointZ.method_1852(String.valueOf(this.waypoint.getZ()));
        this.method_37063((class_364)this.waypointName);
        this.method_37063((class_364)this.waypointX);
        this.method_37063((class_364)this.waypointY);
        this.method_37063((class_364)this.waypointZ);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.buttonEnabled = new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY, 100, 20, (class_2561)class_2561.method_43470((String)("Enabled: " + (this.waypoint.enabled ? "On" : "Off"))), button -> {
            this.waypoint.enabled = !this.waypoint.enabled;
        }, this);
        this.method_37063((class_364)this.buttonEnabled);
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 24, 100, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.sortbycolor", (Object[])new Object[0]) + ":     ")), button -> {
            this.choosingColor = true;
        }, this));
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 48, 100, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.sortbyicon", (Object[])new Object[0]) + ":     ")), button -> {
            this.choosingIcon = true;
        }, this));
        this.doneButton = new PopupGuiButton(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, (class_2561)class_2561.method_43471((String)"addServer.add"), button -> this.acceptWaypoint(), this);
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, (class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.cancelWaypoint(), this));
        this.doneButton.field_22763 = !this.waypointName.method_1882().isEmpty();
        this.method_25395((class_364)this.waypointName);
        this.waypointName.method_25365(true);
        this.dimensionList = new GuiSlotDimensions(this);
        this.method_37063((class_364)this.dimensionList);
    }

    @Override
    public void method_25432() {
    }

    protected void cancelWaypoint() {
        this.waypoint.red = this.red;
        this.waypoint.green = this.green;
        this.waypoint.blue = this.blue;
        this.waypoint.imageSuffix = this.suffix;
        this.waypoint.enabled = this.enabled;
        if (this.parentGui != null) {
            this.parentGui.accept(false);
            return;
        }
        VoxelConstants.getMinecraft().method_1507(null);
    }

    protected void acceptWaypoint() {
        this.waypoint.name = this.waypointName.method_1882();
        this.waypoint.setX(Integer.parseInt(this.waypointX.method_1882()));
        this.waypoint.setY(Integer.parseInt(this.waypointY.method_1882()));
        this.waypoint.setZ(Integer.parseInt(this.waypointZ.method_1882()));
        if (this.parentGui != null) {
            this.parentGui.accept(true);
            return;
        }
        if (this.editing) {
            this.waypointManager.saveWaypoints();
            VoxelConstants.getMinecraft().method_1507(null);
            return;
        }
        this.waypointManager.addWaypoint(this.waypoint);
        VoxelConstants.getMinecraft().method_1507(null);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean OK = false;
        if (this.popupOpen()) {
            OK = super.method_25404(keyCode, scanCode, modifiers);
            boolean acceptable = !this.waypointName.method_1882().isEmpty();
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
            }
            catch (NumberFormatException var7) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
            if ((keyCode == 257 || keyCode == 335) && acceptable) {
                this.acceptWaypoint();
            }
        }
        return OK;
    }

    public boolean method_25400(char chr, int modifiers) {
        boolean OK = false;
        if (this.popupOpen()) {
            OK = super.method_25400(chr, modifiers);
            boolean acceptable = !this.waypointName.method_1882().isEmpty();
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
            }
            catch (NumberFormatException var6) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
        }
        return OK;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        float chooserCenterY;
        float chooserCenterX;
        TextureAtlas chooser;
        Sprite icon;
        if (this.popupOpen()) {
            super.method_25402(mouseX, mouseY, button);
            this.waypointName.method_25402(mouseX, mouseY, button);
            this.waypointX.method_25402(mouseX, mouseY, button);
            this.waypointY.method_25402(mouseX, mouseY, button);
            this.waypointZ.method_25402(mouseX, mouseY, button);
        } else if (this.choosingColor) {
            int pickerSize = 200;
            int pickerCenterX = this.getWidth() / 2 - pickerSize / 2;
            int pickerCenterY = this.getHeight() / 2 - pickerSize / 2;
            if (mouseX >= (double)pickerCenterX && mouseX <= (double)(pickerCenterX + pickerSize) && mouseY >= (double)pickerCenterY && mouseY <= (double)(pickerCenterY + pickerSize)) {
                int pickPointX = (int)((mouseX - (double)pickerCenterX) / (double)pickerSize * 255.0);
                int pickPointY = (int)((mouseY - (double)pickerCenterY) / (double)pickerSize * 255.0);
                int color = this.colorManager.getColorPicker().getRGB(pickPointX, pickPointY);
                this.waypoint.red = (float)(color >> 16 & 0xFF) / 255.0f;
                this.waypoint.green = (float)(color >> 8 & 0xFF) / 255.0f;
                this.waypoint.blue = (float)(color & 0xFF) / 255.0f;
                this.choosingColor = false;
            }
        } else if (this.choosingIcon && (icon = (chooser = this.waypointManager.getTextureAtlasChooser()).getIconAt((float)mouseX - (chooserCenterX = (float)this.getWidth() / 2.0f - (float)chooser.getWidth() / 2.0f), (float)mouseY - (chooserCenterY = (float)this.getHeight() / 2.0f - (float)chooser.getHeight() / 2.0f))) != chooser.getMissingImage()) {
            this.waypoint.imageSuffix = ((String)icon.getIconName()).replace("voxelmap:images/waypoints/waypoint", "").replace(".png", "");
            this.choosingIcon = false;
        }
        if (this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.method_25406(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return !this.popupOpen() || this.dimensionList == null || this.dimensionList.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        return !this.popupOpen() || this.dimensionList == null || this.dimensionList.method_25401(mouseX, mouseY, 0.0, amount);
    }

    @Override
    public boolean overPopup(int mouseX, int mouseY) {
        return !this.choosingColor && !this.choosingIcon;
    }

    @Override
    public boolean popupOpen() {
        return !this.choosingColor && !this.choosingIcon;
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        class_2960 waypointIcon;
        this.tooltip = null;
        this.buttonEnabled.method_25355((class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.enabled", (Object[])new Object[0]) + " " + (this.waypoint.enabled ? class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : class_1074.method_4662((String)"options.off", (Object[])new Object[0])))));
        this.renderBackgroundTexture(drawContext);
        drawContext.method_25300(this.getFontRenderer(), (this.parentGui == null || !this.parentGui.isEditing()) && !this.editing ? class_1074.method_4662((String)"minimap.waypoints.new", (Object[])new Object[0]) : class_1074.method_4662((String)"minimap.waypoints.edit", (Object[])new Object[0]), this.getWidth() / 2, 20, 0xFFFFFF);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"minimap.waypoints.name", (Object[])new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6, 0xFFFFFF);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"X", (Object[])new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41, 0xFFFFFF);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"Y", (Object[])new Object[0]), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41, 0xFFFFFF);
        drawContext.method_25303(this.getFontRenderer(), class_1074.method_4662((String)"Z", (Object[])new Object[0]), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41, 0xFFFFFF);
        super.method_25394(drawContext, this.choosingColor || this.choosingIcon ? 0 : mouseX, this.choosingColor || this.choosingIcon ? 0 : mouseY, delta);
        int buttonListY = this.getHeight() / 6 + 88;
        Object iconLocation = "voxelmap:images/waypoints/waypoint" + this.waypoint.imageSuffix + ".png";
        if (this.waypointIconMap.containsKey(iconLocation)) {
            waypointIcon = this.waypointIconMap.get(iconLocation);
        } else {
            waypointIcon = class_2960.method_60654((String)iconLocation);
            this.waypointIconMap.put((String)iconLocation, waypointIcon);
        }
        int color = this.waypoint.getUnifiedColor();
        drawContext.method_25291(class_1921::method_62277, BLANK, this.getWidth() / 2 - 25, buttonListY + 24 + 5, 0.0f, 0.0f, 16, 10, 16, 10, color);
        drawContext.method_25291(class_1921::method_62277, waypointIcon, this.getWidth() / 2 - 25, buttonListY + 48 + 2, 0.0f, 0.0f, 16, 16, 16, 16, color);
        drawContext.method_51448().method_46416(0.0f, 0.0f, 20.0f);
        if (this.choosingColor || this.choosingIcon) {
            this.renderBackgroundTexture(drawContext);
            if (this.choosingColor) {
                int pickerSize = 200;
                int pickerCenterX = this.getWidth() / 2 - pickerSize / 2;
                int pickerCenterY = this.getHeight() / 2 - pickerSize / 2;
                drawContext.method_25290(class_1921::method_62277, PICKER, pickerCenterX, pickerCenterY, 0.0f, 0.0f, pickerSize, pickerSize, pickerSize, pickerSize);
                if (mouseX >= pickerCenterX && mouseX <= pickerCenterX + pickerSize && mouseY >= pickerCenterY && mouseY <= pickerCenterY + pickerSize) {
                    int pickPointX = (int)((float)(mouseX - pickerCenterX) / (float)pickerSize * 255.0f);
                    int pickPointY = (int)((float)(mouseY - pickerCenterY) / (float)pickerSize * 255.0f);
                    color = this.colorManager.getColorPicker().getRGB(pickPointX, pickPointY);
                    int curR = color >> 16 & 0xFF;
                    int curG = color >> 8 & 0xFF;
                    int curB = color & 0xFF;
                    drawContext.method_25290(class_1921::method_62277, TARGET, mouseX - 8, mouseY - 8, 0.0f, 0.0f, 16, 16, 16, 16);
                    drawContext.method_25300(this.getFontRenderer(), "R: " + curR + ", G: " + curG + ", B: " + curB, this.getWidth() / 2, this.getHeight() / 2 + pickerSize / 2 + 8, color);
                }
            }
            if (this.choosingIcon) {
                TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
                int chooserCenterX = (int)((float)this.getWidth() / 2.0f - (float)chooser.getWidth() / 2.0f);
                int chooserCenterY = (int)((float)this.getHeight() / 2.0f - (float)chooser.getHeight() / 2.0f);
                Sprite icon = chooser.getIconAt(mouseX - chooserCenterX, mouseY - chooserCenterY);
                drawContext.method_25290(class_1921::method_62277, WaypointManager.resourceTextureAtlasWaypointChooser, chooserCenterX, chooserCenterY, 0.0f, 0.0f, chooser.getWidth(), chooser.getHeight(), chooser.getWidth(), chooser.getHeight());
                if (icon != chooser.getMissingImage()) {
                    iconLocation = (String)icon.getIconName();
                    if (this.waypointIconMap.containsKey(iconLocation)) {
                        waypointIcon = this.waypointIconMap.get(iconLocation);
                    } else {
                        waypointIcon = class_2960.method_60654((String)iconLocation);
                        this.waypointIconMap.put((String)iconLocation, waypointIcon);
                    }
                    int iconSnappedX = icon.getOriginX() + chooserCenterX;
                    int iconSnappedY = icon.getOriginY() + chooserCenterY;
                    drawContext.method_25291(class_1921::method_62277, waypointIcon, iconSnappedX - 4, iconSnappedY - 4, 0.0f, 0.0f, 40, 40, 40, 40, color);
                    Object iconName = ((String)icon.getIconName()).replace("voxelmap:images/waypoints/waypoint", "").replace(".png", "");
                    if (((String)iconName).length() > 1) {
                        iconName = ((String)iconName).substring(0, 1).toUpperCase() + ((String)iconName).substring(1).toLowerCase();
                    }
                    this.tooltip = class_2561.method_43470((String)iconName);
                }
            }
        }
        if (this.tooltip != null) {
            this.renderTooltip(drawContext, this.tooltip, mouseX, mouseY);
        }
    }

    public void setSelectedDimension(DimensionContainer dimension) {
        this.selectedDimension = dimension;
    }

    public void toggleDimensionSelected() {
        if (this.waypoint.dimensions.size() > 1 && this.waypoint.dimensions.contains(this.selectedDimension) && this.selectedDimension != VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_37908())) {
            this.waypoint.dimensions.remove(this.selectedDimension);
        } else {
            this.waypoint.dimensions.add(this.selectedDimension);
        }
    }

    static void setTooltip(GuiAddWaypoint par0GuiWaypoint, class_2561 par1Str) {
        par0GuiWaypoint.tooltip = par1Str;
    }
}

