/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_6382;
import net.minecraft.class_9848;

class GuiSlotWaypoints
extends class_350<WaypointItem> {
    private final ArrayList<WaypointItem> waypoints;
    private ArrayList<?> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";
    static final class_2561 TOOLTIP_ENABLE = class_2561.method_43471((String)"minimap.waypoints.enabletooltip");
    static final class_2561 TOOLTIP_DISABLE = class_2561.method_43471((String)"minimap.waypoints.disabletooltip");
    static final class_2561 TOOLTIP_HIGHLIGHT = class_2561.method_43471((String)"minimap.waypoints.highlighttooltip");
    static final class_2561 TOOLTIP_HIGHLIGHT_REMOVE = class_2561.method_43471((String)"minimap.waypoints.removehighlighttooltip");
    final class_2960 visibleIconIdentifier = class_2960.method_60654((String)"textures/gui/sprites/container/beacon/confirm.png");
    final class_2960 invisibleIconIdentifier = class_2960.method_60654((String)"textures/gui/sprites/container/beacon/cancel.png");
    final class_2960 highlightedIconIdentifier = class_2960.method_60654((String)"voxelmap:images/waypoints/target.png");
    protected long lastClicked;
    public boolean doubleClicked;

    GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(VoxelConstants.getMinecraft(), par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight() - 140, 54, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(new WaypointItem(this.parentGui, pt));
        }
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        this.waypointsFiltered.forEach(x -> this.method_25321((WaypointItem)x));
    }

    public void setSelected(WaypointItem entry) {
        super.method_25313((class_350.class_351)entry);
        if (this.method_25334() instanceof WaypointItem) {
            class_333 narratorManager = new class_333(VoxelConstants.getMinecraft());
            narratorManager.method_19788(class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{((WaypointItem)this.method_25334()).waypoint.name}).getString());
        }
        this.parentGui.setSelectedWaypoint(entry.waypoint);
    }

    protected boolean method_25332(int index) {
        return ((WaypointItem)this.waypointsFiltered.get((int)index)).waypoint.equals(this.parentGui.selectedWaypoint);
    }

    protected void sortBy(int sortKey, boolean ascending) {
        int order;
        int n = order = ascending ? 1 : -1;
        if (sortKey == 1) {
            ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> Double.compare(masterWaypointsList.indexOf(waypointEntry1.waypoint), masterWaypointsList.indexOf(waypointEntry2.waypoint)) * order);
        } else if (sortKey == 3) {
            if (ascending) {
                Collections.sort(this.waypoints);
            } else {
                this.waypoints.sort(Collections.reverseOrder());
            }
        } else if (sortKey == 2) {
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> String.CASE_INSENSITIVE_ORDER.compare(waypointEntry1.waypoint.name, waypointEntry2.waypoint.name) * order);
        } else if (sortKey == 4) {
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> {
                Waypoint waypoint1 = waypointEntry1.waypoint;
                Waypoint waypoint2 = waypointEntry2.waypoint;
                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                return Double.compare(hue1, hue2) * order;
            });
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        Iterator<?> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = ((WaypointItem)iterator.next()).waypoint;
            if (TextUtils.scrubCodes(waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
        this.waypointsFiltered.forEach(x -> this.method_25321((WaypointItem)x));
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.doubleClicked = System.currentTimeMillis() - this.lastClicked < 200L;
        this.lastClicked = System.currentTimeMillis();
        return super.method_25402(mouseX, mouseY, button);
    }

    public class WaypointItem
    extends class_350.class_351<WaypointItem>
    implements Comparable<WaypointItem> {
        private final GuiWaypoints parentGui;
        private final Waypoint waypoint;
        private final class_2960 iconSprite;

        protected WaypointItem(GuiWaypoints waypointScreen, Waypoint waypoint) {
            this.parentGui = waypointScreen;
            this.waypoint = waypoint;
            this.iconSprite = class_2960.method_60654((String)("voxelmap:images/waypoints/waypoint" + waypoint.imageSuffix + ".png"));
        }

        public void method_25343(class_332 drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            drawContext.method_25300(this.parentGui.getFontRenderer(), this.waypoint.name, this.parentGui.getWidth() / 2, y + 3, this.waypoint.getUnifiedColor());
            int padding = 3;
            int iconWidth = 16;
            if (mouseX >= x - padding && mouseY >= y && mouseX <= x + 215 + padding && mouseY <= y + entryHeight) {
                class_2561 tooltip;
                if (mouseX >= x + 215 - iconWidth - padding && mouseX <= x + 215 + padding) {
                    tooltip = this.waypoint.enabled ? TOOLTIP_DISABLE : TOOLTIP_ENABLE;
                } else if (mouseX >= x + padding && mouseX <= x + iconWidth + padding) {
                    tooltip = this.waypoint == this.parentGui.highlightedWaypoint ? TOOLTIP_HIGHLIGHT_REMOVE : TOOLTIP_HIGHLIGHT;
                } else {
                    String tooltipText = "X: " + this.waypoint.getX() + " Z: " + this.waypoint.getZ();
                    if (this.waypoint.getY() > ((GuiSlotWaypoints)GuiSlotWaypoints.this).field_22740.field_1687.method_31607()) {
                        tooltipText = tooltipText + " Y: " + this.waypoint.getY();
                    }
                    tooltip = class_2561.method_43470((String)tooltipText);
                }
                if (mouseX >= GuiSlotWaypoints.this.method_46426() && mouseX <= GuiSlotWaypoints.this.method_55442() && mouseY >= GuiSlotWaypoints.this.method_46427() && mouseY <= GuiSlotWaypoints.this.method_55443()) {
                    GuiWaypoints.setTooltip(GuiSlotWaypoints.this.parentGui, tooltip);
                }
            }
            drawContext.method_25290(class_1921::method_62277, this.waypoint.enabled ? GuiSlotWaypoints.this.visibleIconIdentifier : GuiSlotWaypoints.this.invisibleIconIdentifier, x + 198, y - 2, 0.0f, 0.0f, 18, 18, 18, 18);
            drawContext.method_25291(class_1921::method_62277, this.iconSprite, x, y - 2, 0.0f, 0.0f, 18, 18, 18, 18, this.waypoint.getUnifiedColor());
            if (this.waypoint == this.parentGui.highlightedWaypoint) {
                int redColor = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                drawContext.method_25291(class_1921::method_62277, GuiSlotWaypoints.this.highlightedIconIdentifier, x, y - 2, 0.0f, 0.0f, 18, 18, 18, 18, redColor);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (mouseY < (double)GuiSlotWaypoints.this.method_46427() || mouseY > (double)GuiSlotWaypoints.this.method_55443()) {
                return false;
            }
            GuiSlotWaypoints.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int iconWidth = 16;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - iconWidth - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                this.parentGui.toggleWaypointVisibility();
            } else if (mouseX >= (double)(leftEdge + padding) && mouseX <= (double)(leftEdge + iconWidth + padding)) {
                this.parentGui.setHighlightedWaypoint();
            } else if (GuiSlotWaypoints.this.doubleClicked) {
                this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            }
            return true;
        }

        @Override
        public int compareTo(WaypointItem o) {
            return this.waypoint.compareTo(o.waypoint);
        }
    }
}

