/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiSubworldEdit;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_299;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_743;
import net.minecraft.class_746;

public class GuiSubworldsSelect
extends GuiScreenMinimap
implements BooleanConsumer {
    private class_2561 title;
    private class_2561 select;
    private boolean multiworld;
    private class_342 newNameField;
    private boolean newWorld;
    private float yaw;
    private final class_5498 thirdPersonViewOrig;
    private String[] worlds;
    private final class_437 parent;
    final class_746 thePlayer;
    final class_746 camera;
    private final WaypointManager waypointManager;

    public GuiSubworldsSelect(class_437 parent) {
        class_638 clientWorld = VoxelConstants.getClientWorld();
        this.parent = parent;
        this.thePlayer = VoxelConstants.getPlayer();
        this.camera = new class_746(VoxelConstants.getMinecraft(), clientWorld, VoxelConstants.getMinecraft().method_1562(), this.thePlayer.method_3143(), new class_299(), false, false);
        this.camera.field_3913 = new class_743(VoxelConstants.getMinecraft().field_1690);
        this.camera.method_66246(new class_243(this.thePlayer.method_23317(), this.thePlayer.method_23318() + 0.35, this.thePlayer.method_23321()), this.thePlayer.method_36454(), 0.0f);
        this.yaw = this.thePlayer.method_36454();
        this.thirdPersonViewOrig = VoxelConstants.getMinecraft().field_1690.method_31044();
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
    }

    public void method_25426() {
        ArrayList<String> knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
        if (!(this.multiworld || this.waypointManager.isMultiworld() || VoxelConstants.isRealmServer())) {
            class_410 confirmScreen = new class_410((BooleanConsumer)this, (class_2561)class_2561.method_43471((String)"worldmap.multiworld.isthismultiworld"), (class_2561)class_2561.method_43471((String)"worldmap.multiworld.explanation"), (class_2561)class_2561.method_43471((String)"gui.yes"), (class_2561)class_2561.method_43471((String)"gui.no"));
            VoxelConstants.getMinecraft().method_1507((class_437)confirmScreen);
        } else {
            VoxelConstants.getMinecraft().field_1690.method_31043(class_5498.field_26664);
            VoxelConstants.getMinecraft().method_1504((class_1297)this.camera);
        }
        this.title = class_2561.method_43471((String)"worldmap.multiworld.title");
        this.select = class_2561.method_43471((String)"worldmap.multiworld.select");
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int buttonsPerRow = this.field_22789 / 150;
        if (buttonsPerRow == 0) {
            buttonsPerRow = 1;
        }
        int buttonWidth = this.field_22789 / buttonsPerRow - 5;
        int xSpacing = (this.field_22789 - buttonsPerRow * buttonWidth) / 2;
        class_4185 cancelBtn = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> VoxelConstants.getMinecraft().method_1507(null)).method_46434(centerX - 100, this.field_22790 - 30, 200, 20).method_46431();
        this.method_37063((class_364)cancelBtn);
        knownSubworldNames.sort((name1, name2) -> -String.CASE_INSENSITIVE_ORDER.compare(name1, name2));
        int numKnownSubworlds = knownSubworldNames.size();
        int completeRows = (int)Math.floor((float)(numKnownSubworlds + 1) / (float)buttonsPerRow);
        int lastRowShiftBy = (int)(Math.ceil((float)(numKnownSubworlds + 1) / (float)buttonsPerRow) * (double)buttonsPerRow - (double)(numKnownSubworlds + 1));
        this.worlds = new String[numKnownSubworlds];
        class_4185[] selectButtons = new class_4185[numKnownSubworlds + 1];
        class_4185[] editButtons = new class_4185[numKnownSubworlds + 1];
        for (int t = 0; t < numKnownSubworlds; ++t) {
            int shiftBy = 1;
            if (t / buttonsPerRow >= completeRows) {
                shiftBy = lastRowShiftBy + 1;
            }
            this.worlds[t] = knownSubworldNames.get(t);
            int tt = t;
            int i = (buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth;
            selectButtons[t] = new class_4185.class_7840((class_2561)class_2561.method_43470((String)this.worlds[t]), button -> this.worldSelected(this.worlds[tt])).method_46434(i + xSpacing, this.field_22790 - 60 - t / buttonsPerRow * 21, buttonWidth - 32, 20).method_46431();
            editButtons[t] = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\u2692"), button -> this.editWorld(this.worlds[tt])).method_46434(i + xSpacing + buttonWidth - 32, this.field_22790 - 60 - t / buttonsPerRow * 21, 30, 20).method_46431();
            this.method_37063((class_364)selectButtons[t]);
            this.method_37063((class_364)editButtons[t]);
        }
        int numButtons = selectButtons.length - 1;
        int i = (buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth;
        if (!this.newWorld) {
            selectButtons[numButtons] = new class_4185.class_7840((class_2561)class_2561.method_43470((String)("< " + class_1074.method_4662((String)"worldmap.multiworld.newname", (Object[])new Object[0]) + " >")), button -> {
                this.newWorld = true;
                this.newNameField.method_25365(true);
            }).method_46434(i + xSpacing, this.field_22790 - 60 - numButtons / buttonsPerRow * 21, buttonWidth - 2, 20).method_46431();
            this.method_37063((class_364)selectButtons[numButtons]);
        }
        this.newNameField = new class_342(this.getFontRenderer(), i + xSpacing + 1, this.field_22790 - 60 - numButtons / buttonsPerRow * 21 + 1, buttonWidth - 4, 18, (class_2561)class_2561.method_43470((String)""));
    }

    public void accept(boolean b) {
        if (!b) {
            VoxelConstants.getMinecraft().method_1507(this.parent);
        } else {
            this.multiworld = true;
            VoxelConstants.getMinecraft().method_1507((class_437)this);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.newWorld) {
            this.newNameField.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.newNameField.method_25370()) {
            String newName;
            this.newNameField.method_25404(keyCode, scanCode, modifiers);
            if ((keyCode == 257 || keyCode == 335) && this.newNameField.method_25370() && (newName = this.newNameField.method_1882()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.newNameField.method_25370()) {
            String newName;
            this.newNameField.method_25400(chr, modifiers);
            if (modifiers == 28 && (newName = this.newNameField.method_1882()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25393() {
        super.method_25393();
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int titleStringWidth = this.getFontRenderer().method_27525((class_5348)this.title);
        titleStringWidth = Math.max(titleStringWidth, this.getFontRenderer().method_27525((class_5348)this.select));
        drawContext.method_25294(this.field_22789 / 2 - titleStringWidth / 2 - 5, 0, this.field_22789 / 2 + titleStringWidth / 2 + 5, 27, -1073741824);
        drawContext.method_27534(this.getFontRenderer(), this.title, this.field_22789 / 2, 5, 0xFFFFFF);
        drawContext.method_27534(this.getFontRenderer(), this.select, this.field_22789 / 2, 15, 0xFF0000);
        this.camera.field_6004 = 0.0f;
        this.camera.method_36457(0.0f);
        this.camera.field_5982 = this.yaw;
        this.camera.method_36456(this.yaw);
        float var4 = 0.475f;
        this.camera.field_5971 = this.camera.field_6036 = this.thePlayer.method_23318();
        this.camera.field_6038 = this.camera.field_6014 = this.thePlayer.method_23317() - (double)var4 * Math.sin((double)this.yaw / 180.0 * Math.PI);
        this.camera.field_5989 = this.camera.field_5969 = this.thePlayer.method_23321() + (double)var4 * Math.cos((double)this.yaw / 180.0 * Math.PI);
        this.camera.method_23327(this.camera.field_6014, this.camera.field_6036, this.camera.field_5969);
        float var5 = 1.0f;
        this.yaw = (float)((double)this.yaw + (double)var5 * (1.0 + (double)0.7f * Math.cos((double)(this.yaw + 45.0f) / 45.0 * Math.PI)));
        super.method_25394(drawContext, mouseX, mouseY, delta);
        if (this.newWorld) {
            this.newNameField.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    @Override
    public void method_25432() {
        super.method_25432();
        VoxelConstants.getMinecraft().field_1690.method_31043(this.thirdPersonViewOrig);
        VoxelConstants.getMinecraft().method_1504((class_1297)this.thePlayer);
    }

    private void worldSelected(String selectedSubworldName) {
        this.waypointManager.setSubworldName(selectedSubworldName, false);
        VoxelConstants.getMinecraft().method_1507(this.parent);
    }

    private void editWorld(String subworldNameToEdit) {
        VoxelConstants.getMinecraft().method_1507((class_437)new GuiSubworldEdit(this, subworldNameToEdit));
    }
}

