/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui.overridden;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiScreen;
import java.util.ArrayList;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class Popup {
    private final class_327 fontRendererObj;
    private int x;
    private int y;
    private final PopupEntry[] entries;
    private int w;
    private final int h;
    private final int clickedDirectX;
    private final int clickedDirectY;
    private boolean shouldClose;
    private final PopupGuiScreen parentGui;
    private final int padding = 6;

    public Popup(int x, int y, int directX, int directY, ArrayList<PopupEntry> entries, PopupGuiScreen parentGui) {
        this.fontRendererObj = VoxelConstants.getMinecraft().field_1772;
        this.parentGui = parentGui;
        this.clickedDirectX = directX;
        this.clickedDirectY = directY;
        this.x = x - 1;
        this.y = y - 1;
        this.entries = new PopupEntry[entries.size()];
        entries.toArray(this.entries);
        this.w = 0;
        this.h = this.entries.length * 20;
        for (PopupEntry entry : this.entries) {
            int entryWidth = this.fontRendererObj.method_1727(entry.name);
            if (entryWidth <= this.w) continue;
            this.w = entryWidth;
        }
        this.w += this.padding * 2;
        if (x + this.w > parentGui.field_22789) {
            this.x = x - this.w + 2;
        }
        if (y + this.h > parentGui.field_22790) {
            this.y = y - this.h + 2;
        }
    }

    public int getClickedDirectX() {
        return this.clickedDirectX;
    }

    public int getClickedDirectY() {
        return this.clickedDirectY;
    }

    public boolean clickedMe(double mouseX, double mouseY) {
        boolean clicked;
        boolean bl = clicked = mouseX > (double)this.x && mouseX < (double)(this.x + this.w) && mouseY > (double)this.y && mouseY < (double)(this.y + this.h);
        if (clicked) {
            for (int t = 0; t < this.entries.length; ++t) {
                boolean entryClicked;
                if (!this.entries[t].enabled) continue;
                boolean bl2 = entryClicked = mouseX >= (double)this.x && mouseX <= (double)(this.x + this.w) && mouseY >= (double)(this.y + t * 20) && mouseY <= (double)(this.y + (t + 1) * 20);
                if (!entryClicked) continue;
                this.shouldClose = this.entries[t].causesClose;
                this.parentGui.popupAction(this, this.entries[t].action);
            }
        }
        return clicked;
    }

    public boolean overMe(int x, int y) {
        return x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h;
    }

    public boolean shouldClose() {
        return this.shouldClose;
    }

    public void drawPopup(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 10.0f);
        guiGraphics.method_64039(bufferSource -> {
            Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
            class_1921 renderType = class_1921.method_62277((class_2960)VoxelConstants.getOptionsBackgroundTexture());
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            float renderedTextureSize = 32.0f;
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)(this.y + this.h), 0.0f).method_22913((float)this.x / renderedTextureSize, (float)this.y / renderedTextureSize).method_1336(64, 64, 64, 255);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)(this.y + this.h), 0.0f).method_22913((float)(this.x + this.w) / renderedTextureSize, (float)this.y / renderedTextureSize).method_1336(64, 64, 64, 255);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)this.y, 0.0f).method_22913((float)(this.x + this.w) / renderedTextureSize, (float)(this.y + this.h) / renderedTextureSize).method_1336(64, 64, 64, 255);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)this.y, 0.0f).method_22913((float)this.x / renderedTextureSize, (float)(this.y + this.h) / renderedTextureSize).method_1336(64, 64, 64, 255);
            renderType = class_1921.method_51784();
            vertexConsumer = bufferSource.getBuffer(renderType);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)(this.y + 4), 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)(this.y + 4), 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)this.y, 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)this.y, 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)(this.y + this.h), 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)(this.y + this.h), 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)(this.y + this.h - 4), 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)(this.y + this.h - 4), 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)this.y, 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)this.x, (float)(this.y + this.h), 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + 4), (float)(this.y + this.h), 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + 4), (float)this.y, 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w - 4), (float)this.y, 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w - 4), (float)(this.y + this.h), 0.0f).method_1336(0, 0, 0, 0);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)(this.y + this.h), 0.0f).method_1336(0, 0, 0, 255);
            vertexConsumer.method_22918(matrix4f, (float)(this.x + this.w), (float)this.y, 0.0f).method_1336(0, 0, 0, 255);
        });
        for (int t = 0; t < this.entries.length; ++t) {
            int color = !this.entries[t].enabled ? 0xA0A0A0 : (mouseX >= this.x && mouseX <= this.x + this.w && mouseY >= this.y + t * 20 && mouseY <= this.y + (t + 1) * 20 ? 0xFFFFA0 : 0xE0E0E0);
            guiGraphics.method_25303(this.fontRendererObj, this.entries[t].name, this.x + this.padding, this.y + this.padding + t * 20, color);
        }
        guiGraphics.method_51448().method_22909();
    }

    public static class PopupEntry {
        protected final String name;
        protected final int action;
        protected final boolean causesClose;
        protected final boolean enabled;

        public PopupEntry(String name, int action, boolean causesClose, boolean enabled) {
            this.name = name;
            this.action = action;
            this.causesClose = causesClose;
            this.enabled = enabled;
        }
    }
}

