/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.packets;

import com.google.gson.Gson;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record VoxelmapSettingsS2C(String settingsJson) implements class_8710
{
    public static final class_8710.class_9154<VoxelmapSettingsS2C> PACKET_ID = new class_8710.class_9154(class_2960.method_60655((String)"voxelmap", (String)"settings"));
    public static final class_9139<class_2540, VoxelmapSettingsS2C> PACKET_CODEC = class_9139.method_56438(VoxelmapSettingsS2C::write, VoxelmapSettingsS2C::new);

    public VoxelmapSettingsS2C(class_2540 buf) {
        this(VoxelmapSettingsS2C.parse(buf));
    }

    private static String parse(class_2540 buf) {
        buf.readByte();
        return buf.method_19772();
    }

    public void write(class_2540 buf) {
        buf.method_52997(0);
        buf.method_10814(this.settingsJson);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public static void parsePacket(VoxelmapSettingsS2C packet) {
        Map settings = (Map)new Gson().fromJson(packet.settingsJson(), Map.class);
        block24: for (Map.Entry entry : settings.entrySet()) {
            String setting = (String)entry.getKey();
            Object value = entry.getValue();
            switch (setting) {
                case "worldName": {
                    if (value instanceof String) {
                        String worldName = (String)value;
                        class_310.method_1551().execute(() -> {
                            VoxelConstants.getLogger().info("Received world name from settings: " + worldName);
                            VoxelConstants.getVoxelMapInstance().newSubWorldName(worldName, true);
                        });
                        continue block24;
                    }
                    VoxelConstants.getLogger().warn("Invalid world name: " + String.valueOf(value));
                    continue block24;
                }
                case "radarAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarAllowed = (Boolean)value;
                    continue block24;
                }
                case "radarMobsAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarMobsAllowed = (Boolean)value;
                    continue block24;
                }
                case "radarPlayersAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarPlayersAllowed = (Boolean)value;
                    continue block24;
                }
                case "cavesAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().cavesAllowed = (Boolean)value;
                    continue block24;
                }
                case "minimapAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().minimapAllowed = (Boolean)value;
                    continue block24;
                }
                case "worldmapAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().worldmapAllowed = (Boolean)value;
                    continue block24;
                }
                case "waypointsAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().waypointsAllowed = (Boolean)value;
                    continue block24;
                }
                case "deathWaypointAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().deathWaypointAllowed = (Boolean)value;
                    continue block24;
                }
                case "teleportCommand": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().serverTeleportCommand = (String)value;
                    continue block24;
                }
            }
            VoxelConstants.getLogger().warn("Unknown configuration option " + setting);
        }
    }
}

