/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.CompressionUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.UUID;
import java.util.zip.DataFormatException;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public class CompressibleGLBufferedImage {
    private static final HashMap<Integer, ByteBuffer> byteBuffers = new HashMap(4);
    private static final int DEFAULT_SIZE = 256;
    private static final ByteBuffer defaultSizeBuffer = ByteBuffer.allocateDirect(262144).order(ByteOrder.nativeOrder());
    private byte[] bytes;
    private final int width;
    private final int height;
    private final Object bufferLock = new Object();
    private boolean isCompressed;
    private final boolean compressNotDelete;
    private final class_2960 location = class_2960.method_60655((String)"voxelmap", (String)("mapimage/" + String.valueOf(UUID.randomUUID())));
    private class_1043 texture;

    public CompressibleGLBufferedImage(int width, int height, int imageType) {
        this.width = width;
        this.height = height;
        this.bytes = new byte[width * height * 4];
        this.compressNotDelete = VoxelConstants.getVoxelMapInstance().getPersistentMapOptions().outputImages;
    }

    public byte[] getData() {
        if (this.isCompressed) {
            this.decompress();
        }
        return this.bytes;
    }

    public class_2960 getTextureLocation() {
        return this.texture != null ? this.location : null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void deleteTexture() {
        if (!RenderSystem.isOnRenderThread()) {
            VoxelConstants.getLogger().log(Level.WARN, "Texture unload call from wrong thread", (Throwable)new Exception());
            return;
        }
        if (this.texture != null) {
            class_310.method_1551().method_1531().method_4615(this.location);
            this.texture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadToTexture() {
        ByteBuffer buffer;
        if (!RenderSystem.isOnRenderThread()) {
            VoxelConstants.getLogger().log(Level.WARN, "Texture upload call from wrong thread", (Throwable)new Exception());
            return;
        }
        if (this.isCompressed) {
            this.decompress();
        }
        if (this.texture == null) {
            this.texture = new class_1043(() -> "", new class_1011(class_1011.class_1012.field_4997, this.width, this.height, false));
            this.texture.method_65924(true);
            class_310.method_1551().method_1531().method_4616(this.location, (class_1044)this.texture);
        }
        if ((buffer = byteBuffers.get(this.width * this.height)) == null) {
            buffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder());
            byteBuffers.put(this.width * this.height, buffer);
        }
        buffer.clear();
        Object object = this.bufferLock;
        synchronized (object) {
            buffer.put(this.bytes);
            buffer.position(0).limit(this.bytes.length);
        }
        int imageBytes = this.width * this.height * this.texture.method_4525().method_4318().method_4335();
        ByteBuffer outBuffer = MemoryUtil.memByteBuffer((long)this.texture.method_4525().method_67769(), (int)imageBytes);
        MemoryUtil.memCopy((ByteBuffer)buffer, (ByteBuffer)outBuffer);
        this.texture.method_4524();
        GL11.glBindTexture((int)3553, (int)((class_10868)this.texture.method_68004()).method_68427());
        GL30.glGenerateMipmap((int)3553);
        this.compress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(int x, int y, int color) {
        if (this.isCompressed) {
            this.decompress();
        }
        int index = (x + y * this.getWidth()) * 4;
        Object object = this.bufferLock;
        synchronized (object) {
            int alpha = color >> 24 & 0xFF;
            this.bytes[index + 0] = (byte)((color >> 16 & 0xFF) * alpha / 255);
            this.bytes[index + 1] = (byte)((color >> 8 & 0xFF) * alpha / 255);
            this.bytes[index + 2] = (byte)((color & 0xFF) * alpha / 255);
            this.bytes[index + 3] = -1;
        }
    }

    private synchronized void compress() {
        if (!this.isCompressed) {
            this.bytes = (byte[])(this.compressNotDelete ? CompressionUtils.compress(this.bytes) : null);
            this.isCompressed = true;
        }
    }

    private synchronized void decompress() {
        if (this.isCompressed) {
            if (this.compressNotDelete) {
                try {
                    this.bytes = CompressionUtils.decompress(this.bytes);
                }
                catch (DataFormatException dataFormatException) {}
            } else {
                this.bytes = new byte[this.width * this.height * 4];
                this.isCompressed = false;
            }
        }
    }

    static {
        byteBuffers.put(65536, defaultSizeBuffer);
    }
}

