/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class Sprite {
    private final Object iconName;
    protected class_1011 imageData;
    protected int originX;
    protected int originY;
    protected int width;
    protected int height;
    private float minU;
    private float maxU;
    private float minV;
    private float maxV;
    private TextureAtlas textureAtlas;

    public Sprite(Object iconName, TextureAtlas textureAtlas) {
        this.iconName = iconName;
        this.textureAtlas = textureAtlas;
    }

    public static Sprite spriteFromResourceLocation(class_2960 resourceLocation, TextureAtlas textureAtlas) {
        String name = resourceLocation.toString();
        return Sprite.spriteFromString(name, textureAtlas);
    }

    public static Sprite spriteFromString(Object name, TextureAtlas textureAtlas) {
        return new Sprite(name, textureAtlas);
    }

    public void initSprite(int sheetWidth, int sheetHeight, int originX, int originY) {
        this.originX = originX;
        this.originY = originY;
        float var6 = (float)((double)0.01f / (double)sheetWidth);
        float var7 = (float)((double)0.01f / (double)sheetHeight);
        this.minU = (float)originX / (float)sheetWidth + var6;
        this.maxU = (float)(originX + this.width) / (float)sheetWidth - var6;
        this.minV = (float)originY / (float)sheetHeight + var7;
        this.maxV = (float)(originY + this.height) / (float)sheetHeight - var7;
    }

    public void copyFrom(Sprite sourceSprite) {
        this.originX = sourceSprite.originX;
        this.originY = sourceSprite.originY;
        this.width = sourceSprite.width;
        this.height = sourceSprite.height;
        this.minU = sourceSprite.minU;
        this.maxU = sourceSprite.maxU;
        this.minV = sourceSprite.minV;
        this.maxV = sourceSprite.maxV;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public float getMinU() {
        return this.minU;
    }

    public float getMaxU() {
        return this.maxU;
    }

    public float getMinV() {
        return this.minV;
    }

    public float getMaxV() {
        return this.maxV;
    }

    public Object getIconName() {
        return this.iconName;
    }

    public class_1011 getTextureData() {
        return this.imageData;
    }

    public void setIconWidth(int width) {
        this.width = width;
    }

    public void setIconHeight(int height) {
        this.height = height;
    }

    public void setTextureData(class_1011 imageData) {
        if (this.imageData != null) {
            this.imageData.close();
        }
        this.imageData = imageData;
        if (imageData != null) {
            this.width = imageData.method_4307();
            this.height = imageData.method_4323();
        }
    }

    public String toString() {
        return "Sprite{name='" + String.valueOf(this.iconName) + "', x=" + this.originX + ", y=" + this.originY + ", height=" + this.height + ", width=" + this.width + ", u0=" + this.minU + ", u1=" + this.maxU + ", v0=" + this.minV + ", v1=" + this.maxV + "}";
    }

    public void blit(class_332 guiGraphics, Function<class_2960, class_1921> renderTypeMap, float x, float y, float w, float h) {
        this.blit(guiGraphics, renderTypeMap, x, y, h, w, -1);
    }

    public void blit(class_332 guiGraphics, Function<class_2960, class_1921> renderTypeMap, float x, float y, float w, float h, int color) {
        guiGraphics.method_64039(bufferSource -> {
            class_1921 renderType = (class_1921)renderTypeMap.apply(this.textureAtlas.getResourceLocation());
            Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            vertexConsumer.method_22918(matrix4f, x, y, 0.0f).method_22913(this.getMinU(), this.getMinV()).method_39415(color);
            vertexConsumer.method_22918(matrix4f, x, y + h, 0.0f).method_22913(this.getMinU(), this.getMaxV()).method_39415(color);
            vertexConsumer.method_22918(matrix4f, x + w, y + h, 0.0f).method_22913(this.getMaxU(), this.getMaxV()).method_39415(color);
            vertexConsumer.method_22918(matrix4f, x + w, y, 0.0f).method_22913(this.getMaxU(), this.getMinV()).method_39415(color);
        });
    }

    public class_2960 getResourceLocation() {
        return this.textureAtlas.getResourceLocation();
    }
}

