/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class DimensionManager {
    public final ArrayList<DimensionContainer> dimensions;
    private final ArrayList<class_5321<class_1937>> vanillaWorlds = new ArrayList();

    public DimensionManager() {
        this.dimensions = new ArrayList();
        this.vanillaWorlds.add((class_5321<class_1937>)class_1937.field_25179);
        this.vanillaWorlds.add((class_5321<class_1937>)class_1937.field_25180);
        this.vanillaWorlds.add((class_5321<class_1937>)class_1937.field_25181);
    }

    public ArrayList<DimensionContainer> getDimensions() {
        return this.dimensions;
    }

    public void populateDimensions(class_1937 world) {
        this.dimensions.clear();
        class_2378 dimensionTypeRegistry = VoxelConstants.getMinecraft().method_1562().method_29091().method_30530(class_7924.field_41241);
        for (class_5321<class_1937> vanillaWorldKey : this.vanillaWorlds) {
            class_5321 typeKey = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)vanillaWorldKey.method_29177());
            class_2874 dimensionType = (class_2874)((class_6880.class_6883)dimensionTypeRegistry.method_46746(typeKey).get()).comp_349();
            DimensionContainer dimensionContainer = new DimensionContainer(dimensionType, vanillaWorldKey.method_29177().method_12832(), vanillaWorldKey.method_29177());
            this.dimensions.add(dimensionContainer);
        }
        this.sort();
    }

    public void enteredWorld(class_1937 world) {
        class_2960 resourceLocation = world.method_27983().method_29177();
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(world.method_8597(), resourceLocation.method_12832(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        if (dim.type == null) {
            try {
                dim.type = world.method_8597();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void sort() {
        this.dimensions.sort((dim1, dim2) -> {
            if (dim1.resourceLocation.equals((Object)class_1937.field_25179.method_29177())) {
                return -1;
            }
            if (dim1.resourceLocation.equals((Object)class_1937.field_25180.method_29177()) && !dim2.resourceLocation.equals((Object)class_1937.field_25179.method_29177())) {
                return -1;
            }
            return dim1.resourceLocation.equals((Object)class_1937.field_25181.method_29177()) && !dim2.resourceLocation.equals((Object)class_1937.field_25179.method_29177()) && !dim2.resourceLocation.equals((Object)class_1937.field_25180.method_29177()) ? -1 : String.CASE_INSENSITIVE_ORDER.compare(dim1.name, dim2.name);
        });
    }

    public DimensionContainer getDimensionContainerByWorld(class_1937 world) {
        class_2960 resourceLocation = world.method_27983().method_29177();
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(world.method_8597(), resourceLocation.method_12832(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    public DimensionContainer getDimensionContainerByIdentifier(String ident) {
        class_2960 resourceLocation = class_2960.method_60654((String)ident);
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(null, resourceLocation.method_12832(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    public DimensionContainer getDimensionContainerByResourceLocation(class_2960 resourceLocation) {
        return this.dimensions.stream().filter(dim -> resourceLocation.equals((Object)dim.resourceLocation)).findFirst().orElse(null);
    }
}

