/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraft.class_9848;
import net.minecraft.class_9851;

public class GLUtils {
    public static final RenderPipeline GUI_TEXTURED_EQUAL_DEPTH_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/gui_textured_equal_depth")).withDepthTestFunction(DepthTestFunction.EQUAL_DEPTH_TEST).build();
    public static final Function<class_2960, class_1921> GUI_TEXTURED_EQUAL_DEPTH = class_156.method_34866(resourceLocation -> class_1921.method_24048((String)"voxelmap_gui_textured_equal_depth", (int)49152, (RenderPipeline)GUI_TEXTURED_EQUAL_DEPTH_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, class_9851.field_52394, false)).method_23617(false)));
    public static final RenderPipeline GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/gui_textured_equal_depth")).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
    public static final Function<class_2960, class_1921> GUI_TEXTURED_LESS_OR_EQUAL_DEPTH = class_156.method_34866(resourceLocation -> class_1921.method_24048((String)"voxelmap_gui_textured_lequal_depth", (int)49152, (RenderPipeline)GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, class_9851.field_52394, false)).method_23617(false)));
    public static final Function<class_2960, class_1921> GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_FILTER_MIN = class_156.method_34866(resourceLocation -> class_1921.method_24048((String)"voxelmap_gui_textured_lequal_depth_filter_min", (int)49152, (RenderPipeline)GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new ExtendedTextureStateShard((class_2960)resourceLocation, FilterMode.LINEAR, FilterMode.NEAREST, true)).method_23617(false)));
    public static final RenderPipeline WAYPOINT_BEAM_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56849}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/waypoint_beam")).withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withBlend(BlendFunction.LIGHTNING).withDepthWrite(false).build();
    public static final class_1921 WAYPOINT_BEAM = class_1921.method_24048((String)"voxelmap_waypoint_beam", (int)49152, (RenderPipeline)WAYPOINT_BEAM_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
    public static final RenderPipeline WAYPOINT_ICON_DEPTHTEST_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/waypoint_icon")).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA)).withDepthWrite(true).build();
    public static final RenderPipeline WAYPOINT_ICON_NO_DEPTHTEST_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/waypoint_icon")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA)).withDepthWrite(true).build();
    public static final Function<class_2960, class_1921> WAYPOINT_ICON_DEPTHTEST = class_156.method_34866(resourceLocation -> class_1921.method_24048((String)"voxelmap_icon_depthtest", (int)49152, (RenderPipeline)WAYPOINT_ICON_DEPTHTEST_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, class_9851.field_52394, false)).method_23617(false)));
    public static final Function<class_2960, class_1921> WAYPOINT_ICON_NO_DEPTHTEST = class_156.method_34866(resourceLocation -> class_1921.method_24048((String)"voxelmap_icon_no_depthtest", (int)49152, (RenderPipeline)WAYPOINT_ICON_NO_DEPTHTEST_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, class_9851.field_52394, false)).method_23617(false)));
    public static final RenderPipeline WAYPOINT_TEXT_BACKGROUND_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56863}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/waypoint_background")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthBias(1.0f, 7.0f).withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA)).withDepthWrite(false).build();
    public static final class_1921 WAYPOINT_TEXT_BACKGROUND = class_1921.method_24048((String)"voxelmap_beacon_text_background", (int)49152, (RenderPipeline)WAYPOINT_TEXT_BACKGROUND_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
    public static final VertexFormat VF = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).add("UV1", VertexFormatElement.UV1).add("UV2", VertexFormatElement.UV2).add("Normal", VertexFormatElement.NORMAL).padding(1).build();
    public static final RenderPipeline ENTITY_ICON = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56854}).withLocation(class_2960.method_60654((String)"voxelmap:pipeline/entity_solid")).withSampler("Sampler1").withVertexFormat(VF, VertexFormat.class_5596.field_27382).withShaderDefine("EMISSIVE").withShaderDefine("NO_OVERLAY").withShaderDefine("NO_CARDINAL_LIGHTING").withShaderDefine("ALPHA_CUTOUT", 0.1f).withBlend(BlendFunction.TRANSLUCENT).build();

    public static void readTextureContentsToPixelArray(GpuTexture gpuTexture, Consumer<int[]> resultConsumer) {
        Preconditions.checkNotNull(resultConsumer);
        int size = gpuTexture.getWidth(0) * gpuTexture.getHeight(0);
        int bufferSize = gpuTexture.getFormat().pixelSize() * size;
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Texture read buffer", BufferType.PIXEL_PACK, BufferUsage.STATIC_READ, bufferSize);
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        commandEncoder.copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
            try (GpuBuffer.ReadView readView = commandEncoder.readBuffer(gpuBuffer);){
                int[] pixels = new int[size];
                readView.data().asIntBuffer().get(0, pixels);
                resultConsumer.accept(pixels);
            }
            finally {
                gpuBuffer.close();
            }
        }, 0);
    }

    public static void readTextureContentsToBufferedImage(GpuTexture gpuTexture, Consumer<BufferedImage> resultConsumer) {
        RenderSystem.assertOnRenderThread();
        int bytePerPixel = gpuTexture.getFormat().pixelSize();
        int width = gpuTexture.getWidth(0);
        int height = gpuTexture.getHeight(0);
        int bufferSize = bytePerPixel * width * height;
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Texture read buffer", BufferType.PIXEL_PACK, BufferUsage.STATIC_READ, bufferSize);
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        commandEncoder.copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
            BufferedImage image = new BufferedImage(width, height, 6);
            try (GpuBuffer.ReadView readView = commandEncoder.readBuffer(gpuBuffer);){
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = readView.data().getInt((x + y * width) * bytePerPixel);
                        image.setRGB(x, y, class_9848.method_61338((int)pixel));
                    }
                }
            }
            gpuBuffer.close();
            resultConsumer.accept(image);
        }, 0);
    }

    public static class ExtendedTextureStateShard
    extends class_4668.class_5939 {
        private final Optional<class_2960> texture;
        private final FilterMode minFilter;
        private final FilterMode magFilter;
        private final boolean mipmap;

        public ExtendedTextureStateShard(class_2960 resourceLocation, FilterMode minFilter, FilterMode magFilter, boolean mipmap) {
            super(() -> {
                class_1060 textureManager = class_310.method_1551().method_1531();
                class_1044 abstractTexture = textureManager.method_4619(resourceLocation);
                abstractTexture.method_68004().setTextureFilter(minFilter, magFilter, mipmap);
                RenderSystem.setShaderTexture((int)0, (GpuTexture)abstractTexture.method_68004());
            }, () -> {});
            this.texture = Optional.of(resourceLocation);
            this.minFilter = minFilter;
            this.magFilter = magFilter;
            this.mipmap = mipmap;
        }

        public String toString() {
            return this.field_21363 + "[" + String.valueOf(this.texture) + "(minFilter=" + String.valueOf(this.minFilter) + ", magFilter=" + String.valueOf(this.magFilter) + ", mipmap=" + this.mipmap + ")]";
        }

        protected Optional<class_2960> method_23564() {
            return this.texture;
        }
    }
}

