/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class WaypointContainer {
    private final List<Waypoint> wayPts = new ArrayList<Waypoint>();
    private Waypoint highlightedWaypoint;
    public final MapSettingsManager options;
    public final class_310 minecraft = class_310.method_1551();

    public WaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.wayPts.remove(waypoint);
    }

    public void setHighlightedWaypoint(Waypoint highlightedWaypoint) {
        this.highlightedWaypoint = highlightedWaypoint;
    }

    private void sortWaypoints() {
        this.wayPts.sort(Collections.reverseOrder());
    }

    public void renderWaypoints(float gameTimeDeltaPartialTick, class_4587 poseStack, class_4597.class_4598 bufferSource, class_4184 camera) {
        int z;
        int x;
        this.sortWaypoints();
        class_243 cameraPos = camera.method_19326();
        double renderPosX = cameraPos.field_1352;
        double renderPosY = cameraPos.field_1351;
        double renderPosZ = cameraPos.field_1350;
        if (this.options.showBeacons) {
            for (Waypoint pt : this.wayPts) {
                if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
                x = pt.getX();
                z = pt.getZ();
                double bottomOfWorld = (double)VoxelConstants.getPlayer().method_37908().method_31607() - renderPosY;
                this.renderBeam(pt, (double)x - renderPosX, bottomOfWorld, (double)z - renderPosZ, poseStack, bufferSource);
            }
        }
        if (this.options.showWaypoints) {
            for (Waypoint pt : this.wayPts) {
                if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
                x = pt.getX();
                z = pt.getZ();
                int y = pt.getY();
                double distance = Math.sqrt(pt.getDistanceSqToCamera(camera));
                if (!(distance < (double)this.options.maxWaypointDisplayDistance) && this.options.maxWaypointDisplayDistance >= 0 && pt != this.highlightedWaypoint || VoxelConstants.getMinecraft().field_1690.field_1842) continue;
                boolean isPointedAt = this.isPointedAt(pt, distance, camera);
                String label = pt.name;
                this.renderLabel(poseStack, bufferSource, pt, distance, isPointedAt, label, false, (double)x - renderPosX, (double)y - renderPosY + 1.12, (double)z - renderPosZ);
            }
            if (this.highlightedWaypoint != null && !VoxelConstants.getMinecraft().field_1690.field_1842) {
                int x2 = this.highlightedWaypoint.getX();
                int z2 = this.highlightedWaypoint.getZ();
                int y = this.highlightedWaypoint.getY();
                double distance = Math.sqrt(this.highlightedWaypoint.getDistanceSqToCamera(camera));
                boolean isPointedAt = this.isPointedAt(this.highlightedWaypoint, distance, camera);
                this.renderLabel(poseStack, bufferSource, this.highlightedWaypoint, distance, isPointedAt, "", true, (double)x2 - renderPosX, (double)y - renderPosY + 1.12, (double)z2 - renderPosZ);
            }
        }
    }

    private boolean isPointedAt(Waypoint waypoint, double distance, class_4184 camera) {
        class_243 cameraPos = camera.method_19326();
        double degrees = 5.0 + Math.min(5.0 / distance, 5.0);
        double angle = degrees * 0.0174533;
        double size = Math.sin(angle) * distance;
        Vector3f cameraPosPlusDirection = camera.method_19335();
        class_243 cameraPosPlusDirectionTimesDistance = cameraPos.method_1031((double)cameraPosPlusDirection.x * distance, (double)cameraPosPlusDirection.y * distance, (double)cameraPosPlusDirection.z * distance);
        class_238 axisalignedbb = new class_238((double)((float)waypoint.getX() + 0.5f) - size, (double)((float)waypoint.getY() + 1.65f) - size, (double)((float)waypoint.getZ() + 0.5f) - size, (double)((float)waypoint.getX() + 0.5f) + size, (double)((float)waypoint.getY() + 1.5f) + size, (double)((float)waypoint.getZ() + 0.5f) + size);
        Optional raytraceresult = axisalignedbb.method_992(cameraPos, cameraPosPlusDirectionTimesDistance);
        if (axisalignedbb.method_1006(cameraPos)) {
            return distance >= 1.0;
        }
        return raytraceresult.isPresent();
    }

    private void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, class_4587 poseStack, class_4597.class_4598 bufferSource) {
        int height = VoxelConstants.getClientWorld().method_31605();
        float brightness = 0.1f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        class_4588 vertexConsumerBeam = bufferSource.getBuffer(GLUtils.WAYPOINT_BEAM);
        for (int width = 0; width < 4; ++width) {
            double d6 = 0.1 + (double)width * 0.2;
            d6 *= topWidthFactor;
            double d7 = 0.1 + (double)width * 0.2;
            d7 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                float vertX2 = (float)(baseX + 0.5 - d6);
                float vertZ2 = (float)(baseZ + 0.5 - d6);
                if (side == 1 || side == 2) {
                    vertX2 = (float)((double)vertX2 + d6 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ2 = (float)((double)vertZ2 + d6 * 2.0);
                }
                float vertX1 = (float)(baseX + 0.5 - d7);
                float vertZ1 = (float)(baseZ + 0.5 - d7);
                if (side == 1 || side == 2) {
                    vertX1 = (float)((double)vertX1 + d7 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ1 = (float)((double)vertZ1 + d7 * 2.0);
                }
                vertexConsumerBeam.method_56824(poseStack.method_23760(), vertX1, (float)baseY + 0.0f, vertZ1).method_22915(r * brightness, g * brightness, b * brightness, 0.8f);
                vertexConsumerBeam.method_56824(poseStack.method_23760(), vertX2, (float)baseY + (float)height, vertZ2).method_22915(r * brightness, g * brightness, b * brightness, 0.8f);
            }
        }
    }

    private void renderLabel(class_4587 poseStack, class_4597.class_4598 bufferSource, Waypoint pt, double distance, boolean isPointedAt, String name, boolean target, double baseX, double baseY, double baseZ) {
        Sprite icon;
        if (target) {
            if (pt.red == 2.0f && pt.green == 0.0f && pt.blue == 0.0f) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            } else {
                isPointedAt = false;
            }
        }
        String distStr = this.options.distanceUnitConversion && distance > 10000.0 ? (double)Math.round(distance / 100.0) / 10.0 + "km" : (distance >= 9999999.0 ? (int)distance + "m" : (double)Math.round(distance * 10.0) / 10.0 + "m");
        if (!this.options.waypointDistanceBelowName) {
            name = (String)name + " (" + distStr + ")";
        }
        double maxDistance = (double)((Integer)this.minecraft.field_1690.method_42510().method_41753()).intValue() * 16.0 * 0.99;
        double adjustedDistance = distance;
        if (distance > maxDistance) {
            baseX = baseX / distance * maxDistance;
            baseY = baseY / distance * maxDistance;
            baseZ = baseZ / distance * maxDistance;
            adjustedDistance = maxDistance;
        }
        float var14 = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f;
        poseStack.method_22903();
        poseStack.method_46416((float)baseX + 0.5f, (float)baseY + 0.5f, (float)baseZ + 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-VoxelConstants.getMinecraft().method_1561().field_4686.method_19330()));
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(VoxelConstants.getMinecraft().method_1561().field_4686.method_19329()));
        poseStack.method_22905(-var14, -var14, -var14);
        float fade = distance > 5.0 ? 1.0f : (float)distance / 5.0f;
        fade = Math.min(fade, !pt.enabled && !target ? 0.3f : 1.0f);
        float width = 10.0f;
        float r = target ? 1.0f : pt.red;
        float g = target ? 0.0f : pt.green;
        float b = target ? 0.0f : pt.blue;
        TextureAtlas textureAtlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
        Sprite sprite = icon = target ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
        if (icon == textureAtlas.getMissingImage()) {
            icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
        }
        class_1921 rt = GLUtils.WAYPOINT_ICON_DEPTHTEST.apply(icon.getResourceLocation());
        class_4588 vertexIconDepthtest = bufferSource.getBuffer(rt);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), -width, -width, 0.0f).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, fade);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), -width, width, 0.0f).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, fade);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), width, width, 0.0f).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, fade);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), width, -width, 0.0f).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, fade);
        rt = GLUtils.WAYPOINT_ICON_NO_DEPTHTEST.apply(icon.getResourceLocation());
        class_4588 vertexIconNoDepthtest = bufferSource.getBuffer(rt);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), -width, -width, 0.0f).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, 0.3f * fade);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), -width, width, 0.0f).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, 0.3f * fade);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), width, width, 0.0f).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, 0.3f * fade);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), width, -width, 0.0f).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, 0.3f * fade);
        class_327 fontRenderer = this.minecraft.field_1772;
        if (isPointedAt && fontRenderer != null) {
            int elevateBy = this.options.waypointNameBelowIcon ? 10 : -19;
            int elevateDistBy = this.options.waypointNameBelowIcon ? 30 : -39;
            float distTextScale = 0.65f;
            rt = GLUtils.WAYPOINT_TEXT_BACKGROUND;
            class_4588 vertexBackground = bufferSource.getBuffer(rt);
            int halfStringWidth = fontRenderer.method_1727((String)name) / 2;
            int halfDistStringWidth = fontRenderer.method_1727(distStr) / 2;
            vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfStringWidth - 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfStringWidth - 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(halfStringWidth + 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(halfStringWidth + 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfStringWidth - 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfStringWidth - 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(halfStringWidth + 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
            vertexBackground.method_56824(poseStack.method_23760(), (float)(halfStringWidth + 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
            if (this.options.waypointDistanceBelowName) {
                poseStack.method_22903();
                poseStack.method_22905(distTextScale, distTextScale, distTextScale);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfDistStringWidth - 2), (float)(-2 + elevateDistBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfDistStringWidth - 2), (float)(9 + elevateDistBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfDistStringWidth + 2), (float)(9 + elevateDistBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfDistStringWidth + 2), (float)(-2 + elevateDistBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfDistStringWidth - 1), (float)(-1 + elevateDistBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfDistStringWidth - 1), (float)(8 + elevateDistBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfDistStringWidth + 1), (float)(8 + elevateDistBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfDistStringWidth + 1), (float)(-1 + elevateDistBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                poseStack.method_22909();
            }
            if (this.options.waypointDistanceBelowName) {
                // empty if block
            }
            int textColor = (int)(255.0f * fade) << 24 | 0xCCCCCC;
            fontRenderer.method_27522((class_2561)class_2561.method_43470((String)name), (float)(-fontRenderer.method_1727((String)name)) / 2.0f, (float)elevateBy, textColor, false, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
            if (this.options.waypointDistanceBelowName) {
                poseStack.method_22903();
                poseStack.method_22905(distTextScale, distTextScale, distTextScale);
                fontRenderer.method_27522((class_2561)class_2561.method_43470((String)distStr), (float)(-fontRenderer.method_1727(distStr)) / 2.0f, (float)elevateDistBy, textColor, false, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }
}

