#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <color_scheme.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }

    if (sphericalVertexDistance > 50.0) {
        ivec3 intColor = ivec3(color.rgb * 255.0);

        if (intColor == ivec3(0, 0, 0)) {
            color = vec4(black, 1.0);
        } else if (intColor == ivec3(0, 0, 168)) {
            color = vec4(dark_blue, 1.0);
        } else if (intColor == ivec3(0, 168, 0)) {
            color = vec4(dark_green, 1.0);
        } else if (intColor == ivec3(0, 168, 168)) {
            color = vec4(dark_aqua, 1.0);
        } else if (intColor == ivec3(168, 0, 0)) {
            color = vec4(dark_red, 1.0);
        } else if (intColor == ivec3(168, 0, 168)) {
            color = vec4(dark_purple, 1.0);
        } else if (intColor == ivec3(252, 168, 0)) {
            color = vec4(gold, 1.0);
        } else if (intColor == ivec3(168, 168, 168)) {
            color = vec4(gray, 1.0);
        } else if (intColor == ivec3(64, 64, 64)) {
            color = vec4(gray, 1.0);
        } else if (intColor == ivec3(84, 84, 84)) {
            color = vec4(dark_gray, 1.0);
        } else if (intColor == ivec3(84, 84, 252)) {
            color = vec4(blue, 1.0);
        } else if (intColor == ivec3(84, 252, 84)) {
            color = vec4(green, 1.0);
        } else if (intColor == ivec3(84, 252, 252)) {
            color = vec4(aqua, 1.0);
        } else if (intColor == ivec3(252, 84, 84)) {
            color = vec4(red, 1.0);
        } else if (intColor == ivec3(252, 84, 252)) {
            color = vec4(light_purple, 1.0);
        } else if (intColor == ivec3(252, 252, 84)) {
            color = vec4(yellow, 1.0);
        } else if (intColor == ivec3(252, 252, 252)) {
            color = vec4(white, 1.0);
        } else if (color.r > 0.2479 && color.r < 0.2481 && color.g > 0.2479 && color.g < 0.2481 && color.b > 0.2479 && color.b < 0.2481) {
            color = vec4(title_text_color, 1.0);
        } else if (intColor == ivec3(79, 0, 79)) {
            color = vec4(body_text_color, 1.0);
        } else if (intColor == ivec3(221, 221, 221)) {
            color = vec4(beacon_power_title_text_color, 1.0);
        }
    }
    
    /* xp text*/
    if(color.r <= 126.50/255.0 && color.r > 126.49/255.0 && color.g == 252/255.0 && color.b <= 31.63/255.0 && color.b > 31.62/255.0) {
        color = vec4(experience_text_color, color.a);
    }
    
    /* xp text shadow */
    if(color.r <= 31.7/255.0 && color.r > 31.6/255.0 && color.g <= 62.3/255.0 && color.g > 62.25/255.0 && color.b <= 8.0/255.0 && color.b > 7.9/255.0) {
        color = vec4(experience_text_color_shadow, color.a);
    }
	
    fragColor = apply_fog(color, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}
