/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.hushu.RulerGem;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.GemManager;
import me.hushu.manager.LanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RulerGemCommand
implements CommandExecutor {
    private final RulerGem plugin;
    private final GemManager gemManager;
    private final ConfigManager configManager;
    private final LanguageManager languageManager;

    public RulerGemCommand(RulerGem plugin, GemManager gemManager, ConfigManager configManager, LanguageManager languageManager) {
        this.plugin = plugin;
        this.gemManager = gemManager;
        this.configManager = configManager;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("rulergem")) {
            return false;
        }
        if (args.length == 0) {
            this.languageManager.sendMessage(sender, "command.usage");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                this.gemManager.saveGems();
                this.configManager.reloadConfigs();
                this.languageManager.loadLanguage();
                this.plugin.loadPlugin();
                this.languageManager.sendMessage(sender, "command.reload_success");
                return true;
            }
            case "rulers": {
                if (this.require(sender, "rulergem.rulers")) {
                    return true;
                }
                Map<UUID, Set<String>> holders = this.gemManager.getCurrentPowerHolders();
                if (holders.isEmpty()) {
                    this.languageManager.sendMessage(sender, "command.no_rulers");
                    return true;
                }
                for (Map.Entry<UUID, Set<String>> e : holders.entrySet()) {
                    Player p = Bukkit.getPlayer((UUID)e.getKey());
                    String name = p != null ? p.getName() : e.getKey().toString();
                    String extra = e.getValue().contains("ALL") ? "ALL" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)e.getValue());
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", name + " (" + extra + ")");
                    this.languageManager.sendMessage(sender, "command.rulers_status", placeholders);
                }
                return true;
            }
            case "gems": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                this.gemManager.gemStatus(sender);
                return true;
            }
            case "scatter": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                this.gemManager.scatterGems();
                this.languageManager.sendMessage(sender, "command.scatter_success");
                return true;
            }
            case "redeem": {
                if (this.require(sender, "rulergem.redeem")) {
                    return true;
                }
                if (!this.configManager.isRedeemEnabled()) {
                    this.languageManager.sendMessage(sender, "command.redeem.disabled");
                    return true;
                }
                return this.handleRedeem(sender, args);
            }
            case "redeemall": {
                if (this.require(sender, "rulergem.redeemall")) {
                    return true;
                }
                if (!this.configManager.isFullSetGrantsAllEnabled()) {
                    this.languageManager.sendMessage(sender, "command.redeemall.disabled");
                    return true;
                }
                return this.handleRedeemAll(sender);
            }
            case "place": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                return this.handlePlaceCommand(sender, args);
            }
            case "revoke": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                return this.handleRevokeCommand(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        this.languageManager.sendMessage(sender, "command.unknown_subcommand");
        return true;
    }

    private boolean require(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            this.languageManager.sendMessage(sender, "command.no_permission");
            return true;
        }
        return false;
    }

    private void sendHelp(CommandSender sender) {
        this.languageManager.sendMessage(sender, "command.help.header");
        this.languageManager.sendMessage(sender, "command.help.place");
        this.languageManager.sendMessage(sender, "command.help.revoke");
        this.languageManager.sendMessage(sender, "command.help.reload");
        this.languageManager.sendMessage(sender, "command.help.rulers");
        this.languageManager.sendMessage(sender, "command.help.gems");
        this.languageManager.sendMessage(sender, "command.help.scatter");
        this.languageManager.sendMessage(sender, "command.help.redeem");
        this.languageManager.sendMessage(sender, "command.help.redeemall");
        this.languageManager.sendMessage(sender, "command.help.help");
        this.languageManager.sendMessage(sender, "command.help.footer");
    }

    private boolean handlePlaceCommand(CommandSender sender, String[] args) {
        double z;
        double y;
        double x;
        if (args.length < 4) {
            this.languageManager.sendMessage(sender, "command.place.usage");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.place.player_only");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (args[1].equals("~")) {
            args[1] = String.valueOf(player.getLocation().getX());
        }
        if (args[2].equals("~")) {
            args[2] = String.valueOf(player.getLocation().getY());
        }
        if (args[3].equals("~")) {
            args[3] = String.valueOf(player.getLocation().getZ());
        }
        try {
            x = Double.parseDouble(args[1]);
            y = Double.parseDouble(args[2]);
            z = Double.parseDouble(args[3]);
        }
        catch (NumberFormatException e) {
            this.languageManager.sendMessage(sender, "command.place.invalid_coordinates");
            return true;
        }
        if (this.gemManager.getTotalGemCount() >= this.configManager.getRequiredCount()) {
            this.languageManager.sendMessage(sender, "command.place.gem_limit_reached");
            return false;
        }
        Location loc = new Location(world, x, y, z);
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load();
        }
        UUID newGemId = UUID.randomUUID();
        this.gemManager.placeRulerGem(loc, newGemId);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("x", String.valueOf(x));
        placeholders.put("y", String.valueOf(y));
        placeholders.put("z", String.valueOf(z));
        this.languageManager.sendMessage(sender, "command.place.success", placeholders);
        return true;
    }

    private boolean handleRedeem(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.redeem.player_only");
            return true;
        }
        if (args.length < 2) {
            this.languageManager.sendMessage(sender, "command.redeem.usage");
            return true;
        }
        Player player = (Player)sender;
        String name = args[1];
        boolean ok = this.gemManager.redeemGem(player, name);
        if (!ok) {
            this.languageManager.sendMessage(sender, "command.redeem.failed");
            return true;
        }
        this.languageManager.sendMessage(sender, "command.redeem.success");
        return true;
    }

    private boolean handleRedeemAll(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.redeem.player_only");
            return true;
        }
        Player player = (Player)sender;
        boolean ok = this.gemManager.redeemAll(player);
        if (!ok) {
            this.languageManager.sendMessage(sender, "command.redeemall.failed");
            return true;
        }
        this.languageManager.sendMessage(sender, "command.redeemall.success");
        return true;
    }

    private boolean handleRevokeCommand(CommandSender sender) {
        if (this.gemManager.getPowerPlayer() == null) {
            this.languageManager.sendMessage(sender, "command.revoke.no_power_player");
            return true;
        }
        this.gemManager.revokePermission(sender);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", this.gemManager.getPowerPlayer().getName());
        this.languageManager.sendMessage(sender, "command.revoke.success", placeholders);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.languageManager.showTitle(player, "power_revoked", placeholders);
        }
        return true;
    }
}

