/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hushu.RulerGem;
import me.hushu.model.ExecuteConfig;
import me.hushu.model.GemDefinition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final RulerGem plugin;
    private FileConfiguration config;
    private FileConfiguration gemsData;
    private File gemsFile;
    private int requiredCount;
    private ExecuteConfig gemUnionExecute;
    private ExecuteConfig gemScatterExecute;
    private ExecuteConfig powerRevokeExecute;
    private boolean useRequiredLoc;
    private Location requiredLocCenter;
    private int requiredLocRadius;
    private Location randomPlaceCorner1;
    private Location randomPlaceCorner2;
    private String language;
    private boolean broadcastRedeemTitle = true;
    private List<String> redeemAllTitle = Collections.emptyList();
    private Boolean redeemAllBroadcast = null;
    private String redeemAllSound = "ENTITY_ENDER_DRAGON_GROWL";
    private List<GemDefinition> gemDefinitions = new ArrayList<GemDefinition>();
    private boolean inventoryGrantsEnabled;
    private boolean redeemEnabled;
    private boolean fullSetGrantsAllEnabled;

    public ConfigManager(RulerGem plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        ConfigurationSection titles;
        String worldName;
        boolean v2;
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.language = this.plugin.getConfig().getString("language", "zh");
        boolean v1 = this.config.getBoolean("use_required_location", false);
        this.useRequiredLoc = v2 = this.config.getBoolean("use_required_locations", v1);
        if (this.useRequiredLoc) {
            ConfigurationSection locsSection = this.config.getConfigurationSection("required_locations");
            worldName = locsSection.getString("world");
            this.requiredLocRadius = locsSection.getInt("radius");
            World w = Bukkit.getWorld((String)worldName);
            if (w != null) {
                this.requiredLocCenter = this.getLocationFromConfig(locsSection, "center", w);
            } else {
                this.plugin.getLogger().warning("\u8bfb\u53d6\u5230\u65e0\u6548\u4e16\u754c: " + worldName);
            }
            this.plugin.getLogger().info(String.format("\u542f\u7528\u6307\u5b9a\u653e\u7f6e\u5750\u6807: %.2f %.2f %.2f", this.requiredLocCenter.getX(), this.requiredLocCenter.getY(), this.requiredLocCenter.getZ()));
        } else {
            this.plugin.getLogger().info("\u672a\u542f\u7528\u6307\u5b9a\u5750\u6807\u653e\u7f6e\u6a21\u5f0f\u3002");
        }
        ConfigurationSection randomPlaceRange = this.getConfig().getConfigurationSection("random_place_range");
        if (randomPlaceRange == null) {
            this.plugin.getLogger().severe("\u914d\u7f6e\u6587\u4ef6\u4e2d\u7f3a\u5c11 random_place_range \u90e8\u5206\u3002");
            return;
        }
        worldName = randomPlaceRange.getString("world");
        if (worldName == null) {
            this.plugin.getLogger().severe("random_place_range \u4e2d\u7f3a\u5c11 world \u540d\u79f0\u3002");
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u7684\u4e16\u754c: " + worldName);
            return;
        }
        this.randomPlaceCorner1 = this.getLocationFromConfig(randomPlaceRange, "corner1", world);
        this.randomPlaceCorner2 = this.getLocationFromConfig(randomPlaceRange, "corner2", world);
        if (this.randomPlaceCorner1 == null || this.randomPlaceCorner2 == null) {
            this.plugin.getLogger().severe("random_place_range \u4e2d\u7684 corner1 \u6216 corner2 \u914d\u7f6e\u65e0\u6548\u3002");
            return;
        }
        this.loadGemDefinitions();
        this.requiredCount = this.gemDefinitions.size();
        ConfigurationSection gp = this.config.getConfigurationSection("grant_policy");
        this.inventoryGrantsEnabled = gp != null && gp.getBoolean("inventory_grants", false);
        this.redeemEnabled = gp == null ? true : gp.getBoolean("redeem_enabled", true);
        this.fullSetGrantsAllEnabled = gp == null ? true : gp.getBoolean("full_set_grants_all", true);
        ConfigurationSection toggles = this.config.getConfigurationSection("toggles");
        if (toggles != null) {
            this.broadcastRedeemTitle = toggles.getBoolean("broadcast_redeem_title", true);
        }
        if ((titles = this.config.getConfigurationSection("titles")) != null) {
            ConfigurationSection ra = titles.getConfigurationSection("redeem_all");
            if (ra != null) {
                Object titlesObj = ra.get("titles");
                this.redeemAllTitle = this.toStringList(titlesObj);
                this.redeemAllBroadcast = ra.isSet("broadcast") ? Boolean.valueOf(ra.getBoolean("broadcast")) : null;
                String s = this.stringOf(ra.get("sound"));
                if (s != null && !s.isEmpty()) {
                    this.redeemAllSound = s;
                }
            } else {
                this.redeemAllTitle = Collections.emptyList();
                this.redeemAllBroadcast = null;
            }
        } else {
            this.redeemAllTitle = Collections.emptyList();
            this.redeemAllBroadcast = null;
        }
        this.gemUnionExecute = this.loadExecuteConfig("gem_union_execute");
        this.gemScatterExecute = this.loadExecuteConfig("gem_scatter_execute");
        ExecuteConfig revoke = this.loadExecuteConfig("power_revoke_execute");
        if ((revoke == null || revoke.getCommands() == null && revoke.getSound() == null && revoke.getParticle() == null) && this.config.getConfigurationSection("revoke_power") != null) {
            revoke = this.loadExecuteConfig("revoke_power");
        }
        this.powerRevokeExecute = revoke;
    }

    private void loadGemDefinitions() {
        this.gemDefinitions.clear();
        ConfigurationSection sec = this.config.getConfigurationSection("gems");
        if (sec != null) {
            for (String key : sec.getKeys(false)) {
                ConfigurationSection sub = sec.getConfigurationSection(key);
                HashMap<String, Object> m = new HashMap<String, Object>();
                if (sub != null) {
                    for (String k : sub.getKeys(false)) {
                        m.put(k, sub.get(k));
                    }
                }
                GemDefinition def = this.buildGemDefinitionFromMap(key, m);
                this.gemDefinitions.add(def);
            }
            return;
        }
        List list = this.config.getMapList("gems");
        if (list != null && !list.isEmpty()) {
            int index = 0;
            for (Map map : list) {
                Object keyObj = map.get("key");
                String key = keyObj != null ? this.stringOf(keyObj) : String.valueOf(index);
                GemDefinition def = this.buildGemDefinitionFromMap(key, map);
                this.gemDefinitions.add(def);
                ++index;
            }
        }
    }

    private GemDefinition buildGemDefinitionFromMap(String gemKey, Map<?, ?> map) {
        String matStr = this.stringOf(map.get("material"));
        Material material = Material.RED_STAINED_GLASS;
        if (matStr != null && !matStr.isEmpty()) {
            try {
                material = Material.valueOf((String)matStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String nameStr = this.stringOf(map.get("name"));
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)"&c\u6743\u529b\u5b9d\u77f3");
        if (nameStr != null && !nameStr.isEmpty()) {
            displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)nameStr);
        }
        String particleStr = this.stringOf(map.get("particle"));
        Particle particle = Particle.FLAME;
        if (particleStr != null && !particleStr.isEmpty()) {
            try {
                particle = Particle.valueOf((String)particleStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String soundStr = this.stringOf(map.get("sound"));
        Sound sound = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
        if (soundStr != null && !soundStr.isEmpty()) {
            try {
                sound = Sound.valueOf((String)soundStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ExecuteConfig onPickup = null;
        Object pickup = map.get("on_pickup");
        if (pickup instanceof Map) {
            onPickup = new ExecuteConfig(this.toStringList(((Map)pickup).get("commands")), this.stringOf(((Map)pickup).get("sound")), this.stringOf(((Map)pickup).get("particle")));
        }
        ExecuteConfig onScatter = null;
        Object scatter = map.get("on_scatter");
        if (scatter instanceof Map) {
            onScatter = new ExecuteConfig(this.toStringList(((Map)scatter).get("commands")), this.stringOf(((Map)scatter).get("sound")), this.stringOf(((Map)scatter).get("particle")));
        }
        ExecuteConfig onRedeem = null;
        Object redeem = map.get("on_redeem");
        if (redeem instanceof Map) {
            onRedeem = new ExecuteConfig(this.toStringList(((Map)redeem).get("commands")), this.stringOf(((Map)redeem).get("sound")), this.stringOf(((Map)redeem).get("particle")));
        }
        List<String> perms = this.toStringList(map.get("permissions"));
        String group = this.stringOf(map.get("vault_group"));
        List<String> lore = this.toStringList(map.get("lore"));
        List<String> redeemTitle = this.toStringList(map.get("redeem_title"));
        return new GemDefinition(gemKey, material, displayName, particle, sound, onPickup, onScatter, onRedeem, perms, group, lore, redeemTitle);
    }

    private String stringOf(Object o) {
        return o == null ? null : String.valueOf(o);
    }

    private List<String> toStringList(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            List raw = (List)o;
            ArrayList<String> out = new ArrayList<String>();
            for (Object e : raw) {
                if (e == null) continue;
                out.add(String.valueOf(e));
            }
            return out;
        }
        return Collections.singletonList(String.valueOf(o));
    }

    public void initGemFile() {
        this.gemsFile = new File(this.plugin.getDataFolder(), "rulergem.yml");
        if (!this.gemsFile.exists()) {
            this.gemsFile.getParentFile().mkdirs();
            this.plugin.saveResource("rulergem.yml", false);
        }
    }

    private ExecuteConfig loadExecuteConfig(String path) {
        ExecuteConfig execCfg = new ExecuteConfig(this.config.getStringList(path + ".commands"), this.config.getString(path + ".sound"), this.config.getString(path + ".particle"));
        return execCfg;
    }

    private Location getLocationFromConfig(ConfigurationSection configSection, String path, World world) {
        ConfigurationSection locSection = configSection.getConfigurationSection(path);
        if (locSection == null) {
            this.plugin.getLogger().severe("\u914d\u7f6e\u4e2d\u7f3a\u5c11 " + path + " \u8282\u3002");
            return null;
        }
        double x = locSection.getDouble("x");
        double y = locSection.getDouble("y");
        double z = locSection.getDouble("z");
        return new Location(world, x, y, z);
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.loadConfigs();
    }

    public void saveGemData(FileConfiguration data) {
        try {
            data.save(this.gemsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration readGemsData() {
        this.initGemFile();
        this.gemsData = YamlConfiguration.loadConfiguration((File)this.gemsFile);
        return this.gemsData;
    }

    public FileConfiguration getGemsData() {
        if (this.gemsData == null) {
            this.readGemsData();
        }
        return this.gemsData;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public ExecuteConfig getGemUnionExecute() {
        return this.gemUnionExecute;
    }

    public ExecuteConfig getGemScatterExecute() {
        return this.gemScatterExecute;
    }

    public ExecuteConfig getPowerRevokeExecute() {
        return this.powerRevokeExecute;
    }

    public Location getRandomPlaceCorner1() {
        return this.randomPlaceCorner1;
    }

    public Location getRandomPlaceCorner2() {
        return this.randomPlaceCorner2;
    }

    public boolean isUseRequiredLoc() {
        return this.useRequiredLoc;
    }

    public Location getRequiredLocCenter() {
        return this.requiredLocCenter;
    }

    public int getRequiredLocRadius() {
        return this.requiredLocRadius;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<GemDefinition> getGemDefinitions() {
        return this.gemDefinitions;
    }

    public boolean isInventoryGrantsEnabled() {
        return this.inventoryGrantsEnabled;
    }

    public boolean isRedeemEnabled() {
        return this.redeemEnabled;
    }

    public boolean isFullSetGrantsAllEnabled() {
        return this.fullSetGrantsAllEnabled;
    }

    public boolean isBroadcastRedeemTitle() {
        return this.broadcastRedeemTitle;
    }

    public List<String> getRedeemAllTitle() {
        return this.redeemAllTitle;
    }

    public Boolean getRedeemAllBroadcastOverride() {
        return this.redeemAllBroadcast;
    }

    public String getRedeemAllSound() {
        return this.redeemAllSound;
    }
}

