/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.hushu.RulerGem;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.LanguageManager;
import me.hushu.model.ExecuteConfig;
import me.hushu.model.GemDefinition;
import me.hushu.utils.EffectUtils;
import me.hushu.utils.SchedulerUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GemManager {
    private final RulerGem plugin;
    private final ConfigManager configManager;
    private final EffectUtils effectUtils;
    private final LanguageManager languageManager;
    private final NamespacedKey rulerGemKey;
    private final NamespacedKey uniqueIdKey;
    private final NamespacedKey gemKeyKey;
    private final Map<Location, UUID> locationToGemUuid = new HashMap<Location, UUID>();
    private final Map<UUID, Player> gemUuidToHolder = new HashMap<UUID, Player>();
    private final Map<UUID, String> gemUuidToKey = new HashMap<UUID, String>();
    private final Set<String> redeemedGemKeys = new HashSet<String>();
    private final Map<UUID, Set<String>> playerUuidToRedeemedKeys = new HashMap<UUID, Set<String>>();
    private final Map<UUID, PermissionAttachment> invAttachments = new HashMap<UUID, PermissionAttachment>();
    private final Map<UUID, PermissionAttachment> redeemAttachments = new HashMap<UUID, PermissionAttachment>();
    private final Map<String, UUID> gemKeyToRedeemer = new HashMap<String, UUID>();
    private UUID fullSetOwner = null;
    private Player powerPlayer;

    public GemManager(RulerGem plugin, ConfigManager configManager, EffectUtils effectUtils, LanguageManager languageManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.effectUtils = effectUtils;
        this.languageManager = languageManager;
        this.rulerGemKey = new NamespacedKey((Plugin)plugin, "power_gem");
        this.uniqueIdKey = new NamespacedKey((Plugin)plugin, "unique_id");
        this.gemKeyKey = new NamespacedKey((Plugin)plugin, "gem_key");
    }

    @EventHandler
    public void onGemDamage(BlockDamageEvent event) {
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (this.locationToGemUuid.containsKey(block.getLocation())) {
            event.setInstaBreak(true);
        }
    }

    public void loadGems() {
        ConfigurationSection heldGemsSection;
        ConfigurationSection fso;
        ConfigurationSection ownerSec;
        ConfigurationSection redeemedSection;
        ConfigurationSection placedGemsSection;
        String uuidStr;
        FileConfiguration gemsData = this.configManager.readGemsData();
        if (gemsData == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u52a0\u8f7d gemsData \u914d\u7f6e\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3002");
            return;
        }
        ConfigurationSection powerPlayerSection = gemsData.getConfigurationSection("power_player");
        if (powerPlayerSection != null && (uuidStr = powerPlayerSection.getString("uuid")) != null) {
            UUID powerPlayerUUID = UUID.fromString(uuidStr);
            this.powerPlayer = Bukkit.getPlayer((UUID)powerPlayerUUID);
        }
        if ((placedGemsSection = gemsData.getConfigurationSection("placed-gems")) == null) {
            placedGemsSection = gemsData.getConfigurationSection("placed-gams");
        }
        if ((redeemedSection = gemsData.getConfigurationSection("redeemed")) != null) {
            for (Object playerUuidStr : redeemedSection.getKeys(false)) {
                UUID pu = UUID.fromString((String)playerUuidStr);
                List list = redeemedSection.getStringList((String)playerUuidStr);
                if (list == null) continue;
                this.playerUuidToRedeemedKeys.put(pu, new HashSet(list));
            }
        }
        if ((ownerSec = gemsData.getConfigurationSection("redeem_owner")) != null) {
            for (String gemKey : ownerSec.getKeys(false)) {
                Object uuidStr2 = ownerSec.getString(gemKey);
                try {
                    this.gemKeyToRedeemer.put(gemKey.toLowerCase(), UUID.fromString((String)uuidStr2));
                }
                catch (Exception exception) {}
            }
        }
        if ((fso = gemsData.getConfigurationSection("full_set_owner")) != null) {
            String u = fso.getString("uuid");
            try {
                this.fullSetOwner = UUID.fromString(u);
            }
            catch (Exception uuidStr2) {
                // empty catch block
            }
        }
        if (placedGemsSection != null) {
            for (Object uuidStr2 : placedGemsSection.getKeys(false)) {
                UUID gemId;
                String worldName = placedGemsSection.getString((String)uuidStr2 + ".world");
                double x = placedGemsSection.getDouble((String)uuidStr2 + ".x");
                double y = placedGemsSection.getDouble((String)uuidStr2 + ".y");
                double z = placedGemsSection.getDouble((String)uuidStr2 + ".z");
                String gemKey = placedGemsSection.getString((String)uuidStr2 + ".gem_key", "default");
                World w = Bukkit.getWorld((String)worldName);
                if (w == null) continue;
                Location loc = new Location(w, x, y, z);
                try {
                    gemId = UUID.fromString((String)uuidStr2);
                }
                catch (Exception ignored) {
                    continue;
                }
                this.locationToGemUuid.put(loc, gemId);
                this.gemUuidToKey.put(gemId, gemKey);
            }
        }
        if ((heldGemsSection = gemsData.getConfigurationSection("held-gems")) != null) {
            for (String uuidStr3 : heldGemsSection.getKeys(false)) {
                UUID playerUUID;
                String playerUUIDStr = heldGemsSection.getString(uuidStr3 + ".player_uuid");
                String gemKey = heldGemsSection.getString(uuidStr3 + ".gem_key", "default");
                if (playerUUIDStr == null) continue;
                try {
                    playerUUID = UUID.fromString(playerUUIDStr);
                }
                catch (Exception ignored) {
                    continue;
                }
                UUID gemId = UUID.fromString(uuidStr3);
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player == null) continue;
                if (!player.isOnline()) {
                    PlayerInventory inv = player.getInventory();
                    for (ItemStack item : inv.getContents()) {
                        if (!this.isRulerGem(item) || !this.getGemUUID(item).equals(gemId)) continue;
                        inv.remove(item);
                    }
                    this.gemUuidToKey.put(gemId, gemKey);
                    this.placeRulerGem(player.getLocation(), gemId);
                    continue;
                }
                this.gemUuidToHolder.put(gemId, player);
                this.gemUuidToKey.put(gemId, gemKey);
            }
        }
        HashMap<String, String> placeholders1 = new HashMap<String, String>();
        placeholders1.put("count", String.valueOf(this.locationToGemUuid.size()));
        this.languageManager.logMessage("gems_loaded", placeholders1);
        HashMap<String, String> placeholders2 = new HashMap<String, String>();
        placeholders2.put("count", String.valueOf(this.gemUuidToHolder.size()));
        this.languageManager.logMessage("gems_held_loaded", placeholders2);
    }

    public void saveGems() {
        FileConfiguration gemsData = this.configManager.getGemsData();
        gemsData.set("placed-gems", null);
        gemsData.set("held-gems", null);
        gemsData.set("power_player", null);
        gemsData.set("redeemed", null);
        gemsData.set("redeem_owner", null);
        gemsData.set("full_set_owner", null);
        for (Location location : this.locationToGemUuid.keySet()) {
            String path = "placed-gems." + this.locationToGemUuid.get(location).toString();
            gemsData.set(path + ".world", (Object)location.getWorld().getName());
            gemsData.set(path + ".x", (Object)location.getX());
            gemsData.set(path + ".y", (Object)location.getY());
            gemsData.set(path + ".z", (Object)location.getZ());
            gemsData.set(path + ".gem_key", (Object)this.gemUuidToKey.get(this.locationToGemUuid.get(location)));
        }
        for (UUID uUID : this.gemUuidToHolder.keySet()) {
            Player player = this.gemUuidToHolder.get(uUID);
            String path = "held-gems." + uUID.toString();
            gemsData.set(path + ".player", (Object)player.getName());
            gemsData.set(path + ".player_uuid", (Object)player.getUniqueId().toString());
            gemsData.set(path + ".gem_key", (Object)this.gemUuidToKey.get(uUID));
        }
        if (this.powerPlayer != null) {
            gemsData.set("power_player.uuid", (Object)this.powerPlayer.getUniqueId().toString());
        }
        for (Map.Entry entry : this.playerUuidToRedeemedKeys.entrySet()) {
            String base = "redeemed." + ((UUID)entry.getKey()).toString();
            gemsData.set(base, new ArrayList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.gemKeyToRedeemer.entrySet()) {
            gemsData.set("redeem_owner." + (String)entry.getKey(), (Object)((UUID)entry.getValue()).toString());
        }
        if (this.fullSetOwner != null) {
            gemsData.set("full_set_owner.uuid", (Object)this.fullSetOwner.toString());
        }
        this.configManager.saveGemData(gemsData);
    }

    public void ensureConfiguredGemsPresent() {
        String k;
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs == null || defs.isEmpty()) {
            return;
        }
        HashSet<String> presentKeys = new HashSet<String>();
        for (UUID id : this.gemUuidToKey.keySet()) {
            k = this.gemUuidToKey.get(id);
            if (k == null) continue;
            presentKeys.add(k.toLowerCase());
        }
        for (GemDefinition d : defs) {
            k = d.getGemKey();
            if (k == null || presentKeys.contains(k.toLowerCase())) continue;
            UUID newId = UUID.randomUUID();
            this.gemUuidToKey.put(newId, k);
            this.randomPlaceGem(newId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
        }
    }

    @EventHandler
    public void onGemPlaced(BlockPlaceEvent event) {
        ItemStack inHand = event.getItemInHand();
        if (!this.isRulerGem(inHand)) {
            return;
        }
        UUID gemId = this.getGemUUID(inHand);
        if (gemId == null) {
            gemId = UUID.randomUUID();
        }
        Block block = event.getBlockPlaced();
        Location placedLoc = block.getLocation();
        this.gemUuidToHolder.remove(gemId);
        this.locationToGemUuid.put(placedLoc, gemId);
    }

    @EventHandler
    public void onGemBroken(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (this.locationToGemUuid.containsKey(block.getLocation())) {
            event.setDropItems(false);
            try {
                event.setExpToDrop(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            UUID gemId = this.locationToGemUuid.get(block.getLocation());
            Player player = event.getPlayer();
            PlayerInventory inv = player.getInventory();
            if (inv.firstEmpty() == -1) {
                this.languageManager.logMessage("inventory_full");
                event.setCancelled(true);
                return;
            }
            ItemStack gemItem = this.createRulerGem(gemId);
            inv.addItem(new ItemStack[]{gemItem});
            this.gemUuidToHolder.put(gemId, player);
            this.unplaceRulerGem(block.getLocation(), gemId);
            GemDefinition def = this.findGemDefinition(this.gemUuidToKey.get(gemId));
            if (def != null && def.getOnPickup() != null) {
                this.effectUtils.executeCommands(def.getOnPickup(), Collections.singletonMap("%player%", player.getName()));
                this.effectUtils.playLocalSound(player.getLocation(), def.getOnPickup(), 1.0f, 1.0f);
                this.effectUtils.playParticle(player.getLocation(), def.getOnPickup());
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!this.isRulerGem(item)) continue;
            UUID gemId = this.getGemUUID(item);
            inv.remove(item);
            Location loc = player.getLocation();
            this.gemUuidToHolder.remove(gemId);
            this.placeRulerGem(loc, gemId);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        UUID gemId = this.getGemUUID(item);
        if (this.isRulerGem(item)) {
            event.getItemDrop().remove();
            this.gemUuidToHolder.remove(gemId);
            Location loc = event.getItemDrop().getLocation();
            GemDefinition def = this.findGemDefinition(this.gemUuidToKey.get(gemId));
            if (def != null && def.getOnScatter() != null) {
                this.effectUtils.executeCommands(def.getOnScatter(), Collections.singletonMap("%player%", event.getPlayer().getName()));
                this.effectUtils.playLocalSound(loc, def.getOnScatter(), 1.0f, 1.0f);
                this.effectUtils.playParticle(loc, def.getOnScatter());
            } else {
                ExecuteConfig gemScatterExecute = this.configManager.getGemScatterExecute();
                this.effectUtils.playLocalSound(loc, gemScatterExecute, 1.0f, 1.0f);
                this.effectUtils.playParticle(loc, gemScatterExecute);
            }
            this.placeRulerGem(loc, gemId);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!this.isRulerGem(item)) continue;
            UUID gemId = this.getGemUUID(item);
            inv.remove(item);
            this.gemUuidToHolder.remove(gemId);
            Location deathLocation = player.getLocation();
            if (deathLocation == null) continue;
            GemDefinition def = this.findGemDefinition(this.gemUuidToKey.get(gemId));
            if (def != null && def.getOnScatter() != null) {
                this.effectUtils.executeCommands(def.getOnScatter(), Collections.singletonMap("%player%", player.getName()));
                this.effectUtils.playLocalSound(deathLocation, def.getOnScatter(), 1.0f, 1.0f);
                this.effectUtils.playParticle(deathLocation, def.getOnScatter());
            } else {
                ExecuteConfig gemScatterExecute = this.configManager.getGemScatterExecute();
                this.effectUtils.playLocalSound(deathLocation, gemScatterExecute, 1.0f, 1.0f);
                this.effectUtils.playParticle(deathLocation, gemScatterExecute);
            }
            this.placeRulerGem(deathLocation, gemId);
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            UUID gemId;
            if (!this.isRulerGem(item) || this.gemUuidToHolder.containsKey(gemId = this.getGemUUID(item))) continue;
            inv.remove(item);
            this.gemUuidToHolder.remove(gemId);
        }
    }

    public void scatterGems() {
        this.languageManager.logMessage("scatter_start");
        int scatteredCount = 0;
        HashSet<Location> locCopy = new HashSet<Location>(this.locationToGemUuid.keySet());
        for (Location loc : locCopy) {
            this.unplaceRulerGem(loc, this.locationToGemUuid.get(loc));
        }
        this.locationToGemUuid.clear();
        for (Object player : Bukkit.getOnlinePlayers()) {
            PlayerInventory inv = player.getInventory();
            for (ItemStack item : inv.getContents()) {
                if (!this.isRulerGem(item)) continue;
                inv.remove(item);
            }
        }
        this.gemUuidToHolder.clear();
        this.gemUuidToKey.clear();
        this.languageManager.logMessage("gems_recollected");
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs != null && !defs.isEmpty()) {
            scatteredCount = defs.size();
            for (GemDefinition def : defs) {
                Location placedLoc;
                gemId = UUID.randomUUID();
                this.gemUuidToKey.put(gemId, def.getGemKey());
                this.randomPlaceGem(gemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
                if (def.getOnScatter() == null || (placedLoc = this.findLocationByGemId(gemId)) == null) continue;
                this.effectUtils.executeCommands(def.getOnScatter(), Collections.emptyMap());
                this.effectUtils.playLocalSound(placedLoc, def.getOnScatter(), 1.0f, 1.0f);
                this.effectUtils.playParticle(placedLoc, def.getOnScatter());
            }
        } else {
            int toPlace;
            scatteredCount = toPlace = Math.max(0, this.configManager.getRequiredCount());
            for (int i = 0; i < toPlace; ++i) {
                gemId = UUID.randomUUID();
                this.randomPlaceGem(gemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(scatteredCount));
        this.languageManager.logMessage("gems_scattered", placeholders);
        if (this.powerPlayer != null) {
            placeholders.put("player", this.powerPlayer.getName());
            this.powerPlayer = null;
        }
        ExecuteConfig gemScatterExecute = this.configManager.getGemScatterExecute();
        this.effectUtils.executeCommands(gemScatterExecute, placeholders);
        this.effectUtils.playGlobalSound(gemScatterExecute, 1.0f, 1.0f);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.languageManager.showTitle(p, "gems_scattered", placeholders);
        }
        this.saveGems();
    }

    public void gemStatus(CommandSender sender) {
        GemDefinition def;
        HashMap<String, Integer> gemHolders = new HashMap<String, Integer>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlayerInventory playerInventory = p.getInventory();
            for (ItemStack item : playerInventory.getContents()) {
                if (!this.isRulerGem(item)) continue;
                if (gemHolders.containsKey(p.getName())) {
                    gemHolders.put(p.getName(), (Integer)gemHolders.get(p.getName()) + 1);
                    continue;
                }
                gemHolders.put(p.getName(), 1);
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(this.configManager.getRequiredCount()));
        placeholders.put("placed_count", String.valueOf(this.locationToGemUuid.size()));
        placeholders.put("held_count", String.valueOf(this.gemUuidToHolder.size()));
        this.languageManager.sendMessage(sender, "gem_status.total_expected", placeholders);
        this.languageManager.sendMessage(sender, "gem_status.total_counts", placeholders);
        for (Map.Entry<Location, UUID> entry : this.locationToGemUuid.entrySet()) {
            Location loc = entry.getKey();
            UUID id = entry.getValue();
            String key = this.gemUuidToKey.get(id);
            def = key != null ? this.findGemDefinition(key) : null;
            placeholders = new HashMap();
            placeholders.put("x", String.valueOf(loc.getBlockX()));
            placeholders.put("y", String.valueOf(loc.getBlockY()));
            placeholders.put("z", String.valueOf(loc.getBlockZ()));
            placeholders.put("world", loc.getWorld() != null ? loc.getWorld().getName() : "world");
            placeholders.put("gem_id", key != null ? key : "unknown");
            placeholders.put("gem_name", def != null && def.getDisplayName() != null ? def.getDisplayName() : "Gem");
            this.languageManager.sendMessage(sender, "gem_status.gem_location_named", placeholders);
        }
        for (String string : gemHolders.keySet()) {
            placeholders = new HashMap();
            placeholders.put("player", string);
            placeholders.put("count", String.valueOf(gemHolders.get(string)));
            this.languageManager.sendMessage(sender, "gem_status.player_holding", placeholders);
        }
        for (Map.Entry<Object, UUID> entry : this.gemUuidToHolder.entrySet()) {
            UUID gid = (UUID)entry.getKey();
            Player player = (Player)entry.getValue();
            String key = this.gemUuidToKey.get(gid);
            def = key != null ? this.findGemDefinition(key) : null;
            placeholders = new HashMap();
            placeholders.put("player", player.getName());
            placeholders.put("gem_id", key != null ? key : "unknown");
            placeholders.put("gem_name", def != null && def.getDisplayName() != null ? def.getDisplayName() : "Gem");
            this.languageManager.sendMessage(sender, "gem_status.player_gem_named", placeholders);
        }
    }

    public boolean isRulerGem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
        return pdc.has(this.rulerGemKey, PersistentDataType.BYTE);
    }

    private boolean isRulerGem(Block block) {
        Location loc = block.getLocation();
        return this.locationToGemUuid.containsKey(loc);
    }

    public ItemStack createRulerGem(UUID gemId) {
        ItemMeta meta;
        GemDefinition def;
        String gemKey = this.gemUuidToKey.getOrDefault(gemId, null);
        ItemStack rulerGem = new ItemStack(Material.RED_STAINED_GLASS, 1);
        if (gemKey != null && (def = this.findGemDefinition(gemKey)) != null) {
            rulerGem = new ItemStack(def.getMaterial(), 1);
        }
        if ((meta = rulerGem.getItemMeta()) == null) {
            return rulerGem;
        }
        String displayName = "\u00a7c\u6743\u529b\u5b9d\u77f3";
        if (gemKey != null) {
            GemDefinition def2 = this.findGemDefinition(gemKey);
            if (def2 != null && def2.getDisplayName() != null) {
                displayName = def2.getDisplayName();
            }
            if (def2 != null && def2.getLore() != null && !def2.getLore().isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : def2.getLore()) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                meta.setLore(lore);
            }
        }
        meta.setDisplayName(displayName);
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(this.rulerGemKey, PersistentDataType.BYTE, (Object)1);
        pdc.set(this.uniqueIdKey, PersistentDataType.STRING, (Object)gemId.toString());
        if (gemKey != null) {
            pdc.set(this.gemKeyKey, PersistentDataType.STRING, (Object)gemKey);
        }
        rulerGem.setItemMeta(meta);
        return rulerGem;
    }

    private GemDefinition findGemDefinition(String key) {
        for (GemDefinition d : this.configManager.getGemDefinitions()) {
            if (!d.getGemKey().equalsIgnoreCase(key)) continue;
            return d;
        }
        return null;
    }

    private void ensureGemKeyAssigned(UUID gemId) {
        if (this.gemUuidToKey.containsKey(gemId)) {
            return;
        }
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs == null || defs.isEmpty()) {
            return;
        }
        String key = defs.get(new Random().nextInt(defs.size())).getGemKey();
        this.gemUuidToKey.put(gemId, key);
    }

    private void grantPermissions(Player player, List<String> perms) {
        PermissionAttachment attachment = this.redeemAttachments.computeIfAbsent(player.getUniqueId(), p -> player.addAttachment((Plugin)this.plugin));
        for (String node : perms) {
            if (node == null || node.trim().isEmpty()) continue;
            attachment.setPermission(node, true);
        }
        player.recalculatePermissions();
    }

    private void grantRedeemPermissions(Player player, List<String> perms) {
        if (perms == null || perms.isEmpty()) {
            return;
        }
        this.grantPermissions(player, perms);
        if (this.plugin.getVaultPerms() != null) {
            for (String node : perms) {
                if (node == null || node.trim().isEmpty()) continue;
                try {
                    this.plugin.getVaultPerms().playerAdd(player, node);
                }
                catch (Exception exception) {}
            }
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void recalculateGrants(Player player) {
        if (!this.configManager.isInventoryGrantsEnabled()) {
            return;
        }
        HashSet<String> shouldHave = new HashSet<String>();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            GemDefinition def;
            UUID id;
            String key;
            if (!this.isRulerGem(item) || (key = this.gemUuidToKey.get(id = this.getGemUUID(item))) == null || (def = this.findGemDefinition(key)) == null || def.getPermissions() == null) continue;
            for (String node : def.getPermissions()) {
                if (node == null || node.trim().isEmpty()) continue;
                shouldHave.add(node);
            }
        }
        PermissionAttachment attachment = this.invAttachments.computeIfAbsent(player.getUniqueId(), p -> player.addAttachment((Plugin)this.plugin));
        HashSet current = new HashSet(attachment.getPermissions().keySet());
        for (String node : shouldHave) {
            if (current.contains(node)) continue;
            attachment.setPermission(node, true);
        }
        for (String node : current) {
            if (shouldHave.contains(node)) continue;
            attachment.unsetPermission(node);
        }
        player.recalculatePermissions();
    }

    public void initializePlacedGemBlocks() {
        for (Map.Entry<Location, UUID> e : this.locationToGemUuid.entrySet()) {
            Location loc = e.getKey();
            UUID gemId = e.getValue();
            World w = loc.getWorld();
            if (w == null) continue;
            try {
                GemDefinition def;
                String key = this.gemUuidToKey.get(gemId);
                Material mat = Material.RED_STAINED_GLASS;
                if (key != null && (def = this.findGemDefinition(key)) != null && def.getMaterial() != null) {
                    mat = def.getMaterial();
                }
                Material m = mat;
                Location f = loc;
                SchedulerUtil.regionRun((Plugin)this.plugin, f, () -> {
                    try {
                        if (!f.getChunk().isLoaded()) {
                            f.getChunk().load();
                        }
                        f.getBlock().setType(m);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 0L, -1L);
            }
            catch (Exception exception) {}
        }
    }

    private void revokeNodes(Player player, Collection<String> nodes) {
        PermissionAttachment r;
        PermissionAttachment i = this.invAttachments.get(player.getUniqueId());
        if (i != null) {
            for (String n : nodes) {
                try {
                    i.unsetPermission(n);
                }
                catch (Exception exception) {}
            }
        }
        if ((r = this.redeemAttachments.get(player.getUniqueId())) != null) {
            for (String n : nodes) {
                try {
                    r.unsetPermission(n);
                }
                catch (Exception exception) {}
            }
        }
        if (this.plugin.getVaultPerms() != null) {
            for (String n : nodes) {
                try {
                    this.plugin.getVaultPerms().playerRemove(player, n);
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getTotalGemCount() {
        return this.locationToGemUuid.size() + this.gemUuidToHolder.size();
    }

    public void placeRulerGem(Location loc, UUID gemId) {
        if (loc == null) {
            return;
        }
        if (this.getTotalGemCount() >= this.configManager.getRequiredCount()) {
            this.languageManager.logMessage("gem_limit_reached");
            return;
        }
        Location base = loc.clone();
        SchedulerUtil.regionRun((Plugin)this.plugin, base, () -> {
            GemDefinition def;
            World world = base.getWorld();
            if (world == null) {
                return;
            }
            WorldBorder border = world.getWorldBorder();
            Location target = base.getBlock().getLocation();
            for (int tries = 0; tries < 6 && target.getBlock().getType().isSolid(); ++tries) {
                target.add(0.0, 1.0, 0.0);
            }
            if (!border.isInside(target) || target.getBlockY() < world.getMinHeight() || target.getBlockY() > world.getMaxHeight()) {
                this.randomPlaceGem(gemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
                return;
            }
            String gemKey = this.gemUuidToKey.getOrDefault(gemId, null);
            Material mat = Material.RED_STAINED_GLASS;
            if (gemKey != null && (def = this.findGemDefinition(gemKey)) != null && def.getMaterial() != null) {
                mat = def.getMaterial();
            }
            target.getBlock().setType(mat);
            this.locationToGemUuid.put(target, gemId);
        }, 0L, -1L);
    }

    public void unplaceRulerGem(Location loc, UUID gemId) {
        if (loc == null) {
            return;
        }
        Location fLoc = loc.getBlock().getLocation();
        SchedulerUtil.regionRun((Plugin)this.plugin, fLoc, () -> {
            fLoc.getBlock().setType(Material.AIR);
            this.locationToGemUuid.remove(fLoc, gemId);
        }, 0L, -1L);
    }

    private void randomPlaceGem(UUID gemId, Location corner1, Location corner2) {
        this.ensureGemKeyAssigned(gemId);
        this.scheduleRandomAttempt(gemId, corner1, corner2, 12);
    }

    private void scheduleRandomAttempt(UUID gemId, Location corner1, Location corner2, int attemptsLeft) {
        if (corner1 == null || corner2 == null || attemptsLeft <= 0) {
            return;
        }
        if (corner1.getWorld() != corner2.getWorld()) {
            return;
        }
        World world = corner1.getWorld();
        Random rand = new Random();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = rand.nextInt(maxX - minX + 1) + minX;
        int z = rand.nextInt(maxZ - minZ + 1) + minZ;
        Location candidate = new Location(world, (double)x, (double)(world.getMinHeight() + 1), (double)z);
        SchedulerUtil.regionRun((Plugin)this.plugin, candidate, () -> {
            block4: {
                try {
                    int y = world.getHighestBlockYAt(x, z) + 1;
                    Location place = new Location(world, (double)x, (double)y, (double)z);
                    WorldBorder border = world.getWorldBorder();
                    if (!border.isInside(place)) {
                        if (attemptsLeft - 1 > 0) {
                            this.scheduleRandomAttempt(gemId, corner1, corner2, attemptsLeft - 1);
                        }
                        return;
                    }
                    this.placeRulerGem(place, gemId);
                }
                catch (Throwable t) {
                    if (attemptsLeft - 1 <= 0) break block4;
                    this.scheduleRandomAttempt(gemId, corner1, corner2, attemptsLeft - 1);
                }
            }
        }, 0L, -1L);
    }

    public void startParticleEffectTask(Particle particle) {
        SchedulerUtil.globalRun((Plugin)this.plugin, () -> {
            Iterator<Location> iterator = this.locationToGemUuid.keySet().iterator();
            while (iterator.hasNext()) {
                Location loc;
                Location target = loc = iterator.next();
                SchedulerUtil.regionRun((Plugin)this.plugin, target, () -> {
                    World world = target.getWorld();
                    if (world == null) {
                        return;
                    }
                    UUID id = this.locationToGemUuid.get(target);
                    GemDefinition def = id != null ? this.findGemDefinition(this.gemUuidToKey.get(id)) : null;
                    Particle p = def != null && def.getParticle() != null ? def.getParticle() : particle;
                    world.spawnParticle(p, target.getX() + 0.5, target.getY() + 0.5, target.getZ() + 0.5, 1);
                }, 0L, -1L);
            }
        }, 0L, 20L);
    }

    public void checkPlayersNearRulerGems() {
        if (this.locationToGemUuid.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.checkPlayerNearRulerGems(player);
        }
    }

    public void checkPlayerNearRulerGems(Player player) {
        if (player == null || this.locationToGemUuid.isEmpty()) {
            return;
        }
        SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)player, () -> this.doPlayerNearCheck(player), 0L, -1L);
    }

    private void doPlayerNearCheck(Player player) {
        if (player == null) {
            return;
        }
        Location playerLoc = player.getLocation();
        World playerWorld = playerLoc.getWorld();
        if (playerWorld == null) {
            return;
        }
        for (Location blockLoc : this.locationToGemUuid.keySet()) {
            double distance;
            World w = blockLoc.getWorld();
            if (w == null || !w.equals((Object)playerWorld) || !((distance = playerLoc.distance(blockLoc)) < 16.0)) continue;
            float volume = (float)(1.0 - distance / 16.0);
            float pitch = 1.0f;
            player.playSound(playerLoc, Sound.BLOCK_NOTE_BLOCK_PLING, volume, pitch);
        }
    }

    private Location findLocationByGemId(UUID gemId) {
        for (Map.Entry<Location, UUID> e : this.locationToGemUuid.entrySet()) {
            if (!e.getValue().equals(gemId)) continue;
            return e.getKey();
        }
        return null;
    }

    public void revokePermission(CommandSender sender) {
        if (this.powerPlayer == null) {
            this.languageManager.sendMessage(sender, "command.revoke.no_power_player");
            return;
        }
        ExecuteConfig revokeExecute = this.configManager.getPowerRevokeExecute();
        this.effectUtils.executeCommands(revokeExecute, Collections.singletonMap("%player%", this.powerPlayer.getName()));
        this.effectUtils.playGlobalSound(revokeExecute, 1.0f, 1.0f);
        if (this.powerPlayer.isOnline()) {
            this.effectUtils.playParticle(this.powerPlayer.getLocation(), revokeExecute);
            this.languageManager.sendMessage((CommandSender)this.powerPlayer, "command.revoke.success", Collections.singletonMap("player", this.powerPlayer.getName()));
        }
        this.powerPlayer = null;
        this.saveGems();
    }

    public UUID getGemUUID(ItemStack item) {
        if (!this.isRulerGem(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String uuidStr = (String)pdc.get(this.uniqueIdKey, PersistentDataType.STRING);
        if (uuidStr == null) {
            return null;
        }
        return UUID.fromString(uuidStr);
    }

    public UUID getGemUUID(Block block) {
        if (!this.isRulerGem(block)) {
            return null;
        }
        Location loc = block.getLocation();
        return this.locationToGemUuid.get(loc);
    }

    public Player getPowerPlayer() {
        return this.powerPlayer;
    }

    public boolean redeemGem(Player player, String gemKeyOrName) {
        if (!this.configManager.isRedeemEnabled()) {
            this.languageManager.sendMessage((CommandSender)player, "command.redeem.disabled");
            return true;
        }
        String targetKey = this.resolveGemKeyByNameOrKey(gemKeyOrName);
        if (targetKey == null) {
            return false;
        }
        UUID matchedGemId = null;
        for (ItemStack item : player.getInventory().getContents()) {
            UUID id;
            String key;
            if (!this.isRulerGem(item) || (key = this.gemUuidToKey.get(id = this.getGemUUID(item))) == null || !key.equalsIgnoreCase(targetKey)) continue;
            matchedGemId = id;
            break;
        }
        if (matchedGemId == null) {
            return false;
        }
        this.redeemedGemKeys.add(targetKey.toLowerCase());
        this.playerUuidToRedeemedKeys.computeIfAbsent(player.getUniqueId(), u -> new HashSet()).add(targetKey.toLowerCase());
        GemDefinition def = this.findGemDefinition(targetKey);
        if (def != null && def.getOnRedeem() != null) {
            this.effectUtils.executeCommands(def.getOnRedeem(), Collections.singletonMap("%player%", player.getName()));
            this.effectUtils.playLocalSound(player.getLocation(), def.getOnRedeem(), 1.0f, 1.0f);
            this.effectUtils.playParticle(player.getLocation(), def.getOnRedeem());
        }
        if (def != null && def.getPermissions() != null && !def.getPermissions().isEmpty()) {
            this.grantRedeemPermissions(player, def.getPermissions());
        }
        if (def != null && def.getVaultGroup() != null && !def.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
            try {
                this.plugin.getVaultPerms().playerAddGroup(player, def.getVaultGroup());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeGemItemFromInventory(player, matchedGemId);
        this.gemUuidToHolder.remove(matchedGemId);
        this.randomPlaceGem(matchedGemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
        UUID old = this.gemKeyToRedeemer.put(targetKey.toLowerCase(), player.getUniqueId());
        if (old != null && !old.equals(player.getUniqueId())) {
            Player oldP = Bukkit.getPlayer((UUID)old);
            if (oldP != null && oldP.isOnline()) {
                if (def != null && def.getPermissions() != null) {
                    this.revokeNodes(oldP, def.getPermissions());
                }
                if (def != null && def.getVaultGroup() != null && !def.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
                    try {
                        this.plugin.getVaultPerms().playerRemoveGroup(oldP, def.getVaultGroup());
                    }
                    catch (Exception item) {
                        // empty catch block
                    }
                }
                oldP.recalculatePermissions();
            } else {
                Set<String> s = this.playerUuidToRedeemedKeys.get(old);
                if (s != null) {
                    s.remove(targetKey.toLowerCase());
                }
            }
        }
        if (this.configManager.isBroadcastRedeemTitle()) {
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("player", player.getName());
            ph.put("gem", def != null ? (def.getDisplayName() != null ? def.getDisplayName() : targetKey) : targetKey);
            List<String> title = def != null ? def.getRedeemTitle() : null;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (title != null && !title.isEmpty()) {
                    if (title.size() == 1) {
                        p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)this.languageManager.formatText(title.get(0), Collections.singletonMap("player", player.getName()))), null, 10, 70, 20);
                        continue;
                    }
                    String l1 = this.languageManager.formatText(title.get(0), ph);
                    String l2 = this.languageManager.formatText(title.get(1), ph);
                    p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)l1), ChatColor.translateAlternateColorCodes((char)'&', (String)l2), 10, 70, 20);
                    continue;
                }
                this.languageManager.showTitle(p, "gems_scattered", Collections.singletonMap("count", String.valueOf(1)));
            }
        }
        return true;
    }

    private void removeGemItemFromInventory(Player player, UUID targetId) {
        UUID id;
        if (player == null || targetId == null) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack off = inv.getItemInOffHand();
        if (this.isRulerGem(off) && targetId.equals(id = this.getGemUUID(off))) {
            inv.setItemInOffHand(new ItemStack(Material.AIR));
            return;
        }
        ItemStack[] contents = inv.getContents();
        for (int i = 0; i < contents.length; ++i) {
            UUID id2;
            ItemStack it = contents[i];
            if (!this.isRulerGem(it) || !targetId.equals(id2 = this.getGemUUID(it))) continue;
            inv.setItem(i, new ItemStack(Material.AIR));
            break;
        }
    }

    public boolean redeemAll(Player player) {
        boolean broadcast;
        Player prev;
        if (!this.configManager.isFullSetGrantsAllEnabled()) {
            this.languageManager.sendMessage((CommandSender)player, "command.redeemall.disabled");
            return true;
        }
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs == null || defs.isEmpty()) {
            return false;
        }
        HashMap<String, UUID> keyToGemId = new HashMap<String, UUID>();
        for (ItemStack item : player.getInventory().getContents()) {
            UUID id;
            String key;
            if (!this.isRulerGem(item) || (key = this.gemUuidToKey.get(id = this.getGemUUID(item))) == null || keyToGemId.containsKey(key.toLowerCase())) continue;
            keyToGemId.put(key.toLowerCase(), id);
        }
        for (GemDefinition d : defs) {
            if (keyToGemId.containsKey(d.getGemKey().toLowerCase())) continue;
            return false;
        }
        UUID previousFull = this.fullSetOwner;
        this.fullSetOwner = player.getUniqueId();
        for (GemDefinition d : defs) {
            UUID gid;
            this.redeemedGemKeys.add(d.getGemKey().toLowerCase());
            this.playerUuidToRedeemedKeys.computeIfAbsent(player.getUniqueId(), u -> new HashSet()).add(d.getGemKey().toLowerCase());
            UUID old = this.gemKeyToRedeemer.put(d.getGemKey().toLowerCase(), player.getUniqueId());
            if (old != null && !old.equals(player.getUniqueId())) {
                Player oldP = Bukkit.getPlayer((UUID)old);
                if (oldP != null && oldP.isOnline()) {
                    if (d.getPermissions() != null) {
                        this.revokeNodes(oldP, d.getPermissions());
                    }
                    if (d.getVaultGroup() != null && !d.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
                        try {
                            this.plugin.getVaultPerms().playerRemoveGroup(oldP, d.getVaultGroup());
                        }
                        catch (Exception key) {
                            // empty catch block
                        }
                    }
                    oldP.recalculatePermissions();
                } else {
                    Set<String> s = this.playerUuidToRedeemedKeys.get(old);
                    if (s != null) {
                        s.remove(d.getGemKey().toLowerCase());
                    }
                }
            }
            if (d.getOnRedeem() != null) {
                this.effectUtils.executeCommands(d.getOnRedeem(), Collections.singletonMap("%player%", player.getName()));
                this.effectUtils.playLocalSound(player.getLocation(), d.getOnRedeem(), 1.0f, 1.0f);
                this.effectUtils.playParticle(player.getLocation(), d.getOnRedeem());
            }
            if (d.getPermissions() != null && !d.getPermissions().isEmpty()) {
                this.grantRedeemPermissions(player, d.getPermissions());
            }
            if (d.getVaultGroup() != null && !d.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
                try {
                    this.plugin.getVaultPerms().playerAddGroup(player, d.getVaultGroup());
                }
                catch (Exception oldP) {
                    // empty catch block
                }
            }
            if ((gid = (UUID)keyToGemId.get(d.getGemKey().toLowerCase())) == null) continue;
            this.removeGemItemFromInventory(player, gid);
            this.gemUuidToHolder.remove(gid);
            this.randomPlaceGem(gid, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
        }
        if (previousFull != null && !previousFull.equals(this.fullSetOwner) && (prev = Bukkit.getPlayer((UUID)previousFull)) != null && prev.isOnline()) {
            for (GemDefinition d : defs) {
                if (d.getPermissions() != null) {
                    this.revokeNodes(prev, d.getPermissions());
                }
                if (d.getVaultGroup() == null || d.getVaultGroup().isEmpty() || this.plugin.getVaultPerms() == null) continue;
                try {
                    this.plugin.getVaultPerms().playerRemoveGroup(prev, d.getVaultGroup());
                }
                catch (Exception exception) {}
            }
            prev.recalculatePermissions();
        }
        boolean bl = broadcast = this.configManager.getRedeemAllBroadcastOverride() != null ? this.configManager.getRedeemAllBroadcastOverride().booleanValue() : this.configManager.isBroadcastRedeemTitle();
        if (broadcast) {
            List<String> title = this.configManager.getRedeemAllTitle();
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("player", player.getName());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (title != null && !title.isEmpty()) {
                    if (title.size() == 1) {
                        p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)this.languageManager.formatText(title.get(0), ph)), null, 10, 70, 20);
                        continue;
                    }
                    String l1 = this.languageManager.formatText(title.get(0), ph);
                    String l2 = this.languageManager.formatText(title.get(1), ph);
                    p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)l1), ChatColor.translateAlternateColorCodes((char)'&', (String)l2), 10, 70, 20);
                    continue;
                }
                this.languageManager.showTitle(p, "gems_recollected", ph);
            }
        }
        try {
            Sound s = Sound.valueOf((String)this.configManager.getRedeemAllSound());
            this.effectUtils.playGlobalSound(new ExecuteConfig(Collections.emptyList(), s.name(), null), 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Map<UUID, Set<String>> getCurrentPowerHolders() {
        HashMap<UUID, Set<String>> map = new HashMap<UUID, Set<String>>();
        if (this.fullSetOwner != null) {
            map.put(this.fullSetOwner, new HashSet<String>(Collections.singleton("ALL")));
        }
        for (Map.Entry<String, UUID> e : this.gemKeyToRedeemer.entrySet()) {
            UUID u = e.getValue();
            if (u == null) continue;
            map.computeIfAbsent(u, k -> new HashSet()).add(e.getKey());
        }
        return map;
    }

    public UUID getFullSetOwner() {
        return this.fullSetOwner;
    }

    private String resolveGemKeyByNameOrKey(String input) {
        if (input == null) {
            return null;
        }
        String lc = input.toLowerCase();
        for (GemDefinition d : this.configManager.getGemDefinitions()) {
            if (d.getGemKey().equalsIgnoreCase(input)) {
                return d.getGemKey();
            }
            String name = d.getDisplayName();
            if (name == null || !ChatColor.stripColor((String)name).replace("\u00a7", "&").replace("&", "").toLowerCase().contains(lc)) continue;
            return d.getGemKey();
        }
        return null;
    }
}

