/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.manager;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import me.hushu.RulerGem;
import me.hushu.utils.SchedulerUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LanguageManager {
    private final RulerGem plugin;
    private String language;
    private FileConfiguration langConfig;
    private String prefix;

    public LanguageManager(RulerGem plugin) {
        this.plugin = plugin;
    }

    private void copyLangFileIfNotExists(String lang) {
        File outFile = new File(this.plugin.getDataFolder(), "local/" + lang + ".yml");
        if (!outFile.exists()) {
            File parent = outFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            this.plugin.saveResource("local/" + lang + ".yml", false);
        }
    }

    public void loadLanguage() {
        this.language = this.plugin.getConfig().getString("language", "zh");
        this.loadLangConfig(this.language);
        if (this.langConfig == null) {
            this.language = "zh";
            this.copyLangFileIfNotExists("zh");
            this.loadLangConfig("zh");
        }
        this.prefix = this.langConfig.getString("prefix", "&7[&6RulerGem&7] ");
    }

    private void loadLangConfig(String lang) {
        this.copyLangFileIfNotExists(lang);
        File langFile = new File(this.plugin.getDataFolder(), "local/" + lang + ".yml");
        if (langFile.exists()) {
            this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        }
    }

    public String getMessage(String path) {
        return this.getMessage(path, this.language);
    }

    public String getMessage(String path, String lang) {
        if (this.langConfig == null) {
            return "Missing language file: " + lang;
        }
        String message = this.langConfig.getString(path);
        return message != null ? message : "Missing message: " + path;
    }

    public String formatMessage(String path, Map<String, String> placeholders) {
        return this.formatMessage(path, this.language, placeholders);
    }

    public String formatMessage(String path, String lang, Map<String, String> placeholders) {
        String message = this.getMessage(path, lang);
        if ((message = this.formatText(message, placeholders)) != null) {
            message = message.replace("%prefix%", this.prefix);
        }
        return message;
    }

    public String formatText(String message, Map<String, String> placeholders) {
        if (placeholders != null) {
            for (String key : placeholders.keySet()) {
                message = message.replace("%" + key + "%", placeholders.get(key));
            }
        }
        return message;
    }

    public void sendMessage(CommandSender sender, String path) {
        this.sendMessage(sender, path, new HashMap<String, String>());
    }

    public void sendMessage(CommandSender sender, String path, Map<String, String> placeholders) {
        String message = this.formatMessage("messages." + path, placeholders);
        sender.sendMessage(this.translateColorCodes(message));
    }

    public void logMessage(String path) {
        this.logMessage(path, new HashMap<String, String>());
    }

    public void logMessage(String path, Map<String, String> placeholders) {
        Logger logger = this.plugin.getLogger();
        Object key = path.startsWith("logger.") ? path : "logger." + path;
        String message = this.formatMessage((String)key, placeholders);
        logger.info(this.translateColorCodes(message));
    }

    private String translateColorCodes(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getLanguage() {
        return this.language;
    }

    public void showTitle(Player player, String path, Map<String, String> placeholders) {
        if (this.langConfig == null) {
            return;
        }
        List titleMessages = this.langConfig.getStringList("title." + path);
        if (titleMessages.size() == 1) {
            SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)player, () -> player.sendTitle(this.translateColorCodes(this.formatText((String)titleMessages.get(0), placeholders)), null, 10, 70, 20), 0L, -1L);
        } else if (titleMessages.size() == 2) {
            SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)player, () -> player.sendTitle(this.translateColorCodes(this.formatText((String)titleMessages.get(0), placeholders)), this.translateColorCodes(this.formatText((String)titleMessages.get(1), placeholders)), 10, 70, 20), 0L, -1L);
        }
    }
}

