/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.utils;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerUtil {
    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Object globalRun(Plugin plugin, Runnable task, long delay, long period) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            try {
                Server server = Bukkit.getServer();
                Object globalScheduler = server.getClass().getMethod("getGlobalRegionScheduler", new Class[0]).invoke((Object)server, new Object[0]);
                Consumer<Object> foliaTask = scheduledTask -> task.run();
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                if (period <= 0L) {
                    if (delay == 0L) {
                        Method run = globalScheduler.getClass().getMethod("run", pluginClass, consumerClass);
                        return run.invoke(globalScheduler, plugin, foliaTask);
                    }
                    Method runDelayed = globalScheduler.getClass().getMethod("runDelayed", pluginClass, consumerClass, Long.TYPE);
                    return runDelayed.invoke(globalScheduler, plugin, foliaTask, delay);
                }
                Method runAtFixedRate = globalScheduler.getClass().getMethod("runAtFixedRate", pluginClass, consumerClass, Long.TYPE, Long.TYPE);
                return runAtFixedRate.invoke(globalScheduler, plugin, foliaTask, Math.max(1L, delay), period);
            }
            catch (Throwable throwable) {}
        } else {
            if (period < 0L) {
                if (delay == 0L) {
                    if (Bukkit.isPrimaryThread()) {
                        task.run();
                        return null;
                    }
                    return Bukkit.getScheduler().runTask(plugin, task);
                }
                return Bukkit.getScheduler().runTaskLater(plugin, task, delay);
            }
            return Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
        }
        return null;
    }

    public static void cancelTask(Object task) {
        if (task == null) {
            return;
        }
        try {
            Method cancel = task.getClass().getMethod("cancel", new Class[0]);
            cancel.invoke(task, new Object[0]);
        }
        catch (Throwable ignored) {
            try {
                if (task instanceof BukkitTask) {
                    ((BukkitTask)task).cancel();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Object entityRun(Plugin plugin, Entity entity, Runnable task, long delay, long period) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            try {
                Object entityScheduler = entity.getClass().getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
                Consumer<Object> foliaTask = scheduledTask -> task.run();
                Runnable retiredCallback = () -> {
                    try {
                        plugin.getLogger().fine("Entity scheduler task cancelled: entity no longer exists");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                };
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                Class<Runnable> runnableClass = Runnable.class;
                if (period <= 0L) {
                    if (delay == 0L) {
                        Method run = entityScheduler.getClass().getMethod("run", pluginClass, consumerClass, runnableClass);
                        return run.invoke(entityScheduler, plugin, foliaTask, retiredCallback);
                    }
                    Method runDelayed = entityScheduler.getClass().getMethod("runDelayed", pluginClass, consumerClass, runnableClass, Long.TYPE);
                    return runDelayed.invoke(entityScheduler, plugin, foliaTask, retiredCallback, delay);
                }
                Method runAtFixedRate = entityScheduler.getClass().getMethod("runAtFixedRate", pluginClass, consumerClass, runnableClass, Long.TYPE, Long.TYPE);
                return runAtFixedRate.invoke(entityScheduler, plugin, foliaTask, retiredCallback, Math.max(1L, delay), period);
            }
            catch (Throwable throwable) {}
        } else {
            if (period <= 0L) {
                if (delay == 0L) {
                    if (Bukkit.isPrimaryThread()) {
                        task.run();
                        return null;
                    }
                    return Bukkit.getScheduler().runTask(plugin, task);
                }
                return Bukkit.getScheduler().runTaskLater(plugin, task, delay);
            }
            return Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
        }
        return null;
    }

    public static Object regionRun(Plugin plugin, Location location, Runnable task, long delay, long period) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            try {
                Server server = Bukkit.getServer();
                Object regionScheduler = server.getClass().getMethod("getRegionScheduler", new Class[0]).invoke((Object)server, new Object[0]);
                Consumer<Object> foliaTask = scheduledTask -> task.run();
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                Class<Location> locationClass = Location.class;
                if (period <= 0L) {
                    if (delay == 0L) {
                        Method run = regionScheduler.getClass().getMethod("run", pluginClass, locationClass, consumerClass);
                        return run.invoke(regionScheduler, plugin, location, foliaTask);
                    }
                    Method runDelayed = regionScheduler.getClass().getMethod("runDelayed", pluginClass, locationClass, consumerClass, Long.TYPE);
                    return runDelayed.invoke(regionScheduler, plugin, location, foliaTask, delay);
                }
                Method runAtFixedRate = regionScheduler.getClass().getMethod("runAtFixedRate", pluginClass, locationClass, consumerClass, Long.TYPE, Long.TYPE);
                return runAtFixedRate.invoke(regionScheduler, plugin, location, foliaTask, Math.max(1L, delay), period);
            }
            catch (Throwable throwable) {}
        } else {
            if (period <= 0L) {
                if (delay == 0L) {
                    if (Bukkit.isPrimaryThread()) {
                        task.run();
                        return null;
                    }
                    return Bukkit.getScheduler().runTask(plugin, task);
                }
                return Bukkit.getScheduler().runTaskLater(plugin, task, delay);
            }
            return Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
        }
        return null;
    }

    public static void asyncRun(Plugin plugin, Runnable task, long delay) {
        block5: {
            delay = Math.max(0L, delay);
            if (SchedulerUtil.isFolia()) {
                try {
                    Server server = Bukkit.getServer();
                    Object asyncScheduler = server.getClass().getMethod("getAsyncScheduler", new Class[0]).invoke((Object)server, new Object[0]);
                    Consumer<Object> foliaTask = scheduledTask -> task.run();
                    Class<Plugin> pluginClass = Plugin.class;
                    Class<Consumer> consumerClass = Consumer.class;
                    if (delay <= 0L) {
                        Method runNow = asyncScheduler.getClass().getMethod("runNow", pluginClass, consumerClass);
                        runNow.invoke(asyncScheduler, plugin, foliaTask);
                        break block5;
                    }
                    Method runDelayed = asyncScheduler.getClass().getMethod("runDelayed", pluginClass, consumerClass, Long.TYPE, TimeUnit.class);
                    runDelayed.invoke(asyncScheduler, new Object[]{plugin, foliaTask, delay * 50L, TimeUnit.MILLISECONDS});
                }
                catch (Throwable t) {
                    long ticks = delay <= 0L ? 0L : Math.max(1L, delay);
                    Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, task, ticks);
                }
            } else {
                long ticks = delay <= 0L ? 0L : Math.max(1L, delay);
                Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, task, ticks);
            }
        }
    }
}

