/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.commands.AllowedCommandProxy;
import org.cubexmc.commands.RuleGemsCommand;
import org.cubexmc.commands.RuleGemsTabCompleter;
import org.cubexmc.listeners.CommandAllowanceListener;
import org.cubexmc.listeners.GemInventoryListener;
import org.cubexmc.listeners.GemPlaceListener;
import org.cubexmc.listeners.PlayerEventListener;
import org.cubexmc.manager.ConfigManager;
import org.cubexmc.manager.CustomCommandExecutor;
import org.cubexmc.manager.GemManager;
import org.cubexmc.manager.HistoryLogger;
import org.cubexmc.manager.LanguageManager;
import org.cubexmc.metrics.Metrics;
import org.cubexmc.utils.EffectUtils;
import org.cubexmc.utils.SchedulerUtil;

public class RuleGems
extends JavaPlugin {
    private ConfigManager configManager;
    private GemManager gemManager;
    private EffectUtils effectUtils;
    private LanguageManager languageManager;
    private HistoryLogger historyLogger;
    private CustomCommandExecutor customCommandExecutor;
    private Permission vaultPerms;
    private Metrics metrics;
    private CommandAllowanceListener commandAllowanceListener;
    private final Map<String, AllowedCommandProxy> proxyCommands = new HashMap<String, AllowedCommandProxy>();
    private CommandMap cachedCommandMap;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.effectUtils = new EffectUtils(this);
        this.historyLogger = new HistoryLogger(this, this.languageManager);
        this.customCommandExecutor = new CustomCommandExecutor(this, this.languageManager);
        this.gemManager = new GemManager(this, this.configManager, this.effectUtils, this.languageManager);
        this.gemManager.setHistoryLogger(this.historyLogger);
        this.metrics = new Metrics((Plugin)this, 27483);
        this.loadPlugin();
        RuleGemsCommand ruleGemsCommand = new RuleGemsCommand(this, this.gemManager, this.configManager, this.languageManager);
        PluginCommand cmd = this.getCommand("rulegems");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)ruleGemsCommand);
            cmd.setTabCompleter((TabCompleter)new RuleGemsTabCompleter(this.configManager));
        } else {
            this.getLogger().warning("Command 'rulegems' not found in plugin.yml");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new GemPlaceListener(this, this.gemManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GemInventoryListener(this.gemManager, this.languageManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerEventListener(this, this.gemManager), (Plugin)this);
        this.commandAllowanceListener = new CommandAllowanceListener(this.gemManager, this.languageManager, this.customCommandExecutor);
        Bukkit.getPluginManager().registerEvents((Listener)this.commandAllowanceListener, (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            try {
                RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
                if (rsp != null) {
                    this.vaultPerms = (Permission)rsp.getProvider();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SchedulerUtil.globalRun((Plugin)this, () -> this.gemManager.checkPlayersNearRuleGems(), 20L, 20L);
        this.gemManager.startParticleEffectTask(Particle.FLAME);
        SchedulerUtil.globalRun((Plugin)this, () -> this.gemManager.saveGems(), 72000L, 72000L);
        this.refreshAllowedCommandProxies();
        this.languageManager.logMessage("plugin_enabled");
    }

    public void onDisable() {
        CommandMap map = this.getCommandMapSafely();
        if (map != null) {
            this.unregisterProxyCommands(map);
        }
        this.gemManager.saveGems();
        this.languageManager.logMessage("plugin_disabled");
    }

    public void loadPlugin() {
        this.saveDefaultConfig();
        this.configManager.initGemFile();
        this.configManager.loadConfigs();
        this.languageManager.updateBundledLanguages();
        this.languageManager.loadLanguage();
        this.configManager.getGemsData();
        this.gemManager.loadGems();
        this.gemManager.initializePlacedGemBlocks();
        this.gemManager.ensureConfiguredGemsPresent();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GemManager getGemManager() {
        return this.gemManager;
    }

    public EffectUtils getEffectUtils() {
        return this.effectUtils;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public HistoryLogger getHistoryLogger() {
        return this.historyLogger;
    }

    public CustomCommandExecutor getCustomCommandExecutor() {
        return this.customCommandExecutor;
    }

    public Permission getVaultPerms() {
        return this.vaultPerms;
    }

    public void refreshAllowedCommandProxies() {
        CommandMap map = this.getCommandMapSafely();
        if (map == null || this.commandAllowanceListener == null) {
            return;
        }
        this.unregisterProxyCommands(map);
        Set<String> configuredLabels = this.configManager.collectAllowedCommandLabels();
        if (configuredLabels == null) {
            configuredLabels = Collections.emptySet();
        }
        HashSet<String> registered = new HashSet<String>();
        Map<String, Command> known = this.getKnownCommands(map);
        for (String label : configuredLabels) {
            if (label == null || label.isEmpty()) continue;
            String normalized = label.toLowerCase(Locale.ROOT);
            Command existing = map.getCommand(normalized);
            if (existing != null && !(existing instanceof AllowedCommandProxy)) {
                this.getLogger().warning("Skipping proxy registration for /" + normalized + " because another plugin already provides it.");
                continue;
            }
            AllowedCommandProxy proxy = new AllowedCommandProxy(normalized, this, this.commandAllowanceListener);
            map.register("rulegems", (Command)proxy);
            this.proxyCommands.put(normalized, proxy);
            registered.add(normalized);
            if (known == null) continue;
            known.put(normalized, proxy);
            known.put("rulegems:" + normalized, proxy);
        }
        this.commandAllowanceListener.updateProxyLabels(registered);
    }

    private void unregisterProxyCommands(CommandMap map) {
        if (this.proxyCommands.isEmpty()) {
            return;
        }
        Map<String, Command> known = this.getKnownCommands(map);
        for (AllowedCommandProxy proxy : this.proxyCommands.values()) {
            proxy.unregister(map);
            if (known == null) continue;
            known.remove(proxy.getName());
            known.remove("rulegems:" + proxy.getName());
        }
        this.proxyCommands.clear();
    }

    private CommandMap getCommandMapSafely() {
        if (this.cachedCommandMap != null) {
            return this.cachedCommandMap;
        }
        try {
            Field field = this.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            this.cachedCommandMap = (CommandMap)field.get(this.getServer());
        }
        catch (Exception ex) {
            this.getLogger().warning("Unable to access Bukkit command map: " + ex.getMessage());
        }
        return this.cachedCommandMap;
    }

    private Map<String, Command> getKnownCommands(CommandMap map) {
        if (!(map instanceof SimpleCommandMap)) {
            return null;
        }
        try {
            Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            return (Map)field.get(map);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

