/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.cubexmc.RuleGems;
import org.cubexmc.listeners.CommandAllowanceListener;

public class AllowedCommandProxy
extends Command
implements PluginIdentifiableCommand {
    private final RuleGems plugin;
    private final CommandAllowanceListener allowanceListener;

    public AllowedCommandProxy(String label, RuleGems plugin, CommandAllowanceListener allowanceListener) {
        super(label);
        this.plugin = plugin;
        this.allowanceListener = allowanceListener;
        this.setUsage("/" + label);
        this.setDescription("RuleGems proxy for /" + label);
        this.setPermission(null);
        this.setAliases(Collections.emptyList());
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        String lowerLabel = commandLabel.toLowerCase(Locale.ROOT);
        String raw = this.buildRaw(lowerLabel, args);
        this.allowanceListener.handleProxyExecution(player, raw, lowerLabel, args);
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        return this.allowanceListener.suggestProxyTab(player, alias.toLowerCase(Locale.ROOT), args);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    private String buildRaw(String label, String[] args) {
        if (args == null || args.length == 0) {
            return label;
        }
        return label + " " + String.join((CharSequence)" ", Arrays.asList(args));
    }
}

