/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.cubexmc.RuleGems;
import org.cubexmc.manager.ConfigManager;
import org.cubexmc.manager.GemManager;
import org.cubexmc.manager.HistoryLogger;
import org.cubexmc.manager.LanguageManager;
import org.cubexmc.utils.SchedulerUtil;

public class RuleGemsCommand
implements CommandExecutor {
    private static final int HISTORY_PAGE_SIZE = 5;
    private final RuleGems plugin;
    private final GemManager gemManager;
    private final ConfigManager configManager;
    private final LanguageManager languageManager;

    public RuleGemsCommand(RuleGems plugin, GemManager gemManager, ConfigManager configManager, LanguageManager languageManager) {
        this.plugin = plugin;
        this.gemManager = gemManager;
        this.configManager = configManager;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("rulegems")) {
            return false;
        }
        if (args.length == 0) {
            this.languageManager.sendMessage(sender, "command.usage");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                this.gemManager.saveGems();
                this.plugin.loadPlugin();
                this.plugin.refreshAllowedCommandProxies();
                this.languageManager.sendMessage(sender, "command.reload_success");
                return true;
            }
            case "rulers": {
                if (this.require(sender, "rulegems.rulers")) {
                    return true;
                }
                Map<UUID, Set<String>> holders = this.gemManager.getCurrentRulers();
                if (holders.isEmpty()) {
                    this.languageManager.sendMessage(sender, "command.no_rulers");
                    return true;
                }
                for (Map.Entry<UUID, Set<String>> e : holders.entrySet()) {
                    Player p = Bukkit.getPlayer((UUID)e.getKey());
                    String name = p != null ? p.getName() : e.getKey().toString();
                    String extra = e.getValue().contains("ALL") ? "ALL" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)e.getValue());
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", name + " (" + extra + ")");
                    this.languageManager.sendMessage(sender, "command.rulers_status", placeholders);
                }
                return true;
            }
            case "gems": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                this.gemManager.gemStatus(sender);
                return true;
            }
            case "tp": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                return this.handleTpCommand(sender, args);
            }
            case "scatter": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                this.gemManager.scatterGems();
                this.languageManager.sendMessage(sender, "command.scatter_success");
                return true;
            }
            case "redeem": {
                if (this.require(sender, "rulegems.redeem")) {
                    return true;
                }
                if (!this.configManager.isRedeemEnabled()) {
                    this.languageManager.sendMessage(sender, "command.redeem.disabled");
                    return true;
                }
                return this.handleRedeem(sender, args);
            }
            case "redeemall": {
                if (this.require(sender, "rulegems.redeemall")) {
                    return true;
                }
                if (!this.configManager.isFullSetGrantsAllEnabled()) {
                    this.languageManager.sendMessage(sender, "command.redeemall.disabled");
                    return true;
                }
                return this.handleRedeemAll(sender);
            }
            case "place": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                return this.handlePlaceCommand(sender, args);
            }
            case "revoke": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                return this.handleRevokeCommand(sender, args);
            }
            case "history": {
                if (this.require(sender, "rulegems.admin")) {
                    return true;
                }
                return this.handleHistoryCommand(sender, args);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        this.languageManager.sendMessage(sender, "command.unknown_subcommand");
        return true;
    }

    private boolean require(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            this.languageManager.sendMessage(sender, "command.no_permission");
            return true;
        }
        return false;
    }

    private void sendHelp(CommandSender sender) {
        this.languageManager.sendMessage(sender, "command.help.header");
        this.languageManager.sendMessage(sender, "command.help.place");
        this.languageManager.sendMessage(sender, "command.help.revoke");
        this.languageManager.sendMessage(sender, "command.help.reload");
        this.languageManager.sendMessage(sender, "command.help.rulers");
        this.languageManager.sendMessage(sender, "command.help.gems");
        this.languageManager.sendMessage(sender, "command.help.scatter");
        this.languageManager.sendMessage(sender, "command.help.redeem");
        this.languageManager.sendMessage(sender, "command.help.redeemall");
        this.languageManager.sendMessage(sender, "command.help.history");
        this.languageManager.sendMessage(sender, "command.help.help");
        this.languageManager.sendMessage(sender, "command.help.footer");
    }

    private boolean handleTpCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.tp.player_only");
            return true;
        }
        if (args.length < 2) {
            this.languageManager.sendMessage(sender, "command.tp.usage");
            return true;
        }
        Player p = (Player)sender;
        UUID gemId = this.gemManager.resolveGemIdentifier(args[1]);
        if (gemId == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("input", args[1]);
            this.languageManager.sendMessage(sender, "command.tp.not_found", placeholders);
            return true;
        }
        Player realHolder = this.gemManager.getGemHolder(gemId);
        if (realHolder != null && realHolder.isOnline()) {
            Location dest = realHolder.getLocation();
            SchedulerUtil.safeTeleport((Plugin)this.plugin, p, dest);
            return true;
        }
        Location loc = this.gemManager.getGemLocation(gemId);
        if (loc != null) {
            Location dest = loc.clone().add(0.5, 1.0, 0.5);
            SchedulerUtil.safeTeleport((Plugin)this.plugin, p, dest);
            return true;
        }
        this.languageManager.sendMessage(sender, "command.tp.unavailable");
        return true;
    }

    private boolean handlePlaceCommand(CommandSender sender, String[] args) {
        Material m;
        double z;
        double y;
        double x;
        if (args.length < 5) {
            this.languageManager.sendMessage(sender, "command.place.usage");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.place.player_only");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        String gemIdentifier = args[1];
        if (args[2].equals("~")) {
            args[2] = String.valueOf(player.getLocation().getX());
        }
        if (args[3].equals("~")) {
            args[3] = String.valueOf(player.getLocation().getY());
        }
        if (args[4].equals("~")) {
            args[4] = String.valueOf(player.getLocation().getZ());
        }
        try {
            x = Double.parseDouble(args[2]);
            y = Double.parseDouble(args[3]);
            z = Double.parseDouble(args[4]);
        }
        catch (NumberFormatException e) {
            this.languageManager.sendMessage(sender, "command.place.invalid_coordinates");
            return true;
        }
        UUID gemId = this.gemManager.resolveGemIdentifier(gemIdentifier);
        if (gemId == null) {
            this.languageManager.sendMessage(sender, "command.place.invalid_gem");
            return true;
        }
        Location loc = new Location(world, x, y, z);
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load();
        }
        if (this.gemManager.isSupportRequired(m = this.gemManager.getGemMaterial(gemId)) && !this.gemManager.hasBlockSupport(loc)) {
            this.languageManager.sendMessage(sender, "command.place.failed_unsupported");
            return true;
        }
        this.gemManager.forcePlaceGem(gemId, loc);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("x", String.valueOf(x));
        placeholders.put("y", String.valueOf(y));
        placeholders.put("z", String.valueOf(z));
        this.languageManager.sendMessage(sender, "command.place.success", placeholders);
        return true;
    }

    private boolean handleRedeem(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.redeem.player_only");
            return true;
        }
        Player player = (Player)sender;
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            this.languageManager.sendMessage(sender, "command.redeem.no_item_in_hand");
            return true;
        }
        if (!this.gemManager.isRuleGem(inHand)) {
            this.languageManager.sendMessage(sender, "command.redeem.not_a_gem");
            return true;
        }
        boolean ok = this.gemManager.redeemGemInHand(player);
        if (!ok) {
            this.languageManager.sendMessage(sender, "command.redeem.failed");
            return true;
        }
        this.languageManager.sendMessage(sender, "command.redeem.success");
        return true;
    }

    private boolean handleRedeemAll(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.redeem.player_only");
            return true;
        }
        Player player = (Player)sender;
        boolean ok = this.gemManager.redeemAll(player);
        if (!ok) {
            this.languageManager.sendMessage(sender, "command.redeemall.failed");
            return true;
        }
        this.languageManager.sendMessage(sender, "command.redeemall.success");
        return true;
    }

    private boolean handleRevokeCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.languageManager.sendMessage(sender, "command.revoke.usage");
            return true;
        }
        String targetName = args[1];
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetName);
            this.languageManager.sendMessage(sender, "command.revoke.player_not_found", placeholders);
            return true;
        }
        boolean revoked = this.gemManager.revokeAllPlayerPermissions(targetPlayer);
        if (!revoked) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", targetPlayer.getName());
            this.languageManager.sendMessage(sender, "command.revoke.no_permissions", placeholders);
            return true;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetPlayer.getName());
        this.languageManager.sendMessage(sender, "command.revoke.success", placeholders);
        this.languageManager.sendMessage((CommandSender)targetPlayer, "command.revoke.revoked_notice");
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.hasPermission("rulegems.admin")) continue;
            this.languageManager.sendMessage((CommandSender)online, "command.revoke.broadcast", placeholders);
        }
        return true;
    }

    private boolean handleHistoryCommand(CommandSender sender, String[] args) {
        HistoryLogger.HistoryPage historyPage;
        HistoryLogger historyLogger = this.plugin.getHistoryLogger();
        if (historyLogger == null) {
            this.languageManager.sendMessage(sender, "command.history.disabled");
            return true;
        }
        int page = 1;
        String playerFilter = null;
        if (args.length > 1) {
            if (this.isInteger(args[1])) {
                page = Math.max(1, Integer.parseInt(args[1]));
            } else {
                playerFilter = args[1];
            }
        }
        if (args.length > 2) {
            if (playerFilter == null && !this.isInteger(args[2])) {
                playerFilter = args[2];
            } else if (this.isInteger(args[2])) {
                page = Math.max(1, Integer.parseInt(args[2]));
            }
        }
        int totalPages = 1;
        if (playerFilter != null) {
            historyPage = historyLogger.getPlayerHistoryPage(playerFilter, page, 5);
            if (historyPage.getTotalCount() == 0) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", playerFilter);
                this.languageManager.sendMessage(sender, "command.history.no_player_records", placeholders);
                return true;
            }
            if (historyPage.getEntries().isEmpty()) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("page", String.valueOf(page));
                this.languageManager.sendMessage(sender, "command.history.page_out_of_range", placeholders);
                return true;
            }
            placeholders = new HashMap();
            placeholders.put("player", playerFilter);
            placeholders.put("count", String.valueOf(historyPage.getEntries().size()));
            placeholders.put("total", String.valueOf(historyPage.getTotalCount()));
            totalPages = Math.max(1, (int)Math.ceil((double)historyPage.getTotalCount() / 5.0));
            placeholders.put("page", String.valueOf(page));
            placeholders.put("pages", String.valueOf(totalPages));
            this.languageManager.sendMessage(sender, "command.history.player_header", placeholders);
        } else {
            historyPage = historyLogger.getRecentHistoryPage(page, 5);
            if (historyPage.getTotalCount() == 0) {
                this.languageManager.sendMessage(sender, "command.history.no_records");
                return true;
            }
            if (historyPage.getEntries().isEmpty()) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("page", String.valueOf(page));
                this.languageManager.sendMessage(sender, "command.history.page_out_of_range", placeholders);
                return true;
            }
            placeholders = new HashMap<String, String>();
            placeholders.put("count", String.valueOf(historyPage.getEntries().size()));
            placeholders.put("total", String.valueOf(historyPage.getTotalCount()));
            totalPages = Math.max(1, (int)Math.ceil((double)historyPage.getTotalCount() / 5.0));
            placeholders.put("page", String.valueOf(page));
            placeholders.put("pages", String.valueOf(totalPages));
            this.languageManager.sendMessage(sender, "command.history.recent_header", placeholders);
        }
        for (String line : historyPage.getEntries()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("line", line);
            this.languageManager.sendMessage(sender, "command.history.line", placeholders);
        }
        if (totalPages > 1) {
            this.sendHistoryNavigation(sender, page, totalPages, playerFilter);
        }
        return true;
    }

    private boolean isInteger(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private void sendHistoryNavigation(CommandSender sender, int currentPage, int totalPages, String playerFilter) {
        int nextPage;
        int prevPage = currentPage > 1 ? currentPage - 1 : -1;
        int n = nextPage = currentPage < totalPages ? currentPage + 1 : -1;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ArrayList<BaseComponent> components = new ArrayList<BaseComponent>();
            HashMap<String, String> basePlaceholders = new HashMap<String, String>();
            basePlaceholders.put("page", String.valueOf(currentPage));
            basePlaceholders.put("pages", String.valueOf(totalPages));
            String divider = this.safeFormat("command.history.page_nav_divider", basePlaceholders);
            if (prevPage > 0) {
                HashMap<String, String> prevPlaceholders = new HashMap<String, String>(basePlaceholders);
                prevPlaceholders.put("target", String.valueOf(prevPage));
                prevPlaceholders.put("page", String.valueOf(prevPage));
                String prevLabel = this.safeFormat("command.history.page_nav_previous", prevPlaceholders);
                String prevHover = this.safeFormat("command.history.page_nav_hover", prevPlaceholders);
                this.appendInteractiveComponent(components, prevLabel, prevHover, this.buildHistoryCommand(prevPage, playerFilter));
            } else {
                String prevDisabled = this.safeFormat("command.history.page_nav_previous_disabled", basePlaceholders);
                this.appendStaticComponent(components, prevDisabled);
            }
            if (nextPage > 0) {
                HashMap<String, String> nextPlaceholders = new HashMap<String, String>(basePlaceholders);
                nextPlaceholders.put("target", String.valueOf(nextPage));
                nextPlaceholders.put("page", String.valueOf(nextPage));
                String nextLabel = this.safeFormat("command.history.page_nav_next", nextPlaceholders);
                String nextHover = this.safeFormat("command.history.page_nav_hover", nextPlaceholders);
                if (!components.isEmpty() && !divider.isEmpty()) {
                    this.appendStaticComponent(components, divider);
                }
                this.appendInteractiveComponent(components, nextLabel, nextHover, this.buildHistoryCommand(nextPage, playerFilter));
            } else {
                String nextDisabled = this.safeFormat("command.history.page_nav_next_disabled", basePlaceholders);
                if (!nextDisabled.isEmpty()) {
                    if (!components.isEmpty() && !divider.isEmpty()) {
                        this.appendStaticComponent(components, divider);
                    }
                    this.appendStaticComponent(components, nextDisabled);
                }
            }
            if (!components.isEmpty()) {
                player.spigot().sendMessage(components.toArray(new BaseComponent[0]));
            }
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("page", String.valueOf(currentPage));
            placeholders.put("pages", String.valueOf(totalPages));
            placeholders.put("prev", prevPage > 0 ? String.valueOf(prevPage) : "-");
            placeholders.put("next", nextPage > 0 ? String.valueOf(nextPage) : "-");
            this.languageManager.sendMessage(sender, "command.history.pagination_hint", placeholders);
        }
    }

    private void appendInteractiveComponent(List<BaseComponent> components, String text, String hover, String command) {
        if (text == null || text.isEmpty()) {
            return;
        }
        BaseComponent[] parts = TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
        HoverEvent hoverEvent = null;
        if (hover != null && !hover.isEmpty()) {
            String hoverText = ChatColor.translateAlternateColorCodes((char)'&', (String)hover);
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)});
        }
        for (BaseComponent part : parts) {
            part.setClickEvent(clickEvent);
            if (hoverEvent != null) {
                part.setHoverEvent(hoverEvent);
            }
            components.add(part);
        }
    }

    private void appendStaticComponent(List<BaseComponent> components, String text) {
        BaseComponent[] parts;
        if (text == null || text.isEmpty()) {
            return;
        }
        for (BaseComponent part : parts = TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text))) {
            components.add(part);
        }
    }

    private String buildHistoryCommand(int page, String playerFilter) {
        StringBuilder command = new StringBuilder("/rulegems history ").append(page);
        if (playerFilter != null && !playerFilter.isEmpty()) {
            command.append(' ').append(playerFilter);
        }
        return command.toString();
    }

    private String safeFormat(String path, Map<String, String> placeholders) {
        String value = this.languageManager.formatMessage("messages." + path, placeholders != null ? placeholders : new HashMap());
        if (value == null || value.startsWith("Missing message")) {
            return "";
        }
        return value;
    }
}

