/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.cubexmc.manager.ConfigManager;
import org.cubexmc.model.GemDefinition;

public class RuleGemsTabCompleter
implements TabCompleter {
    private final ConfigManager configManager;
    private static final List<String> SUB_COMMANDS = Arrays.asList("place", "tp", "revoke", "reload", "rulers", "gems", "scatter", "redeem", "redeemall", "history", "help");

    public RuleGemsTabCompleter(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("rulegems")) {
            return null;
        }
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String sub : SUB_COMMANDS) {
                if (!sub.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                suggestions.add(sub);
            }
            return suggestions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("place")) {
            return this.getGemKeySuggestions(args[1]);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("tp")) {
            return this.getGemKeySuggestions(args[1]);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("revoke")) {
            return this.getOnlinePlayerNames(args[1]);
        }
        if (args.length >= 2 && (args[0].equalsIgnoreCase("redeem") || args[0].equalsIgnoreCase("redeemall"))) {
            return Collections.emptyList();
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("place")) {
            return this.startsWith("~", args[2]) ? Collections.singletonList("~") : Collections.emptyList();
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("place")) {
            return this.startsWith("~", args[3]) ? Collections.singletonList("~") : Collections.emptyList();
        }
        if (args.length == 5 && args[0].equalsIgnoreCase("place")) {
            return this.startsWith("~", args[4]) ? Collections.singletonList("~") : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private boolean startsWith(String option, String typed) {
        return option.toLowerCase().startsWith(typed == null ? "" : typed.toLowerCase());
    }

    private List<String> getGemKeySuggestions(String typed) {
        if (this.configManager == null || this.configManager.getGemDefinitions() == null) {
            return Collections.emptyList();
        }
        String prefix = typed == null ? "" : typed.toLowerCase();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (GemDefinition definition : this.configManager.getGemDefinitions()) {
            if (definition == null || definition.getGemKey() == null) continue;
            String key = definition.getGemKey();
            if (!prefix.isEmpty() && !key.toLowerCase().startsWith(prefix)) continue;
            suggestions.add(key);
        }
        return suggestions;
    }

    private List<String> getOnlinePlayerNames(String typed) {
        String prefix = typed == null ? "" : typed.toLowerCase();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            String name = player.getName();
            if (!prefix.isEmpty() && !name.toLowerCase().startsWith(prefix)) continue;
            suggestions.add(name);
        }
        return suggestions;
    }
}

