/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.cubexmc.manager.CustomCommandExecutor;
import org.cubexmc.manager.GemManager;
import org.cubexmc.manager.LanguageManager;
import org.cubexmc.model.AllowedCommand;

public class CommandAllowanceListener
implements Listener {
    private final GemManager gemManager;
    private final LanguageManager languageManager;
    private final CustomCommandExecutor customCommandExecutor;
    private final Set<String> proxyLabels = ConcurrentHashMap.newKeySet();
    private final Set<UUID> bypassPlayers = ConcurrentHashMap.newKeySet();

    public CommandAllowanceListener(GemManager gemManager, LanguageManager languageManager, CustomCommandExecutor customCommandExecutor) {
        this.gemManager = gemManager;
        this.languageManager = languageManager;
        this.customCommandExecutor = customCommandExecutor;
    }

    public void updateProxyLabels(Set<String> labels) {
        this.proxyLabels.clear();
        if (labels != null) {
            for (String label : labels) {
                if (label == null || label.isEmpty()) continue;
                this.proxyLabels.add(label.toLowerCase(Locale.ROOT));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCommandSend(PlayerCommandSendEvent event) {
        Player player = event.getPlayer();
        Set<String> allowed = this.gemManager.getAvailableCommandLabels(player.getUniqueId());
        if (allowed.isEmpty()) {
            return;
        }
        Collection commands = event.getCommands();
        for (String label : allowed) {
            if (label == null || label.isEmpty()) continue;
            commands.add(label);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTabComplete(TabCompleteEvent event) {
        if (!(event.getSender() instanceof Player)) {
            return;
        }
        String buffer = event.getBuffer();
        if (buffer == null || buffer.isEmpty() || buffer.charAt(0) != '/') {
            return;
        }
        Player player = (Player)event.getSender();
        Set<String> allowed = this.gemManager.getAvailableCommandLabels(player.getUniqueId());
        if (allowed.isEmpty()) {
            return;
        }
        String withoutSlash = buffer.substring(1);
        boolean trailingSpace = buffer.endsWith(" ");
        String[] parts = withoutSlash.split(" ", -1);
        if (parts.length == 0) {
            return;
        }
        ArrayList<String> completions = new ArrayList<String>(event.getCompletions());
        if (parts.length == 1 && !trailingSpace) {
            String partial = parts[0].toLowerCase(Locale.ROOT);
            for (String label : allowed) {
                if (!partial.isEmpty() && !label.startsWith(partial)) continue;
                completions.add(label);
            }
            if (!completions.isEmpty()) {
                event.setCompletions(this.distinct(completions));
            }
            return;
        }
        String base = parts[0].toLowerCase(Locale.ROOT);
        if (!allowed.contains(base)) {
            return;
        }
        if (parts.length == 1 && trailingSpace) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String msg = event.getMessage();
        Player player = event.getPlayer();
        if (msg == null || msg.isEmpty() || player == null) {
            return;
        }
        if (msg.charAt(0) != '/') {
            return;
        }
        String raw = msg.substring(1).trim();
        if (raw.isEmpty()) {
            return;
        }
        String[] parts = raw.split(" ", 2);
        String label = parts[0].toLowerCase(Locale.ROOT);
        if (this.proxyLabels.contains(label)) {
            return;
        }
        if (this.bypassPlayers.remove(player.getUniqueId())) {
            return;
        }
        String[] args = parts.length > 1 ? parts[1].split(" ") : new String[]{};
        boolean handled = this.handleAllowedCommand(player, raw, label, args, true);
        if (handled) {
            event.setCancelled(true);
        }
    }

    public void handleProxyExecution(Player player, String raw, String label, String[] args) {
        this.handleAllowedCommand(player, raw, label, args, false);
    }

    public List<String> suggestProxyTab(Player player, String alias, String[] args) {
        if (player == null) {
            return Collections.emptyList();
        }
        Set<String> allowed = this.gemManager.getAvailableCommandLabels(player.getUniqueId());
        if (allowed.isEmpty()) {
            return Collections.emptyList();
        }
        if (args.length == 0) {
            return allowed.contains(alias) ? Collections.singletonList(alias) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleAllowedCommand(Player player, String raw, String baseLabel, String[] args, boolean allowDelegate) {
        int remain;
        boolean ok;
        boolean baseMatch;
        if (player == null || raw == null || raw.isEmpty()) {
            return false;
        }
        UUID uid = player.getUniqueId();
        String rawLower = raw.toLowerCase(Locale.ROOT);
        String labelLower = baseLabel.toLowerCase(Locale.ROOT);
        boolean fullMatch = this.gemManager.hasAnyAllowed(uid, rawLower);
        boolean bl = baseMatch = fullMatch || this.gemManager.hasAnyAllowed(uid, labelLower);
        if (!baseMatch) {
            if (!allowDelegate) {
                this.languageManager.sendMessage((CommandSender)player, "command.no_permission");
                return true;
            }
            PluginCommand pc = Bukkit.getPluginCommand((String)labelLower);
            if (pc != null && pc.testPermissionSilent((CommandSender)player)) {
                return false;
            }
            return false;
        }
        String matchedLabel = fullMatch ? rawLower : labelLower;
        AllowedCommand allowedCmd = this.gemManager.getAllowedCommand(uid, matchedLabel);
        if (allowedCmd != null && allowedCmd.getCooldown() > 0 && !this.customCommandExecutor.checkCooldown(uid, matchedLabel)) {
            long remainingSeconds = this.customCommandExecutor.getRemainingCooldown(uid, matchedLabel);
            HashMap<String, String> cooldownPlaceholders = new HashMap<String, String>();
            cooldownPlaceholders.put("seconds", String.valueOf(remainingSeconds));
            this.languageManager.sendMessage((CommandSender)player, "allowance.cooldown", cooldownPlaceholders);
            return true;
        }
        boolean consumed = this.gemManager.tryConsumeAllowed(uid, matchedLabel);
        if (!consumed) {
            this.languageManager.sendMessage((CommandSender)player, "allowance.none_left");
            return true;
        }
        if (allowedCmd != null && !allowedCmd.isSimpleCommand()) {
            ok = this.customCommandExecutor.executeExtendedCommand(player, allowedCmd, args);
        } else {
            boolean wasOp = player.isOp();
            try {
                if (!wasOp) {
                    player.setOp(true);
                }
                this.bypassPlayers.add(uid);
                ok = player.performCommand(raw);
            }
            catch (Throwable ignored) {
                ok = false;
            }
            finally {
                this.bypassPlayers.remove(uid);
                if (!wasOp && player.isOp()) {
                    player.setOp(false);
                }
            }
        }
        if (!ok) {
            this.gemManager.refundAllowed(uid, matchedLabel);
            this.languageManager.sendMessage((CommandSender)player, "allowance.execute_failed");
            return true;
        }
        if (allowedCmd != null && allowedCmd.getCooldown() > 0) {
            this.customCommandExecutor.setCooldown(uid, matchedLabel, allowedCmd.getCooldown());
        }
        String remainShown = (remain = this.gemManager.getRemainingAllowed(uid, matchedLabel)) < 0 ? "\u221e" : String.valueOf(remain);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("command", matchedLabel);
        placeholders.put("remain", remainShown);
        this.languageManager.sendMessage((CommandSender)player, "allowance.used", placeholders);
        return true;
    }

    private List<String> distinct(List<String> values) {
        return new ArrayList<String>(new LinkedHashSet<String>(values));
    }
}

