/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.listeners;

import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.cubexmc.RuleGems;
import org.cubexmc.manager.GemManager;

public class PlayerEventListener
implements Listener {
    private final RuleGems plugin;
    private final GemManager gemManager;

    public PlayerEventListener(RuleGems plugin, GemManager gemManager) {
        this.plugin = plugin;
        this.gemManager = gemManager;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.gemManager.onPlayerQuit(event);
        if (this.gemManager.getConfigManager().isInventoryGrantsEnabled()) {
            // empty if block
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.gemManager.onPlayerDropItem(event);
        if (this.gemManager.getConfigManager().isInventoryGrantsEnabled()) {
            this.gemManager.recalculateGrants(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.gemManager.onPlayerDeath(event);
        if (this.gemManager.getConfigManager().isInventoryGrantsEnabled()) {
            this.gemManager.recalculateGrants(event.getEntity());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.gemManager.onPlayerJoin(event);
        if (this.gemManager.getConfigManager().isInventoryGrantsEnabled()) {
            this.gemManager.recalculateGrants(event.getPlayer());
        }
    }
}

