/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.cubexmc.RuleGems;
import org.cubexmc.model.AllowedCommand;
import org.cubexmc.model.ExecuteConfig;
import org.cubexmc.model.GemDefinition;
import org.cubexmc.update.ConfigUpdater;

public class ConfigManager {
    private final RuleGems plugin;
    private FileConfiguration config;
    private FileConfiguration gemsData;
    private File gemsFile;
    private int requiredCount;
    private ExecuteConfig gemScatterExecute;
    private Location randomPlaceCorner1;
    private Location randomPlaceCorner2;
    private String language;
    private boolean broadcastRedeemTitle = true;
    private List<String> redeemAllTitle = Collections.emptyList();
    private Boolean redeemAllBroadcast = null;
    private String redeemAllSound = "ENTITY_ENDER_DRAGON_GROWL";
    private List<String> redeemAllPermissions = Collections.emptyList();
    private List<AllowedCommand> redeemAllAllowed = Collections.emptyList();
    private List<GemDefinition> gemDefinitions = new ArrayList<GemDefinition>();
    private boolean inventoryGrantsEnabled;
    private boolean redeemEnabled;
    private boolean fullSetGrantsAllEnabled;

    public ConfigManager(RuleGems plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        ConfigurationSection ra;
        this.plugin.saveDefaultConfig();
        ConfigUpdater.merge(this.plugin);
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.initGemsFolder();
        this.language = this.plugin.getConfig().getString("language", "zh");
        ConfigurationSection randomPlaceRange = this.getConfig().getConfigurationSection("random_place_range");
        if (randomPlaceRange == null) {
            this.plugin.getLogger().severe("\u914d\u7f6e\u6587\u4ef6\u4e2d\u7f3a\u5c11 random_place_range \u90e8\u5206\u3002");
            return;
        }
        String worldName = randomPlaceRange.getString("world");
        if (worldName == null) {
            this.plugin.getLogger().severe("random_place_range \u4e2d\u7f3a\u5c11 world \u540d\u79f0\u3002");
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u7684\u4e16\u754c: " + worldName);
            return;
        }
        this.randomPlaceCorner1 = this.getLocationFromConfig(randomPlaceRange, "corner1", world);
        this.randomPlaceCorner2 = this.getLocationFromConfig(randomPlaceRange, "corner2", world);
        if (this.randomPlaceCorner1 == null || this.randomPlaceCorner2 == null) {
            this.plugin.getLogger().severe("random_place_range \u4e2d\u7684 corner1 \u6216 corner2 \u914d\u7f6e\u65e0\u6548\u3002");
            return;
        }
        this.loadGemDefinitions();
        int total = 0;
        for (GemDefinition d : this.gemDefinitions) {
            total += d != null ? d.getCount() : 0;
        }
        this.requiredCount = Math.max(0, total);
        ConfigurationSection gp = this.config.getConfigurationSection("grant_policy");
        this.inventoryGrantsEnabled = gp != null && gp.getBoolean("inventory_grants", false);
        this.redeemEnabled = gp == null ? true : gp.getBoolean("redeem_enabled", true);
        this.fullSetGrantsAllEnabled = gp == null ? true : gp.getBoolean("full_set_grants_all", true);
        ConfigurationSection toggles = this.config.getConfigurationSection("toggles");
        if (toggles != null) {
            this.broadcastRedeemTitle = toggles.getBoolean("broadcast_redeem_title", true);
        }
        if ((ra = this.config.getConfigurationSection("redeem_all")) != null) {
            Object titlesObj = ra.get("titles");
            this.redeemAllTitle = this.toStringList(titlesObj);
            this.redeemAllBroadcast = ra.isSet("broadcast") ? Boolean.valueOf(ra.getBoolean("broadcast")) : null;
            String s = this.stringOf(ra.get("sound"));
            if (s != null && !s.isEmpty()) {
                this.redeemAllSound = s;
            }
            this.redeemAllPermissions = this.toStringList(ra.get("permissions"));
            this.redeemAllAllowed = this.parseAllowedCommands(ra.get("command_allows"));
        } else {
            this.redeemAllTitle = Collections.emptyList();
            this.redeemAllBroadcast = null;
            this.redeemAllPermissions = Collections.emptyList();
            this.redeemAllAllowed = Collections.emptyList();
        }
        this.gemScatterExecute = this.loadExecuteConfig("gem_scatter_execute");
    }

    private void loadGemDefinitions() {
        ConfigurationSection sec;
        this.gemDefinitions.clear();
        File gemsFolder = new File(this.plugin.getDataFolder(), "gems");
        if (gemsFolder.exists() && gemsFolder.isDirectory()) {
            this.loadGemsFromFolder(gemsFolder);
            if (!this.gemDefinitions.isEmpty()) {
                this.plugin.getLogger().info("\u4ece gems \u6587\u4ef6\u5939\u52a0\u8f7d\u4e86 " + this.gemDefinitions.size() + " \u4e2a\u5b9d\u77f3\u914d\u7f6e");
                return;
            }
        }
        if ((sec = this.config.getConfigurationSection("gems")) != null) {
            this.plugin.getLogger().warning("\u68c0\u6d4b\u5230\u65e7\u7248\u914d\u7f6e\u683c\u5f0f\uff01\u5efa\u8bae\u5c06\u5b9d\u77f3\u914d\u7f6e\u8fc1\u79fb\u5230 gems \u6587\u4ef6\u5939");
            for (String key : sec.getKeys(false)) {
                ConfigurationSection sub = sec.getConfigurationSection(key);
                HashMap<String, Object> m = new HashMap<String, Object>();
                if (sub != null) {
                    for (String k : sub.getKeys(false)) {
                        m.put(k, sub.get(k));
                    }
                }
                GemDefinition def = this.buildGemDefinitionFromMap(key, m);
                this.gemDefinitions.add(def);
            }
            return;
        }
        List list = this.config.getMapList("gems");
        if (list != null && !list.isEmpty()) {
            this.plugin.getLogger().warning("\u68c0\u6d4b\u5230\u65e7\u7248\u5217\u8868\u914d\u7f6e\u683c\u5f0f\uff01\u5efa\u8bae\u5c06\u5b9d\u77f3\u914d\u7f6e\u8fc1\u79fb\u5230 gems \u6587\u4ef6\u5939");
            int index = 0;
            for (Map map : list) {
                Object keyObj = map.get("key");
                String key = keyObj != null ? this.stringOf(keyObj) : String.valueOf(index);
                GemDefinition def = this.buildGemDefinitionFromMap(key, map);
                this.gemDefinitions.add(def);
                ++index;
            }
        }
    }

    private void loadGemsFromFolder(File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadGemsFromFolder(file);
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".yml")) continue;
            this.loadGemsFromFile(file);
        }
    }

    private void loadGemsFromFile(File file) {
        try {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
            for (String gemKey : yaml.getKeys(false)) {
                ConfigurationSection gemSection = yaml.getConfigurationSection(gemKey);
                if (gemSection == null) continue;
                HashMap<String, Object> gemMap = new HashMap<String, Object>();
                for (String key : gemSection.getKeys(false)) {
                    gemMap.put(key, gemSection.get(key));
                }
                GemDefinition def = this.buildGemDefinitionFromMap(gemKey, gemMap);
                this.gemDefinitions.add(def);
                this.plugin.getLogger().info("\u4ece\u6587\u4ef6 " + file.getName() + " \u52a0\u8f7d\u5b9d\u77f3: " + gemKey);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u52a0\u8f7d\u5b9d\u77f3\u914d\u7f6e\u6587\u4ef6 " + file.getName() + " \u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private GemDefinition buildGemDefinitionFromMap(String gemKey, Map<?, ?> map) {
        Map rangeMap;
        String worldName;
        String matStr = this.stringOf(map.get("material"));
        Material material = Material.RED_STAINED_GLASS;
        if (matStr != null && !matStr.isEmpty()) {
            try {
                material = Material.valueOf((String)matStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String nameStr = this.stringOf(map.get("name"));
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)"&c\u6743\u529b\u5b9d\u77f3");
        if (nameStr != null && !nameStr.isEmpty()) {
            displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)nameStr);
        }
        String particleStr = this.stringOf(map.get("particle"));
        Particle particle = Particle.FLAME;
        if (particleStr != null && !particleStr.isEmpty()) {
            try {
                particle = Particle.valueOf((String)particleStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String soundStr = this.stringOf(map.get("sound"));
        Sound sound = Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
        if (soundStr != null && !soundStr.isEmpty()) {
            try {
                sound = Sound.valueOf((String)soundStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ExecuteConfig onPickup = null;
        Object pickup = map.get("on_pickup");
        if (pickup instanceof Map) {
            onPickup = new ExecuteConfig(this.toStringList(((Map)pickup).get("commands")), this.stringOf(((Map)pickup).get("sound")), this.stringOf(((Map)pickup).get("particle")));
        }
        ExecuteConfig onScatter = null;
        Object scatter = map.get("on_scatter");
        if (scatter instanceof Map) {
            onScatter = new ExecuteConfig(this.toStringList(((Map)scatter).get("commands")), this.stringOf(((Map)scatter).get("sound")), this.stringOf(((Map)scatter).get("particle")));
        }
        ExecuteConfig onRedeem = null;
        Object redeem = map.get("on_redeem");
        if (redeem instanceof Map) {
            onRedeem = new ExecuteConfig(this.toStringList(((Map)redeem).get("commands")), this.stringOf(((Map)redeem).get("sound")), this.stringOf(((Map)redeem).get("particle")));
        }
        List<String> perms = this.toStringList(map.get("permissions"));
        String group = this.stringOf(map.get("vault_group"));
        List<String> lore = this.toStringList(map.get("lore"));
        List<String> redeemTitle = this.toStringList(map.get("redeem_title"));
        boolean enchanted = false;
        Object encObj = map.get("enchanted");
        if (encObj instanceof Boolean) {
            enchanted = (Boolean)encObj;
        } else if (encObj != null) {
            String s = String.valueOf(encObj).trim();
            enchanted = s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on");
        }
        List<AllowedCommand> allowed = this.parseAllowedCommands(map.get("command_allows"));
        List<String> mutex = this.toStringList(map.get("mutual_exclusive"));
        int count = 1;
        Object cObj = map.get("count");
        if (cObj != null) {
            try {
                count = Integer.parseInt(String.valueOf(cObj));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Location corner1 = null;
        Location corner2 = null;
        Object rangeObj = map.get("random_place_range");
        if (rangeObj instanceof Map && (worldName = this.stringOf((rangeMap = (Map)rangeObj).get("world"))) != null && !worldName.isEmpty()) {
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                Object c1Obj = rangeMap.get("corner1");
                Object c2Obj = rangeMap.get("corner2");
                if (c1Obj instanceof Map && c2Obj instanceof Map) {
                    corner1 = this.parseLocationFromMap((Map)c1Obj, world);
                    corner2 = this.parseLocationFromMap((Map)c2Obj, world);
                }
            } else {
                this.plugin.getLogger().warning("\u5b9d\u77f3 " + gemKey + " \u7684\u751f\u6210\u8303\u56f4\u914d\u7f6e\u4e2d\u627e\u4e0d\u5230\u4e16\u754c: " + worldName);
            }
        }
        return new GemDefinition(gemKey, material, displayName, particle, sound, onPickup, onScatter, onRedeem, perms, group, lore, redeemTitle, enchanted, allowed, mutex, count, corner1, corner2);
    }

    private Location parseLocationFromMap(Map<?, ?> map, World world) {
        try {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            Object xObj = map.get("x");
            Object yObj = map.get("y");
            Object zObj = map.get("z");
            if (xObj != null) {
                x = Double.parseDouble(String.valueOf(xObj));
            }
            if (yObj != null) {
                y = Double.parseDouble(String.valueOf(yObj));
            }
            if (zObj != null) {
                z = Double.parseDouble(String.valueOf(zObj));
            }
            return new Location(world, x, y, z);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u89e3\u6790 Location \u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private List<AllowedCommand> parseAllowedCommands(Object allowsObj) {
        ArrayList<AllowedCommand> allowed = new ArrayList<AllowedCommand>();
        if (allowsObj instanceof List) {
            List raw = (List)allowsObj;
            for (Object e : raw) {
                if (!(e instanceof Map)) continue;
                Map map = (Map)e;
                Object commandObj = map.get("command");
                Object executeObj = map.get("execute");
                Object uses = map.get("time_limit");
                Object cooldownObj = map.get("cooldown");
                if (commandObj == null || executeObj == null) {
                    this.plugin.getLogger().warning("command_allows \u914d\u7f6e\u9519\u8bef\uff1a\u5fc5\u987b\u5305\u542b 'command' \u548c 'execute' \u5b57\u6bb5");
                    continue;
                }
                int u = -1;
                int cooldown = 0;
                try {
                    u = Integer.parseInt(String.valueOf(uses));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    cooldown = Integer.parseInt(String.valueOf(cooldownObj));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String cmd = String.valueOf(commandObj).trim();
                if (cmd.startsWith("/")) {
                    cmd = cmd.substring(1);
                }
                String label = cmd.split("\\s+")[0].toLowerCase();
                List<String> executeCmds = this.toStringList(executeObj);
                allowed.add(new AllowedCommand(label, u, executeCmds, cooldown));
            }
        }
        return allowed;
    }

    private String stringOf(Object o) {
        return o == null ? null : String.valueOf(o);
    }

    private List<String> toStringList(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            List raw = (List)o;
            ArrayList<String> out = new ArrayList<String>();
            for (Object e : raw) {
                if (e == null) continue;
                out.add(String.valueOf(e));
            }
            return out;
        }
        return Collections.singletonList(String.valueOf(o));
    }

    private void initGemsFolder() {
        File defaultGemsFile;
        File gemsFolder = new File(this.plugin.getDataFolder(), "gems");
        if (!gemsFolder.exists()) {
            gemsFolder.mkdirs();
            this.plugin.getLogger().info("\u521b\u5efa gems \u6587\u4ef6\u5939");
        }
        if (!(defaultGemsFile = new File(gemsFolder, "gems.yml")).exists()) {
            try {
                this.plugin.saveResource("gems/gems.yml", false);
                this.plugin.getLogger().info("\u521b\u5efa\u9ed8\u8ba4\u5b9d\u77f3\u914d\u7f6e\u6587\u4ef6: gems/gems.yml");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u65e0\u6cd5\u590d\u5236\u9ed8\u8ba4 gems.yml \u6587\u4ef6: " + e.getMessage());
            }
        }
    }

    public void initGemFile() {
        this.gemsFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!this.gemsFile.exists()) {
            this.gemsFile.getParentFile().mkdirs();
            this.plugin.saveResource("data.yml", false);
        }
    }

    private ExecuteConfig loadExecuteConfig(String path) {
        ExecuteConfig execCfg = new ExecuteConfig(this.config.getStringList(path + ".commands"), this.config.getString(path + ".sound"), this.config.getString(path + ".particle"));
        return execCfg;
    }

    private Location getLocationFromConfig(ConfigurationSection configSection, String path, World world) {
        ConfigurationSection locSection = configSection.getConfigurationSection(path);
        if (locSection == null) {
            this.plugin.getLogger().severe("\u914d\u7f6e\u4e2d\u7f3a\u5c11 " + path + " \u8282\u3002");
            return null;
        }
        double x = locSection.getDouble("x");
        double y = locSection.getDouble("y");
        double z = locSection.getDouble("z");
        return new Location(world, x, y, z);
    }

    public void reloadConfigs() {
        this.loadConfigs();
    }

    public void saveGemData(FileConfiguration data) {
        try {
            data.save(this.gemsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration readGemsData() {
        this.initGemFile();
        this.gemsData = YamlConfiguration.loadConfiguration((File)this.gemsFile);
        return this.gemsData;
    }

    public FileConfiguration getGemsData() {
        if (this.gemsData == null) {
            this.readGemsData();
        }
        return this.gemsData;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public ExecuteConfig getGemScatterExecute() {
        return this.gemScatterExecute;
    }

    public Location getRandomPlaceCorner1() {
        return this.randomPlaceCorner1;
    }

    public Location getRandomPlaceCorner2() {
        return this.randomPlaceCorner2;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<GemDefinition> getGemDefinitions() {
        return this.gemDefinitions;
    }

    public boolean isInventoryGrantsEnabled() {
        return this.inventoryGrantsEnabled;
    }

    public boolean isRedeemEnabled() {
        return this.redeemEnabled;
    }

    public boolean isFullSetGrantsAllEnabled() {
        return this.fullSetGrantsAllEnabled;
    }

    public boolean isBroadcastRedeemTitle() {
        return this.broadcastRedeemTitle;
    }

    public List<String> getRedeemAllTitle() {
        return this.redeemAllTitle;
    }

    public Boolean getRedeemAllBroadcastOverride() {
        return this.redeemAllBroadcast;
    }

    public String getRedeemAllSound() {
        return this.redeemAllSound;
    }

    public List<String> getRedeemAllPermissions() {
        return this.redeemAllPermissions;
    }

    public List<AllowedCommand> getRedeemAllAllowedCommands() {
        return this.redeemAllAllowed;
    }

    public Set<String> collectAllowedCommandLabels() {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        if (this.gemDefinitions != null) {
            for (GemDefinition def : this.gemDefinitions) {
                if (def == null || def.getAllowedCommands() == null) continue;
                for (AllowedCommand cmd : def.getAllowedCommands()) {
                    String label;
                    if (cmd == null || (label = cmd.getLabel()) == null || label.isEmpty()) continue;
                    labels.add(label.toLowerCase(Locale.ROOT));
                }
            }
        }
        if (this.redeemAllAllowed != null) {
            for (AllowedCommand cmd : this.redeemAllAllowed) {
                String label;
                if (cmd == null || (label = cmd.getLabel()) == null || label.isEmpty()) continue;
                labels.add(label.toLowerCase(Locale.ROOT));
            }
        }
        return labels;
    }
}

