/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.cubexmc.RuleGems;
import org.cubexmc.manager.LanguageManager;
import org.cubexmc.model.AllowedCommand;
import org.cubexmc.utils.SchedulerUtil;

public class CustomCommandExecutor {
    private final RuleGems plugin;
    private final LanguageManager languageManager;
    private final Map<UUID, Map<String, Long>> playerCooldowns = new HashMap<UUID, Map<String, Long>>();

    public CustomCommandExecutor(RuleGems plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
    }

    private boolean executeAsConsole(String command, Player player) {
        try {
            SchedulerUtil.globalRun((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command), 0L, -1L);
            this.plugin.getLogger().info("[\u8c03\u8bd5] \u540e\u53f0\u547d\u4ee4\u5df2\u63d0\u4ea4\u6267\u884c: " + command);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u540e\u53f0\u6267\u884c\u547d\u4ee4\u5931\u8d25: " + command);
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAsPlayerOp(String command, Player player) {
        boolean wasOp = player.isOp();
        try {
            boolean result;
            if (!wasOp) {
                player.setOp(true);
            }
            boolean bl = result = player.performCommand(command);
            return bl;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u73a9\u5bb6\u6267\u884c\u547d\u4ee4\u5931\u8d25: " + command);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!wasOp && player.isOp()) {
                player.setOp(false);
            }
        }
    }

    private String replacePlaceholders(String text, Map<String, String> placeholders, String[] args) {
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        Pattern pattern = Pattern.compile("%arg(\\d+)\\|([^%]+)%");
        Matcher matcher = pattern.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int argIndex = Integer.parseInt(matcher.group(1)) - 1;
            String defaultValue = matcher.group(2);
            String replacement = argIndex >= 0 && argIndex < args.length ? args[argIndex] : defaultValue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public boolean executeExtendedCommand(Player player, AllowedCommand allowedCmd, String[] args) {
        if (player == null || allowedCmd == null) {
            return false;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%player%", player.getName());
        for (int i = 0; i < args.length; ++i) {
            placeholders.put("%arg" + (i + 1) + "%", args[i]);
        }
        this.plugin.getLogger().info("[\u8c03\u8bd5] \u6267\u884c\u6269\u5c55\u547d\u4ee4\uff0c\u73a9\u5bb6: " + player.getName());
        this.plugin.getLogger().info("[\u8c03\u8bd5] \u5360\u4f4d\u7b26: " + String.valueOf(placeholders));
        this.plugin.getLogger().info("[\u8c03\u8bd5] \u53c2\u6570: " + Arrays.toString(args));
        this.plugin.getLogger().info("[\u8c03\u8bd5] \u547d\u4ee4\u5217\u8868: " + String.valueOf(allowedCmd.getCommands()));
        boolean allSuccess = true;
        for (String commandLine : allowedCmd.getCommands()) {
            if (commandLine == null || commandLine.trim().isEmpty()) continue;
            this.plugin.getLogger().info("[\u8c03\u8bd5] \u539f\u59cb\u547d\u4ee4\u884c: " + commandLine);
            String[] parsed = AllowedCommand.parseExecutor(commandLine);
            String executor = parsed[0];
            String actualCommand = parsed[1];
            this.plugin.getLogger().info("[\u8c03\u8bd5] \u6267\u884c\u8005: " + executor + ", \u5b9e\u9645\u547d\u4ee4: " + actualCommand);
            String finalCommand = this.replacePlaceholders(actualCommand, placeholders, args);
            this.plugin.getLogger().info("[\u8c03\u8bd5] \u66ff\u6362\u540e\u547d\u4ee4: " + finalCommand);
            if (finalCommand.startsWith("/")) {
                finalCommand = finalCommand.substring(1);
            }
            this.plugin.getLogger().info("[\u8c03\u8bd5] \u6700\u7ec8\u6267\u884c\u547d\u4ee4: " + finalCommand);
            boolean success = false;
            success = "console".equals(executor) ? this.executeAsConsole(finalCommand, player) : this.executeAsPlayerOp(finalCommand, player);
            if (success) continue;
            allSuccess = false;
            if (this.languageManager != null) {
                HashMap<String, String> messagePlaceholders = new HashMap<String, String>();
                messagePlaceholders.put("command", finalCommand);
                this.languageManager.sendMessage((CommandSender)player, "allowance.command_failed_detail", messagePlaceholders);
                continue;
            }
            player.sendMessage("\u00a7c\u547d\u4ee4\u6267\u884c\u5931\u8d25: " + finalCommand);
        }
        return allSuccess;
    }

    public boolean checkCooldown(UUID playerUuid, String commandName) {
        Map<String, Long> cooldowns = this.playerCooldowns.get(playerUuid);
        if (cooldowns == null) {
            return true;
        }
        Long expireTime = cooldowns.get(commandName);
        if (expireTime == null) {
            return true;
        }
        return System.currentTimeMillis() >= expireTime;
    }

    public long getRemainingCooldown(UUID playerUuid, String commandName) {
        Map<String, Long> cooldowns = this.playerCooldowns.get(playerUuid);
        if (cooldowns == null) {
            return 0L;
        }
        Long expireTime = cooldowns.get(commandName);
        if (expireTime == null) {
            return 0L;
        }
        long remaining = (expireTime - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    public void setCooldown(UUID playerUuid, String commandName, int seconds) {
        Map cooldowns = this.playerCooldowns.computeIfAbsent(playerUuid, k -> new HashMap());
        long expireTime = System.currentTimeMillis() + (long)seconds * 1000L;
        cooldowns.put(commandName, expireTime);
    }
}

