/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.cubexmc.RuleGems;
import org.cubexmc.manager.ConfigManager;
import org.cubexmc.manager.HistoryLogger;
import org.cubexmc.manager.LanguageManager;
import org.cubexmc.model.AllowedCommand;
import org.cubexmc.model.ExecuteConfig;
import org.cubexmc.model.GemDefinition;
import org.cubexmc.utils.EffectUtils;
import org.cubexmc.utils.SchedulerUtil;

public class GemManager {
    private final RuleGems plugin;
    private final ConfigManager configManager;
    private final EffectUtils effectUtils;
    private final LanguageManager languageManager;
    private HistoryLogger historyLogger;
    private final NamespacedKey ruleGemKey;
    private final NamespacedKey uniqueIdKey;
    private final NamespacedKey gemKeyKey;
    private final Map<Location, UUID> locationToGemUuid = new HashMap<Location, UUID>();
    private final Map<UUID, Player> gemUuidToHolder = new HashMap<UUID, Player>();
    private final Map<UUID, String> gemUuidToKey = new HashMap<UUID, String>();
    private final Map<UUID, UUID> gemIdToRedeemer = new HashMap<UUID, UUID>();
    private final Map<UUID, Set<String>> playerUuidToRedeemedKeys = new HashMap<UUID, Set<String>>();
    private final Map<UUID, Map<String, Integer>> ownerKeyCount = new HashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Set<String>> playerActiveHeldKeys = new HashMap<UUID, Set<String>>();
    private final Map<UUID, PermissionAttachment> invAttachments = new HashMap<UUID, PermissionAttachment>();
    private final Map<UUID, PermissionAttachment> redeemAttachments = new HashMap<UUID, PermissionAttachment>();
    private UUID fullSetOwner = null;
    private final Map<UUID, Set<String>> pendingPermRevokes = new HashMap<UUID, Set<String>>();
    private final Map<UUID, Set<String>> pendingGroupRevokes = new HashMap<UUID, Set<String>>();
    private final Map<UUID, Map<UUID, Map<String, Integer>>> playerGemHeldUses = new HashMap<UUID, Map<UUID, Map<String, Integer>>>();
    private final Map<UUID, Map<UUID, Map<String, Integer>>> playerGemRedeemUses = new HashMap<UUID, Map<UUID, Map<String, Integer>>>();
    private final Map<UUID, Map<String, Integer>> playerGlobalAllowedUses = new HashMap<UUID, Map<String, Integer>>();
    private static final Locale ROOT_LOCALE = Locale.ROOT;

    public GemManager(RuleGems plugin, ConfigManager configManager, EffectUtils effectUtils, LanguageManager languageManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.effectUtils = effectUtils;
        this.languageManager = languageManager;
        this.ruleGemKey = new NamespacedKey((Plugin)plugin, "rule_gem");
        this.uniqueIdKey = new NamespacedKey((Plugin)plugin, "unique_id");
        this.gemKeyKey = new NamespacedKey((Plugin)plugin, "gem_key");
    }

    @EventHandler
    public void onGemDamage(BlockDamageEvent event) {
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (this.locationToGemUuid.containsKey(block.getLocation())) {
            event.setInstaBreak(true);
        }
    }

    public void loadGems() {
        ConfigurationSection heldGemsSection;
        ConfigurationSection au;
        ConfigurationSection gr;
        ConfigurationSection pr;
        ConfigurationSection fso;
        ConfigurationSection ownerById;
        ConfigurationSection redeemedSection;
        FileConfiguration gemsData = this.configManager.readGemsData();
        if (gemsData == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u52a0\u8f7d gemsData \u914d\u7f6e\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3002");
            return;
        }
        this.locationToGemUuid.clear();
        this.gemUuidToHolder.clear();
        this.gemUuidToKey.clear();
        this.gemIdToRedeemer.clear();
        this.playerUuidToRedeemedKeys.clear();
        this.ownerKeyCount.clear();
        this.playerActiveHeldKeys.clear();
        this.pendingPermRevokes.clear();
        this.pendingGroupRevokes.clear();
        this.playerGemHeldUses.clear();
        this.playerGemRedeemUses.clear();
        this.playerGlobalAllowedUses.clear();
        this.fullSetOwner = null;
        ConfigurationSection placedGemsSection = gemsData.getConfigurationSection("placed-gems");
        if (placedGemsSection == null) {
            placedGemsSection = gemsData.getConfigurationSection("placed-gams");
        }
        if ((redeemedSection = gemsData.getConfigurationSection("redeemed")) != null) {
            for (Object playerUuidStr : redeemedSection.getKeys(false)) {
                UUID pu = UUID.fromString((String)playerUuidStr);
                List list = redeemedSection.getStringList((String)playerUuidStr);
                if (list == null) continue;
                this.playerUuidToRedeemedKeys.put(pu, new HashSet(list));
            }
        }
        if ((ownerById = gemsData.getConfigurationSection("redeem_owner_by_id")) != null) {
            for (Object gid : ownerById.getKeys(false)) {
                try {
                    UUID gem = UUID.fromString((String)gid);
                    UUID player = UUID.fromString(ownerById.getString((String)gid));
                    this.gemIdToRedeemer.put(gem, player);
                }
                catch (Exception gem) {}
            }
        } else {
            ConfigurationSection ownerSec = gemsData.getConfigurationSection("redeem_owner");
            if (ownerSec != null) {
                for (Object gemKey : ownerSec.getKeys(false)) {
                    String uuidStr = ownerSec.getString((String)gemKey);
                    try {
                        UUID player = UUID.fromString(uuidStr);
                        for (Map.Entry<UUID, String> e : this.gemUuidToKey.entrySet()) {
                            if (e.getValue() == null || !e.getValue().equalsIgnoreCase((String)gemKey)) continue;
                            this.gemIdToRedeemer.put(e.getKey(), player);
                        }
                    }
                    catch (Exception player) {
                    }
                }
            }
        }
        if ((fso = gemsData.getConfigurationSection("full_set_owner")) != null) {
            String u = fso.getString("uuid");
            try {
                this.fullSetOwner = UUID.fromString(u);
            }
            catch (Exception gemKey) {
                // empty catch block
            }
        }
        if ((pr = gemsData.getConfigurationSection("pending_revokes.permissions")) != null) {
            for (Object pid : pr.getKeys(false)) {
                try {
                    UUID id = UUID.fromString((String)pid);
                    List list = pr.getStringList((String)pid);
                    if (list == null || list.isEmpty()) continue;
                    this.pendingPermRevokes.put(id, new HashSet(list));
                }
                catch (Exception id) {}
            }
        }
        if ((gr = gemsData.getConfigurationSection("pending_revokes.groups")) != null) {
            for (Iterator pid : gr.getKeys(false)) {
                try {
                    UUID id = UUID.fromString(pid);
                    List list = gr.getStringList(pid);
                    if (list == null || list.isEmpty()) continue;
                    this.pendingGroupRevokes.put(id, new HashSet(list));
                }
                catch (Exception id) {}
            }
        }
        if ((au = gemsData.getConfigurationSection("allowed_uses")) != null) {
            for (String playerId : au.getKeys(false)) {
                try {
                    ConfigurationSection globSec;
                    Object gid4;
                    ConfigurationSection legacy;
                    ConfigurationSection redSec;
                    UUID uid = UUID.fromString(playerId);
                    ConfigurationSection playerSec = au.getConfigurationSection(playerId);
                    if (playerSec == null) continue;
                    ConfigurationSection heldSec = playerSec.getConfigurationSection("held_instances");
                    if (heldSec != null) {
                        HashMap perHeld = new HashMap();
                        for (Object gid2 : heldSec.getKeys(false)) {
                            try {
                                UUID gem = UUID.fromString((String)gid2);
                                ConfigurationSection labels = heldSec.getConfigurationSection((String)gid2);
                                HashMap<String, Integer> map = new HashMap<String, Integer>();
                                if (labels != null) {
                                    for (Object l : labels.getKeys(false)) {
                                        map.put(((String)l).toLowerCase(Locale.ROOT), labels.getInt((String)l, 0));
                                    }
                                }
                                perHeld.put(gem, map);
                            }
                            catch (Exception gem) {}
                        }
                        if (!perHeld.isEmpty()) {
                            this.playerGemHeldUses.put(uid, perHeld);
                        }
                    }
                    if ((redSec = playerSec.getConfigurationSection("redeemed_instances")) != null) {
                        Object gid2;
                        HashMap perRed = new HashMap();
                        gid2 = redSec.getKeys(false).iterator();
                        while (gid2.hasNext()) {
                            String gid3 = (String)gid2.next();
                            try {
                                UUID gem = UUID.fromString(gid3);
                                ConfigurationSection labels = redSec.getConfigurationSection(gid3);
                                HashMap<String, Integer> map = new HashMap<String, Integer>();
                                if (labels != null) {
                                    Object l;
                                    l = labels.getKeys(false).iterator();
                                    while (l.hasNext()) {
                                        String l2 = (String)l.next();
                                        map.put(l2.toLowerCase(Locale.ROOT), labels.getInt(l2, 0));
                                    }
                                }
                                perRed.put(gem, map);
                            }
                            catch (Exception gem) {}
                        }
                        if (!perRed.isEmpty()) {
                            this.playerGemRedeemUses.put(uid, perRed);
                        }
                    }
                    if ((legacy = playerSec.getConfigurationSection("instances")) != null && !legacy.getKeys(false).isEmpty() && !this.playerGemRedeemUses.containsKey(uid)) {
                        HashMap perRed = new HashMap();
                        for (Object gid4 : legacy.getKeys(false)) {
                            try {
                                UUID gem = UUID.fromString((String)gid4);
                                ConfigurationSection labels = legacy.getConfigurationSection((String)gid4);
                                HashMap<String, Integer> map = new HashMap<String, Integer>();
                                if (labels != null) {
                                    for (String l : labels.getKeys(false)) {
                                        map.put(l.toLowerCase(Locale.ROOT), labels.getInt(l, 0));
                                    }
                                }
                                perRed.put(gem, map);
                            }
                            catch (Exception gem) {}
                        }
                        if (!perRed.isEmpty()) {
                            this.playerGemRedeemUses.put(uid, perRed);
                        }
                    }
                    if ((globSec = playerSec.getConfigurationSection("global")) == null) continue;
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    gid4 = globSec.getKeys(false).iterator();
                    while (gid4.hasNext()) {
                        String l = (String)gid4.next();
                        map.put(l.toLowerCase(Locale.ROOT), globSec.getInt(l, 0));
                    }
                    if (map.isEmpty()) continue;
                    this.playerGlobalAllowedUses.put(uid, map);
                }
                catch (Exception uid) {}
            }
        }
        if (placedGemsSection != null) {
            for (Object uuidStr : placedGemsSection.getKeys(false)) {
                UUID gemId;
                String worldName = placedGemsSection.getString((String)uuidStr + ".world");
                double x = placedGemsSection.getDouble((String)uuidStr + ".x");
                double y = placedGemsSection.getDouble((String)uuidStr + ".y");
                double z = placedGemsSection.getDouble((String)uuidStr + ".z");
                String gemKey = placedGemsSection.getString((String)uuidStr + ".gem_key", "default");
                World w = Bukkit.getWorld((String)worldName);
                if (w == null) continue;
                Location loc = new Location(w, x, y, z);
                try {
                    gemId = UUID.fromString((String)uuidStr);
                }
                catch (Exception ignored) {
                    continue;
                }
                this.locationToGemUuid.put(loc, gemId);
                this.gemUuidToKey.put(gemId, gemKey);
            }
        }
        if ((heldGemsSection = gemsData.getConfigurationSection("held-gems")) != null) {
            for (String uuidStr : heldGemsSection.getKeys(false)) {
                UUID gemId;
                UUID playerUUID;
                String playerUUIDStr = heldGemsSection.getString(uuidStr + ".player_uuid");
                String gemKey = heldGemsSection.getString(uuidStr + ".gem_key", "default");
                if (playerUUIDStr == null) continue;
                try {
                    playerUUID = UUID.fromString(playerUUIDStr);
                    gemId = UUID.fromString(uuidStr);
                }
                catch (Exception ignored) {
                    continue;
                }
                this.gemUuidToKey.put(gemId, gemKey);
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player != null && player.isOnline()) {
                    this.gemUuidToHolder.put(gemId, player);
                    continue;
                }
                this.randomPlaceGem(gemId);
            }
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.applyPendingRevokesIfAny(p);
        }
        HashMap<String, String> placeholders1 = new HashMap<String, String>();
        placeholders1.put("count", String.valueOf(this.locationToGemUuid.size()));
        this.languageManager.logMessage("gems_loaded", placeholders1);
        HashMap<String, String> placeholders2 = new HashMap<String, String>();
        placeholders2.put("count", String.valueOf(this.gemUuidToHolder.size()));
        this.languageManager.logMessage("gems_held_loaded", placeholders2);
    }

    public void saveGems() {
        String base;
        FileConfiguration gemsData = this.configManager.getGemsData();
        gemsData.set("placed-gems", null);
        gemsData.set("held-gems", null);
        gemsData.set("redeemed", null);
        gemsData.set("redeem_owner", null);
        gemsData.set("redeem_owner_by_id", null);
        gemsData.set("full_set_owner", null);
        gemsData.set("pending_revokes", null);
        gemsData.set("allowed_uses", null);
        for (Location location : this.locationToGemUuid.keySet()) {
            String path = "placed-gems." + this.locationToGemUuid.get(location).toString();
            gemsData.set(path + ".world", (Object)location.getWorld().getName());
            gemsData.set(path + ".x", (Object)location.getX());
            gemsData.set(path + ".y", (Object)location.getY());
            gemsData.set(path + ".z", (Object)location.getZ());
            gemsData.set(path + ".gem_key", (Object)this.gemUuidToKey.get(this.locationToGemUuid.get(location)));
        }
        for (UUID uUID : this.gemUuidToHolder.keySet()) {
            Player player = this.gemUuidToHolder.get(uUID);
            String path = "held-gems." + uUID.toString();
            gemsData.set(path + ".player", (Object)player.getName());
            gemsData.set(path + ".player_uuid", (Object)player.getUniqueId().toString());
            gemsData.set(path + ".gem_key", (Object)this.gemUuidToKey.get(uUID));
        }
        for (Map.Entry entry : this.playerUuidToRedeemedKeys.entrySet()) {
            base = "redeemed." + ((UUID)entry.getKey()).toString();
            gemsData.set(base, new ArrayList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.gemIdToRedeemer.entrySet()) {
            gemsData.set("redeem_owner_by_id." + ((UUID)entry.getKey()).toString(), (Object)((UUID)entry.getValue()).toString());
        }
        if (this.fullSetOwner != null) {
            gemsData.set("full_set_owner.uuid", (Object)this.fullSetOwner.toString());
        }
        for (Map.Entry entry : this.pendingPermRevokes.entrySet()) {
            gemsData.set("pending_revokes.permissions." + String.valueOf(entry.getKey()), new ArrayList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.pendingGroupRevokes.entrySet()) {
            gemsData.set("pending_revokes.groups." + String.valueOf(entry.getKey()), new ArrayList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.playerGemHeldUses.entrySet()) {
            base = "allowed_uses." + ((UUID)entry.getKey()).toString();
            for (Map.Entry inst : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry l : ((Map)inst.getValue()).entrySet()) {
                    gemsData.set(base + ".held_instances." + ((UUID)inst.getKey()).toString() + "." + (String)l.getKey(), l.getValue());
                }
            }
        }
        for (Map.Entry entry : this.playerGemRedeemUses.entrySet()) {
            base = "allowed_uses." + ((UUID)entry.getKey()).toString();
            for (Map.Entry inst : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry l : ((Map)inst.getValue()).entrySet()) {
                    gemsData.set(base + ".redeemed_instances." + ((UUID)inst.getKey()).toString() + "." + (String)l.getKey(), l.getValue());
                }
            }
        }
        for (Map.Entry entry : this.playerGlobalAllowedUses.entrySet()) {
            base = "allowed_uses." + ((UUID)entry.getKey()).toString();
            for (Map.Entry l : ((Map)entry.getValue()).entrySet()) {
                gemsData.set(base + ".global." + (String)l.getKey(), l.getValue());
            }
        }
        this.configManager.saveGemData(gemsData);
    }

    public void ensureConfiguredGemsPresent() {
        String lk;
        String k;
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs == null || defs.isEmpty()) {
            return;
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Map.Entry<UUID, String> e : this.gemUuidToKey.entrySet()) {
            k = e.getValue();
            if (k == null) continue;
            lk = k.toLowerCase();
            counts.put(lk, counts.getOrDefault(lk, 0) + 1);
        }
        for (GemDefinition d : defs) {
            k = d.getGemKey();
            if (k == null) continue;
            lk = k.toLowerCase();
            int have = counts.getOrDefault(lk, 0);
            int need = Math.max(1, d.getCount());
            for (int i = have; i < need; ++i) {
                UUID newId = UUID.randomUUID();
                this.gemUuidToKey.put(newId, k);
                this.randomPlaceGem(newId);
            }
        }
    }

    @EventHandler
    public void onGemPlaced(BlockPlaceEvent event) {
        Player placer;
        ItemStack inHand = event.getItemInHand();
        if (!this.isRuleGem(inHand)) {
            return;
        }
        UUID gemId = this.getGemUUID(inHand);
        if (gemId == null) {
            gemId = UUID.randomUUID();
        }
        Block block = event.getBlockPlaced();
        Location placedLoc = block.getLocation();
        this.gemUuidToHolder.remove(gemId);
        this.locationToGemUuid.put(placedLoc, gemId);
        if (this.historyLogger != null) {
            String gemKey = this.gemUuidToKey.get(gemId);
            String locationStr = String.format("(%d, %d, %d) %s", placedLoc.getBlockX(), placedLoc.getBlockY(), placedLoc.getBlockZ(), placedLoc.getWorld() != null ? placedLoc.getWorld().getName() : "unknown");
            this.historyLogger.logGemPlace(event.getPlayer(), gemKey != null ? gemKey : gemId.toString(), locationStr);
        }
        if ((placer = event.getPlayer()) != null) {
            UUID placedGemId = gemId;
            SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)placer, () -> {
                this.removeGemItemFromInventory(placer, placedGemId);
                try {
                    placer.updateInventory();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 1L, -1L);
        }
    }

    @EventHandler
    public void onGemBroken(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (this.locationToGemUuid.containsKey(block.getLocation())) {
            event.setDropItems(false);
            try {
                event.setExpToDrop(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            UUID gemId = this.locationToGemUuid.get(block.getLocation());
            Player player = event.getPlayer();
            PlayerInventory inv = player.getInventory();
            if (inv.firstEmpty() == -1) {
                this.languageManager.logMessage("inventory_full");
                event.setCancelled(true);
                return;
            }
            ItemStack gemItem = this.createRuleGem(gemId);
            inv.addItem(new ItemStack[]{gemItem});
            this.gemUuidToHolder.put(gemId, player);
            this.unplaceRuleGem(block.getLocation(), gemId);
            this.handleInventoryOwnershipOnPickup(player, gemId);
            GemDefinition def = this.findGemDefinition(this.gemUuidToKey.get(gemId));
            if (def != null && def.getOnPickup() != null) {
                this.effectUtils.executeCommands(def.getOnPickup(), Collections.singletonMap("%player%", player.getName()));
                this.effectUtils.playLocalSound(player.getLocation(), def.getOnPickup(), 1.0f, 1.0f);
                this.effectUtils.playParticle(player.getLocation(), def.getOnPickup());
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!this.isRuleGem(item)) continue;
            UUID gemId = this.getGemUUID(item);
            inv.remove(item);
            Location loc = player.getLocation();
            this.gemUuidToHolder.remove(gemId);
            this.placeRuleGem(loc, gemId);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        UUID gemId = this.getGemUUID(item);
        if (this.isRuleGem(item)) {
            event.getItemDrop().remove();
            this.gemUuidToHolder.remove(gemId);
            Location loc = event.getItemDrop().getLocation();
            this.triggerScatterEffects(gemId, loc, event.getPlayer().getName());
            this.placeRuleGem(loc, gemId);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!this.isRuleGem(item)) continue;
            UUID gemId = this.getGemUUID(item);
            inv.remove(item);
            this.gemUuidToHolder.remove(gemId);
            Location deathLocation = player.getLocation();
            if (deathLocation == null) continue;
            this.triggerScatterEffects(gemId, deathLocation, player.getName());
            this.placeRuleGem(deathLocation, gemId);
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            UUID gemId;
            if (!this.isRuleGem(item) || this.gemUuidToHolder.containsKey(gemId = this.getGemUUID(item))) continue;
            inv.remove(item);
            this.gemUuidToHolder.remove(gemId);
        }
        this.applyPendingRevokesIfAny(player);
    }

    public void scatterGems() {
        this.languageManager.logMessage("scatter_start");
        int scatteredCount = 0;
        HashSet<Location> locCopy = new HashSet<Location>(this.locationToGemUuid.keySet());
        for (Location loc : locCopy) {
            this.unplaceRuleGem(loc, this.locationToGemUuid.get(loc));
        }
        this.locationToGemUuid.clear();
        for (Object player : Bukkit.getOnlinePlayers()) {
            PlayerInventory inv = player.getInventory();
            for (ItemStack itemStack : inv.getContents()) {
                if (!this.isRuleGem(itemStack)) continue;
                inv.remove(itemStack);
            }
        }
        this.gemUuidToHolder.clear();
        this.gemUuidToKey.clear();
        this.languageManager.logMessage("gems_recollected");
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs != null && !defs.isEmpty()) {
            scatteredCount = 0;
            for (GemDefinition def : defs) {
                int cnt = Math.max(1, def.getCount());
                for (int i = 0; i < cnt; ++i) {
                    UUID gemId = UUID.randomUUID();
                    this.gemUuidToKey.put(gemId, def.getGemKey());
                    this.randomPlaceGem(gemId);
                    ++scatteredCount;
                }
                if (def.getOnScatter() == null) continue;
                UUID sample = null;
                for (Map.Entry entry : this.gemUuidToKey.entrySet()) {
                    if (!def.getGemKey().equalsIgnoreCase((String)entry.getValue())) continue;
                    sample = (UUID)entry.getKey();
                    break;
                }
                if (sample == null) continue;
                Location placedLoc = this.findLocationByGemId(sample);
                this.triggerScatterEffects(sample, placedLoc, null, false);
            }
        } else {
            int toPlace;
            scatteredCount = toPlace = Math.max(0, this.configManager.getRequiredCount());
            for (int i = 0; i < toPlace; ++i) {
                UUID gemId = UUID.randomUUID();
                this.randomPlaceGem(gemId);
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(scatteredCount));
        this.languageManager.logMessage("gems_scattered", placeholders);
        ExecuteConfig gemScatterExecute = this.configManager.getGemScatterExecute();
        this.effectUtils.executeCommands(gemScatterExecute, placeholders);
        this.effectUtils.playGlobalSound(gemScatterExecute, 1.0f, 1.0f);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.languageManager.showTitle(p, "gems_scattered", placeholders);
        }
        this.saveGems();
    }

    public void gemStatus(CommandSender sender) {
        HashMap<String, String> summary = new HashMap<String, String>();
        summary.put("count", String.valueOf(this.configManager.getRequiredCount()));
        summary.put("placed_count", String.valueOf(this.locationToGemUuid.size()));
        summary.put("held_count", String.valueOf(this.gemUuidToHolder.size()));
        this.languageManager.sendMessage(sender, "gem_status.total_expected", summary);
        this.languageManager.sendMessage(sender, "gem_status.total_counts", summary);
        ArrayList<Map.Entry<UUID, String>> entries = new ArrayList<Map.Entry<UUID, String>>(this.gemUuidToKey.entrySet());
        entries.sort((a, b) -> {
            String kb;
            String ka = a.getValue() != null ? ((String)a.getValue()).toLowerCase() : "";
            int c = ka.compareTo(kb = b.getValue() != null ? ((String)b.getValue()).toLowerCase() : "");
            if (c != 0) {
                return c;
            }
            return ((UUID)a.getKey()).toString().compareTo(((UUID)b.getKey()).toString());
        });
        boolean isPlayerSender = sender instanceof Player;
        for (Map.Entry entry : entries) {
            String statusText;
            UUID gemId = (UUID)entry.getKey();
            String gemKey = (String)entry.getValue();
            GemDefinition def = gemKey != null ? this.findGemDefinition(gemKey) : null;
            String displayName = def != null && def.getDisplayName() != null ? def.getDisplayName() : "Gem";
            Player holder = this.gemUuidToHolder.get(gemId);
            Location loc = this.findLocationByGemId(gemId);
            if (holder != null && holder.isOnline()) {
                HashMap<String, String> ph = new HashMap<String, String>();
                ph.put("player", holder.getName());
                statusText = this.languageManager.formatMessage("messages.gem_status.status_held", ph);
            } else if (loc != null) {
                String worldName = loc.getWorld() != null ? loc.getWorld().getName() : "world";
                HashMap<String, String> ph = new HashMap<String, String>();
                ph.put("x", String.valueOf(loc.getBlockX()));
                ph.put("y", String.valueOf(loc.getBlockY()));
                ph.put("z", String.valueOf(loc.getBlockZ()));
                ph.put("world", worldName);
                statusText = this.languageManager.formatMessage("messages.gem_status.status_placed", ph);
            } else {
                statusText = this.languageManager.formatMessage("messages.gem_status.status_unknown", Collections.emptyMap());
            }
            HashMap<String, String> linePh = new HashMap<String, String>();
            linePh.put("gem_key", gemKey != null ? gemKey : "unknown");
            linePh.put("gem_name", displayName);
            linePh.put("status", statusText);
            String plain = this.languageManager.formatMessage("messages.gem_status.gem_line", linePh);
            if (isPlayerSender) {
                Player ps = (Player)sender;
                TextComponent comp = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)plain));
                StringBuilder loreBuilder = new StringBuilder();
                if (def != null && def.getLore() != null && !def.getLore().isEmpty()) {
                    for (String line : def.getLore()) {
                        String l = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
                        loreBuilder.append(l).append("\n");
                    }
                } else {
                    loreBuilder.append(ChatColor.GRAY).append("\u6ca1\u6709\u66f4\u591a\u4fe1\u606f");
                }
                Text text = new Text(loreBuilder.toString().trim());
                comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{text}));
                String clickCmd = "/rulegems tp " + gemId.toString();
                comp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, clickCmd));
                ps.spigot().sendMessage((BaseComponent)comp);
                continue;
            }
            sender.sendMessage(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)plain)));
        }
    }

    public boolean isRuleGem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
        return pdc.has(this.ruleGemKey, PersistentDataType.BYTE);
    }

    private boolean isRuleGem(Block block) {
        Location loc = block.getLocation();
        return this.locationToGemUuid.containsKey(loc);
    }

    public ItemStack createRuleGem(UUID gemId) {
        ItemMeta meta;
        GemDefinition def;
        String gemKey = this.gemUuidToKey.getOrDefault(gemId, null);
        ItemStack ruleGem = new ItemStack(Material.RED_STAINED_GLASS, 1);
        boolean enchantedGlint = false;
        if (gemKey != null && (def = this.findGemDefinition(gemKey)) != null) {
            ruleGem = new ItemStack(def.getMaterial(), 1);
            enchantedGlint = def.isEnchanted();
        }
        if ((meta = ruleGem.getItemMeta()) == null) {
            return ruleGem;
        }
        String defaultDisplayName = null;
        if (this.languageManager != null) {
            defaultDisplayName = this.languageManager.getMessage("messages.gem.default_display_name");
        }
        if (defaultDisplayName == null || defaultDisplayName.startsWith("Missing message")) {
            defaultDisplayName = "&cRule Gem";
        }
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)defaultDisplayName);
        ArrayList<String> lore = new ArrayList<String>();
        if (gemKey != null) {
            GemDefinition def2 = this.findGemDefinition(gemKey);
            if (def2 != null && def2.getDisplayName() != null) {
                displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)def2.getDisplayName());
            }
            if (def2 != null && def2.getLore() != null && !def2.getLore().isEmpty()) {
                for (String line : def2.getLore()) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
            }
        }
        meta.setLore(lore);
        meta.setDisplayName(displayName);
        if (enchantedGlint) {
            try {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
                meta.addEnchant(Enchantment.LUCK, 1, true);
            }
            catch (Throwable def2) {
                // empty catch block
            }
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(this.ruleGemKey, PersistentDataType.BYTE, (Object)1);
        pdc.set(this.uniqueIdKey, PersistentDataType.STRING, (Object)gemId.toString());
        if (gemKey != null) {
            pdc.set(this.gemKeyKey, PersistentDataType.STRING, (Object)gemKey);
        }
        ruleGem.setItemMeta(meta);
        return ruleGem;
    }

    private GemDefinition findGemDefinition(String key) {
        for (GemDefinition d : this.configManager.getGemDefinitions()) {
            if (!d.getGemKey().equalsIgnoreCase(key)) continue;
            return d;
        }
        return null;
    }

    private void ensureGemKeyAssigned(UUID gemId) {
        if (this.gemUuidToKey.containsKey(gemId)) {
            return;
        }
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs == null || defs.isEmpty()) {
            return;
        }
        String key = defs.get(new Random().nextInt(defs.size())).getGemKey();
        this.gemUuidToKey.put(gemId, key);
    }

    private void grantPermissions(Player player, List<String> perms) {
        PermissionAttachment attachment = this.redeemAttachments.computeIfAbsent(player.getUniqueId(), p -> player.addAttachment((Plugin)this.plugin));
        for (String node : perms) {
            if (node == null || node.trim().isEmpty()) continue;
            attachment.setPermission(node, true);
        }
        player.recalculatePermissions();
    }

    private void grantRedeemPermissions(Player player, List<String> perms) {
        if (perms == null || perms.isEmpty()) {
            return;
        }
        this.grantPermissions(player, perms);
        if (this.plugin.getVaultPerms() != null) {
            for (String node : perms) {
                if (node == null || node.trim().isEmpty()) continue;
                try {
                    this.plugin.getVaultPerms().playerAdd(player, node);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void incrementOwnerKeyCount(UUID owner, String key, GemDefinition def) {
        Player p;
        if (owner == null || key == null) {
            return;
        }
        Map map = this.ownerKeyCount.computeIfAbsent(owner, k -> new HashMap());
        int before = map.getOrDefault(key, 0);
        int after = before + 1;
        map.put(key, after);
        if (before == 0 && def != null && (p = Bukkit.getPlayer((UUID)owner)) != null && p.isOnline()) {
            if (def.getPermissions() != null && !def.getPermissions().isEmpty()) {
                this.grantRedeemPermissions(p, def.getPermissions());
            }
            if (def.getVaultGroup() != null && !def.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
                try {
                    this.plugin.getVaultPerms().playerAddGroup(p, def.getVaultGroup());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                p.recalculatePermissions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void decrementOwnerKeyCount(UUID owner, String key, GemDefinition def) {
        if (owner == null || key == null) {
            return;
        }
        Map map = this.ownerKeyCount.computeIfAbsent(owner, k -> new HashMap());
        int before = map.getOrDefault(key, 0);
        int after = Math.max(0, before - 1);
        map.put(key, after);
        if (after == 0 && def != null) {
            Player p = Bukkit.getPlayer((UUID)owner);
            if (p != null && p.isOnline()) {
                if (def.getPermissions() != null) {
                    this.revokeNodes(p, def.getPermissions());
                }
                if (def.getVaultGroup() != null && !def.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
                    try {
                        this.plugin.getVaultPerms().playerRemoveGroup(p, def.getVaultGroup());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    p.recalculatePermissions();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.historyLogger != null) {
                    this.historyLogger.logPermissionRevoke(owner.toString(), p.getName(), key, def.getDisplayName(), def.getPermissions(), def.getVaultGroup(), "\u5f52\u5c5e\u5207\u6362\uff1a\u5931\u53bb\u6700\u540e\u4e00\u4ef6\u8be5\u7c7b\u578b\u5b9d\u77f3");
                }
            } else {
                this.queueOfflineRevokes(owner, def.getPermissions() != null ? def.getPermissions() : Collections.emptyList(), def.getVaultGroup() != null && !def.getVaultGroup().isEmpty() ? Collections.singleton(def.getVaultGroup()) : Collections.emptySet());
                if (this.historyLogger != null) {
                    this.historyLogger.logPermissionRevoke(owner.toString(), "\u672a\u77e5(\u79bb\u7ebf)", key, def.getDisplayName(), def.getPermissions(), def.getVaultGroup(), "\u5f52\u5c5e\u5207\u6362\uff1a\u5931\u53bb\u6700\u540e\u4e00\u4ef6\u8be5\u7c7b\u578b\u5b9d\u77f3\uff08\u79bb\u7ebf\u64a4\u9500\uff09");
                }
            }
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setHistoryLogger(HistoryLogger historyLogger) {
        this.historyLogger = historyLogger;
    }

    public void recalculateGrants(Player player) {
        if (!this.configManager.isInventoryGrantsEnabled()) {
            return;
        }
        ArrayList<String> presentKeysOrdered = new ArrayList<String>();
        PlayerInventory inv = player.getInventory();
        for (ItemStack itemStack : inv.getContents()) {
            Object k;
            UUID id;
            String key;
            if (!this.isRuleGem(itemStack) || (key = this.gemUuidToKey.get(id = this.getGemUUID(itemStack))) == null || presentKeysOrdered.contains(k = key.toLowerCase(Locale.ROOT))) continue;
            presentKeysOrdered.add((String)k);
        }
        Set previouslyActive = this.playerActiveHeldKeys.getOrDefault(player.getUniqueId(), Collections.emptySet());
        LinkedHashSet<String> selectedKeys = new LinkedHashSet<String>();
        for (String string : presentKeysOrdered) {
            if (!previouslyActive.contains(string)) continue;
            selectedKeys.add(string);
        }
        for (String string : presentKeysOrdered) {
            if (selectedKeys.contains(string) || this.conflictsWithSelected(string, selectedKeys)) continue;
            selectedKeys.add(string);
        }
        this.playerActiveHeldKeys.put(player.getUniqueId(), selectedKeys);
        HashSet<String> shouldHave = new HashSet<String>();
        for (String k : selectedKeys) {
            GemDefinition def = this.findGemDefinition(k);
            if (def == null || def.getPermissions() == null) continue;
            for (String node : def.getPermissions()) {
                if (node == null || node.trim().isEmpty()) continue;
                shouldHave.add(node);
            }
        }
        PermissionAttachment permissionAttachment = this.invAttachments.computeIfAbsent(player.getUniqueId(), p -> player.addAttachment((Plugin)this.plugin));
        HashSet current = new HashSet(permissionAttachment.getPermissions().keySet());
        for (String node : shouldHave) {
            if (current.contains(node)) continue;
            permissionAttachment.setPermission(node, true);
        }
        for (String node : current) {
            if (shouldHave.contains(node)) continue;
            permissionAttachment.unsetPermission(node);
        }
        player.recalculatePermissions();
    }

    private boolean conflictsWithSelected(String candidateKey, Set<String> selectedKeys) {
        GemDefinition c = this.findGemDefinition(candidateKey);
        HashSet<String> cm = new HashSet<String>();
        if (c != null && c.getMutualExclusive() != null) {
            for (String x : c.getMutualExclusive()) {
                if (x == null) continue;
                cm.add(x.toLowerCase(Locale.ROOT));
            }
        }
        for (String s : selectedKeys) {
            if (cm.contains(s)) {
                return true;
            }
            GemDefinition sd = this.findGemDefinition(s);
            if (sd == null || sd.getMutualExclusive() == null) continue;
            for (String x : sd.getMutualExclusive()) {
                if (x == null || !x.equalsIgnoreCase(candidateKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializePlacedGemBlocks() {
        for (Map.Entry<Location, UUID> e : this.locationToGemUuid.entrySet()) {
            Location loc = e.getKey();
            UUID gemId = e.getValue();
            World w = loc.getWorld();
            if (w == null) continue;
            try {
                GemDefinition def;
                String key = this.gemUuidToKey.get(gemId);
                Material mat = Material.RED_STAINED_GLASS;
                if (key != null && (def = this.findGemDefinition(key)) != null && def.getMaterial() != null) {
                    mat = def.getMaterial();
                }
                Material m = mat;
                Location f = loc;
                SchedulerUtil.regionRun((Plugin)this.plugin, f, () -> {
                    try {
                        if (!f.getChunk().isLoaded()) {
                            f.getChunk().load();
                        }
                        f.getBlock().setType(m);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 0L, -1L);
            }
            catch (Exception exception) {}
        }
    }

    private void revokeNodes(Player player, Collection<String> nodes) {
        PermissionAttachment r;
        PermissionAttachment i = this.invAttachments.get(player.getUniqueId());
        if (i != null) {
            for (String n : nodes) {
                try {
                    i.unsetPermission(n);
                }
                catch (Exception exception) {}
            }
        }
        if ((r = this.redeemAttachments.get(player.getUniqueId())) != null) {
            for (String n : nodes) {
                try {
                    r.unsetPermission(n);
                }
                catch (Exception exception) {}
            }
        }
        if (this.plugin.getVaultPerms() != null) {
            for (String n : nodes) {
                try {
                    this.plugin.getVaultPerms().playerRemove(player, n);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void applyPendingRevokesIfAny(Player player) {
        Set<String> groups;
        if (player == null) {
            return;
        }
        UUID uid = player.getUniqueId();
        boolean changed = false;
        Set<String> perms = this.pendingPermRevokes.remove(uid);
        if (perms != null && !perms.isEmpty()) {
            this.revokeNodes(player, perms);
            changed = true;
        }
        if ((groups = this.pendingGroupRevokes.remove(uid)) != null && !groups.isEmpty() && this.plugin.getVaultPerms() != null) {
            for (String g : groups) {
                try {
                    this.plugin.getVaultPerms().playerRemoveGroup(player, g);
                }
                catch (Exception exception) {}
            }
            changed = true;
        }
        if (changed) {
            try {
                player.recalculatePermissions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.saveGems();
        }
    }

    public int getTotalGemCount() {
        return this.locationToGemUuid.size() + this.gemUuidToHolder.size();
    }

    public void placeRuleGem(Location loc, UUID gemId) {
        this.placeRuleGemInternal(loc, gemId, false);
    }

    private void placeRuleGemInternal(Location loc, UUID gemId, boolean ignoreLimit) {
        if (loc == null) {
            return;
        }
        if (!ignoreLimit && this.getTotalGemCount() >= this.configManager.getRequiredCount()) {
            this.languageManager.logMessage("gem_limit_reached");
            return;
        }
        Location base = loc.clone();
        SchedulerUtil.regionRun((Plugin)this.plugin, base, () -> {
            GemDefinition def;
            World world = base.getWorld();
            if (world == null) {
                return;
            }
            WorldBorder border = world.getWorldBorder();
            Location target = base.getBlock().getLocation();
            for (int tries = 0; tries < 6 && target.getBlock().getType().isSolid(); ++tries) {
                target.add(0.0, 1.0, 0.0);
            }
            if (!border.isInside(target) || target.getBlockY() < world.getMinHeight() || target.getBlockY() > world.getMaxHeight()) {
                this.randomPlaceGem(gemId);
                return;
            }
            String gemKey = this.gemUuidToKey.getOrDefault(gemId, null);
            Material mat = Material.RED_STAINED_GLASS;
            if (gemKey != null && (def = this.findGemDefinition(gemKey)) != null && def.getMaterial() != null) {
                mat = def.getMaterial();
            }
            target.getBlock().setType(mat);
            this.locationToGemUuid.put(target, gemId);
        }, 0L, -1L);
    }

    public void unplaceRuleGem(Location loc, UUID gemId) {
        if (loc == null) {
            return;
        }
        Location fLoc = loc.getBlock().getLocation();
        SchedulerUtil.regionRun((Plugin)this.plugin, fLoc, () -> {
            fLoc.getBlock().setType(Material.AIR);
            this.locationToGemUuid.remove(fLoc, gemId);
        }, 0L, -1L);
    }

    private Location[] getGemPlaceRange(UUID gemId) {
        String gemKey = this.gemUuidToKey.get(gemId);
        if (gemKey != null) {
            for (GemDefinition def : this.configManager.getGemDefinitions()) {
                if (!def.getGemKey().equals(gemKey)) continue;
                Location c1 = def.getRandomPlaceCorner1();
                Location c2 = def.getRandomPlaceCorner2();
                if (c1 == null || c2 == null) break;
                return new Location[]{c1, c2};
            }
        }
        Location defaultC1 = this.configManager.getRandomPlaceCorner1();
        Location defaultC2 = this.configManager.getRandomPlaceCorner2();
        if (defaultC1 != null && defaultC2 != null) {
            return new Location[]{defaultC1, defaultC2};
        }
        return null;
    }

    private void randomPlaceGem(UUID gemId, Location corner1, Location corner2) {
        this.ensureGemKeyAssigned(gemId);
        this.scheduleRandomAttempt(gemId, corner1, corner2, 12);
    }

    private void randomPlaceGem(UUID gemId) {
        Location[] range = this.getGemPlaceRange(gemId);
        if (range != null) {
            this.randomPlaceGem(gemId, range[0], range[1]);
        } else {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u653e\u7f6e\u5b9d\u77f3 " + String.valueOf(gemId) + "\uff1a\u672a\u914d\u7f6e\u751f\u6210\u8303\u56f4");
        }
    }

    private void scheduleRandomAttempt(UUID gemId, Location corner1, Location corner2, int attemptsLeft) {
        if (corner1 == null || corner2 == null || attemptsLeft <= 0) {
            return;
        }
        if (corner1.getWorld() != corner2.getWorld()) {
            return;
        }
        World world = corner1.getWorld();
        Random rand = new Random();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = rand.nextInt(maxX - minX + 1) + minX;
        int z = rand.nextInt(maxZ - minZ + 1) + minZ;
        Location candidate = new Location(world, (double)x, (double)(world.getMinHeight() + 1), (double)z);
        SchedulerUtil.regionRun((Plugin)this.plugin, candidate, () -> {
            block4: {
                try {
                    int y = world.getHighestBlockYAt(x, z) + 1;
                    Location place = new Location(world, (double)x, (double)y, (double)z);
                    WorldBorder border = world.getWorldBorder();
                    if (!border.isInside(place)) {
                        if (attemptsLeft - 1 > 0) {
                            this.scheduleRandomAttempt(gemId, corner1, corner2, attemptsLeft - 1);
                        }
                        return;
                    }
                    this.placeRuleGem(place, gemId);
                }
                catch (Throwable t) {
                    if (attemptsLeft - 1 <= 0) break block4;
                    this.scheduleRandomAttempt(gemId, corner1, corner2, attemptsLeft - 1);
                }
            }
        }, 0L, -1L);
    }

    public void startParticleEffectTask(Particle particle) {
        SchedulerUtil.globalRun((Plugin)this.plugin, () -> {
            Iterator<Location> iterator = this.locationToGemUuid.keySet().iterator();
            while (iterator.hasNext()) {
                Location loc;
                Location target = loc = iterator.next();
                SchedulerUtil.regionRun((Plugin)this.plugin, target, () -> {
                    World world = target.getWorld();
                    if (world == null) {
                        return;
                    }
                    UUID id = this.locationToGemUuid.get(target);
                    GemDefinition def = id != null ? this.findGemDefinition(this.gemUuidToKey.get(id)) : null;
                    Particle p = def != null && def.getParticle() != null ? def.getParticle() : particle;
                    world.spawnParticle(p, target.getX() + 0.5, target.getY() + 0.5, target.getZ() + 0.5, 1);
                }, 0L, -1L);
            }
        }, 0L, 20L);
    }

    public void checkPlayersNearRuleGems() {
        if (this.locationToGemUuid.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.checkPlayerNearRuleGems(player);
        }
    }

    public void checkPlayerNearRuleGems(Player player) {
        if (player == null || this.locationToGemUuid.isEmpty()) {
            return;
        }
        SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)player, () -> this.doPlayerNearCheck(player), 0L, -1L);
    }

    private void doPlayerNearCheck(Player player) {
        if (player == null) {
            return;
        }
        Location playerLoc = player.getLocation();
        World playerWorld = playerLoc.getWorld();
        if (playerWorld == null) {
            return;
        }
        for (Location blockLoc : this.locationToGemUuid.keySet()) {
            double distance;
            World w = blockLoc.getWorld();
            if (w == null || !w.equals((Object)playerWorld) || !((distance = playerLoc.distance(blockLoc)) < 16.0)) continue;
            float volume = (float)(1.0 - distance / 16.0);
            float pitch = 1.0f;
            player.playSound(playerLoc, Sound.BLOCK_NOTE_BLOCK_PLING, volume, pitch);
        }
    }

    private Location findLocationByGemId(UUID gemId) {
        for (Map.Entry<Location, UUID> e : this.locationToGemUuid.entrySet()) {
            if (!e.getValue().equals(gemId)) continue;
            return e.getKey();
        }
        return null;
    }

    public Location getGemLocation(UUID gemId) {
        return this.findLocationByGemId(gemId);
    }

    public Player getGemHolder(UUID gemId) {
        return this.gemUuidToHolder.get(gemId);
    }

    public boolean revokeAllPlayerPermissions(Player player) {
        PermissionAttachment redAtt;
        if (player == null) {
            return false;
        }
        UUID uid = player.getUniqueId();
        boolean hadAny = false;
        Map<String, Integer> counts = this.ownerKeyCount.get(uid);
        if (counts != null && !counts.isEmpty()) {
            hadAny = true;
            for (Map.Entry<String, Integer> e : new HashMap<String, Integer>(counts).entrySet()) {
                String key = e.getKey();
                GemDefinition def = this.findGemDefinition(key);
                if (def == null) continue;
                if (def.getPermissions() != null) {
                    this.revokeNodes(player, def.getPermissions());
                }
                if (def.getVaultGroup() == null || def.getVaultGroup().isEmpty() || this.plugin.getVaultPerms() == null) continue;
                try {
                    this.plugin.getVaultPerms().playerRemoveGroup(player, def.getVaultGroup());
                }
                catch (Exception exception) {}
            }
            counts.clear();
        }
        if (uid.equals(this.fullSetOwner)) {
            hadAny = true;
            List<String> extraPerms = this.configManager.getRedeemAllPermissions();
            if (extraPerms != null && !extraPerms.isEmpty()) {
                this.revokeNodes(player, extraPerms);
            }
            this.fullSetOwner = null;
        }
        this.playerGemHeldUses.remove(uid);
        this.playerGemRedeemUses.remove(uid);
        this.playerGlobalAllowedUses.remove(uid);
        this.playerUuidToRedeemedKeys.remove(uid);
        this.playerActiveHeldKeys.remove(uid);
        this.gemIdToRedeemer.entrySet().removeIf(entry -> uid.equals(entry.getValue()));
        PermissionAttachment invAtt = this.invAttachments.remove(uid);
        if (invAtt != null) {
            try {
                player.removeAttachment(invAtt);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if ((redAtt = this.redeemAttachments.remove(uid)) != null) {
            try {
                player.removeAttachment(redAtt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            player.recalculatePermissions();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hadAny && this.historyLogger != null) {
            this.historyLogger.logPermissionRevoke(uid.toString(), player.getName(), "ALL", "\u5168\u90e8\u5b9d\u77f3\u6743\u9650", Collections.emptyList(), null, "\u7ba1\u7406\u5458\u5f3a\u5236\u64a4\u9500");
        }
        this.saveGems();
        return hadAny;
    }

    public UUID getGemUUID(ItemStack item) {
        if (!this.isRuleGem(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String uuidStr = (String)pdc.get(this.uniqueIdKey, PersistentDataType.STRING);
        if (uuidStr == null) {
            return null;
        }
        return UUID.fromString(uuidStr);
    }

    public UUID getGemUUID(Block block) {
        if (!this.isRuleGem(block)) {
            return null;
        }
        Location loc = block.getLocation();
        return this.locationToGemUuid.get(loc);
    }

    public boolean redeemGemInHand(Player player) {
        if (player == null) {
            return false;
        }
        if (!this.configManager.isRedeemEnabled()) {
            this.languageManager.sendMessage((CommandSender)player, "command.redeem.disabled");
            return true;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (!this.isRuleGem(inHand)) {
            return false;
        }
        UUID matchedGemId = this.getGemUUID(inHand);
        if (matchedGemId == null) {
            return false;
        }
        String targetKey = this.gemUuidToKey.get(matchedGemId);
        if (targetKey == null || targetKey.isEmpty()) {
            this.ensureGemKeyAssigned(matchedGemId);
            targetKey = this.gemUuidToKey.get(matchedGemId);
            if (targetKey == null || targetKey.isEmpty()) {
                return false;
            }
        }
        this.markGemRedeemed(player, targetKey);
        GemDefinition def = this.findGemDefinition(targetKey);
        this.applyRedeemRewards(player, def);
        this.removeGemItemFromInventory(player, matchedGemId);
        this.gemUuidToHolder.remove(matchedGemId);
        this.randomPlaceGem(matchedGemId);
        String normalizedKey = targetKey.toLowerCase(Locale.ROOT);
        UUID old = this.gemIdToRedeemer.put(matchedGemId, player.getUniqueId());
        String previousOwnerName = null;
        if (old != null && !old.equals(player.getUniqueId())) {
            this.decrementOwnerKeyCount(old, normalizedKey, def);
            Player oldP = Bukkit.getPlayer((UUID)old);
            if (oldP != null && oldP.isOnline()) {
                previousOwnerName = oldP.getName();
            }
        }
        this.incrementOwnerKeyCount(player.getUniqueId(), normalizedKey, def);
        this.reassignRedeemInstanceAllowance(matchedGemId, player.getUniqueId(), def, true);
        if (this.historyLogger != null) {
            this.historyLogger.logGemRedeem(player, targetKey, def != null ? def.getDisplayName() : null, def != null ? def.getPermissions() : null, def != null ? def.getVaultGroup() : null, previousOwnerName);
        }
        if (this.configManager.isBroadcastRedeemTitle()) {
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("player", player.getName());
            ph.put("gem", def != null ? (def.getDisplayName() != null ? def.getDisplayName() : targetKey) : targetKey);
            List<String> title = def != null ? def.getRedeemTitle() : null;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (title != null && !title.isEmpty()) {
                    if (title.size() == 1) {
                        p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)this.languageManager.formatText(title.get(0), Collections.singletonMap("player", player.getName()))), null, 10, 70, 20);
                        continue;
                    }
                    String l1 = this.languageManager.formatText(title.get(0), ph);
                    String l2 = this.languageManager.formatText(title.get(1), ph);
                    p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)l1), ChatColor.translateAlternateColorCodes((char)'&', (String)l2), 10, 70, 20);
                    continue;
                }
                this.languageManager.showTitle(p, "gems_scattered", Collections.singletonMap("count", String.valueOf(1)));
            }
        }
        return true;
    }

    private void removeGemItemFromInventory(Player player, UUID targetId) {
        UUID id;
        if (player == null || targetId == null) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack off = inv.getItemInOffHand();
        if (this.isRuleGem(off) && targetId.equals(id = this.getGemUUID(off))) {
            inv.setItemInOffHand(new ItemStack(Material.AIR));
            return;
        }
        ItemStack[] contents = inv.getContents();
        for (int i = 0; i < contents.length; ++i) {
            UUID id2;
            ItemStack it = contents[i];
            if (!this.isRuleGem(it) || !targetId.equals(id2 = this.getGemUUID(it))) continue;
            inv.setItem(i, new ItemStack(Material.AIR));
            break;
        }
    }

    private void markGemRedeemed(Player player, String gemKey) {
        if (player == null || gemKey == null || gemKey.isEmpty()) {
            return;
        }
        String normalizedKey = gemKey.toLowerCase(Locale.ROOT);
        this.playerUuidToRedeemedKeys.computeIfAbsent(player.getUniqueId(), u -> new HashSet()).add(normalizedKey);
    }

    private void applyRedeemRewards(Player player, GemDefinition definition) {
        if (player == null || definition == null) {
            return;
        }
        ExecuteConfig onRedeem = definition.getOnRedeem();
        if (onRedeem != null) {
            Map<String, String> placeholders = Map.of("%player%", player.getName());
            this.effectUtils.executeCommands(onRedeem, placeholders);
            this.effectUtils.playLocalSound(player.getLocation(), onRedeem, 1.0f, 1.0f);
            this.effectUtils.playParticle(player.getLocation(), onRedeem);
        }
        if (definition.getVaultGroup() != null && !definition.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
            try {
                this.plugin.getVaultPerms().playerAddGroup(player, definition.getVaultGroup());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void grantAllowedCommands(Player player, GemDefinition def) {
        if (player == null || def == null) {
            return;
        }
        List<AllowedCommand> allows = def.getAllowedCommands();
        if (allows == null || allows.isEmpty()) {
            return;
        }
        UUID uid = player.getUniqueId();
        Map global = this.playerGlobalAllowedUses.computeIfAbsent(uid, k -> new HashMap());
        for (AllowedCommand ac : allows) {
            if (ac == null || ac.getLabel() == null) continue;
            global.put(ac.getLabel().toLowerCase(Locale.ROOT), ac.getUses());
        }
        this.saveGems();
    }

    private void revokeAllowedCommands(UUID oldOwner, GemDefinition def) {
        if (oldOwner == null || def == null) {
            return;
        }
        this.saveGems();
    }

    public boolean hasAnyAllowed(UUID uid, String label) {
        Map<UUID, Map<String, Integer>> perRed;
        Integer v;
        if (uid == null || label == null) {
            return false;
        }
        String l = label.toLowerCase(Locale.ROOT);
        Map<String, Integer> glob = this.playerGlobalAllowedUses.get(uid);
        if (glob != null && (v = glob.get(l)) != null && (v > 0 || v < 0)) {
            return true;
        }
        Map<UUID, Map<String, Integer>> perHeld = this.playerGemHeldUses.get(uid);
        if (perHeld != null) {
            for (Map<String, Integer> byLabel : perHeld.values()) {
                Integer v2 = byLabel.get(l);
                if (v2 == null || v2 <= 0 && v2 >= 0) continue;
                return true;
            }
        }
        if ((perRed = this.playerGemRedeemUses.get(uid)) != null) {
            for (Map<String, Integer> byLabel : perRed.values()) {
                Integer v3 = byLabel.get(l);
                if (v3 == null || v3 <= 0 && v3 >= 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryConsumeAllowed(UUID uid, String label) {
        Map<String, Integer> glob;
        Map<UUID, Map<String, Integer>> perRed;
        if (uid == null || label == null) {
            return false;
        }
        String l = label.toLowerCase(Locale.ROOT);
        Map<UUID, Map<String, Integer>> perHeld = this.playerGemHeldUses.get(uid);
        if (perHeld != null && !perHeld.isEmpty()) {
            ArrayList<UUID> ids = new ArrayList<UUID>(perHeld.keySet());
            ids.sort(UUID::compareTo);
            for (UUID uUID : ids) {
                Map<String, Integer> byLabel = perHeld.get(uUID);
                if (byLabel == null) continue;
                Integer v = byLabel.get(l);
                if (v == null) {
                    v = 0;
                }
                if (v < 0) {
                    this.saveGems();
                    return true;
                }
                if (v <= 0) continue;
                byLabel.put(l, v - 1);
                this.saveGems();
                return true;
            }
        }
        if ((perRed = this.playerGemRedeemUses.get(uid)) != null && !perRed.isEmpty()) {
            ArrayList<UUID> ids = new ArrayList<UUID>(perRed.keySet());
            ids.sort(UUID::compareTo);
            for (UUID gid : ids) {
                Map<String, Integer> byLabel = perRed.get(gid);
                if (byLabel == null) continue;
                Integer v = byLabel.get(l);
                if (v == null) {
                    v = 0;
                }
                if (v < 0) {
                    this.saveGems();
                    return true;
                }
                if (v <= 0) continue;
                byLabel.put(l, v - 1);
                this.saveGems();
                return true;
            }
        }
        if ((glob = this.playerGlobalAllowedUses.get(uid)) != null) {
            void var7_12;
            Integer n = glob.get(l);
            if (n == null) {
                Integer n2 = 0;
            }
            if (var7_12.intValue() < 0) {
                this.saveGems();
                return true;
            }
            if (var7_12.intValue() > 0) {
                glob.put(l, var7_12.intValue() - 1);
                this.saveGems();
                return true;
            }
        }
        return false;
    }

    private void handleInventoryOwnershipOnPickup(Player player, UUID gemId) {
        if (player == null || gemId == null) {
            return;
        }
        if (!this.configManager.isInventoryGrantsEnabled()) {
            return;
        }
        String gemKey = this.gemUuidToKey.get(gemId);
        if (gemKey == null) {
            return;
        }
        GemDefinition def = this.findGemDefinition(gemKey);
        if (def == null) {
            return;
        }
        this.reassignHeldInstanceAllowance(gemId, player.getUniqueId(), def);
        UUID old = this.gemIdToRedeemer.put(gemId, player.getUniqueId());
        String key = gemKey.toLowerCase(Locale.ROOT);
        if (old != null && !old.equals(player.getUniqueId())) {
            this.decrementOwnerKeyCount(old, key, def);
        }
        this.incrementOwnerKeyCount(player.getUniqueId(), key, def);
    }

    private void reassignHeldInstanceAllowance(UUID gemId, UUID newOwner, GemDefinition def) {
        if (gemId == null || newOwner == null || def == null) {
            return;
        }
        UUID oldOwner = null;
        for (Map.Entry<UUID, Map<UUID, Map<String, Integer>>> e : this.playerGemHeldUses.entrySet()) {
            if (e.getValue() == null || !e.getValue().containsKey(gemId)) continue;
            oldOwner = e.getKey();
            break;
        }
        if (newOwner.equals(oldOwner)) {
            return;
        }
        Map<String, Integer> payload = null;
        if (oldOwner != null) {
            Map<UUID, Map<String, Integer>> map = this.playerGemHeldUses.get(oldOwner);
            if (map != null) {
                payload = map.remove(gemId);
            }
            if (map != null && map.isEmpty()) {
                this.playerGemHeldUses.remove(oldOwner);
            }
        }
        Map dest = this.playerGemHeldUses.computeIfAbsent(newOwner, k -> new HashMap());
        if (payload == null) {
            if (!dest.containsKey(gemId)) {
                dest.put(gemId, this.buildAllowedMap(def));
            }
        } else {
            dest.put(gemId, payload);
        }
        this.saveGems();
    }

    private void reassignRedeemInstanceAllowance(UUID gemId, UUID newOwner, GemDefinition def, boolean resetEvenIfSameOwner) {
        if (gemId == null || newOwner == null || def == null) {
            return;
        }
        UUID oldOwner = null;
        for (Map.Entry<UUID, Map<UUID, Map<String, Integer>>> e : this.playerGemRedeemUses.entrySet()) {
            if (e.getValue() == null || !e.getValue().containsKey(gemId)) continue;
            oldOwner = e.getKey();
            break;
        }
        if (newOwner.equals(oldOwner)) {
            if (resetEvenIfSameOwner) {
                this.playerGemRedeemUses.computeIfAbsent(newOwner, k -> new HashMap()).put(gemId, this.buildAllowedMap(def));
                this.saveGems();
            }
            return;
        }
        Map<String, Integer> payload = null;
        if (oldOwner != null) {
            Map<UUID, Map<String, Integer>> map = this.playerGemRedeemUses.get(oldOwner);
            if (map != null) {
                payload = map.remove(gemId);
            }
            if (map != null && map.isEmpty()) {
                this.playerGemRedeemUses.remove(oldOwner);
            }
        }
        Map dest = this.playerGemRedeemUses.computeIfAbsent(newOwner, k -> new HashMap());
        if (payload == null || resetEvenIfSameOwner) {
            dest.put(gemId, this.buildAllowedMap(def));
        } else {
            dest.put(gemId, payload);
        }
        this.saveGems();
    }

    private Map<String, Integer> buildAllowedMap(GemDefinition def) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<AllowedCommand> allows = def.getAllowedCommands();
        if (allows != null) {
            for (AllowedCommand ac : allows) {
                if (ac == null || ac.getLabel() == null) continue;
                map.put(ac.getLabel().toLowerCase(Locale.ROOT), ac.getUses());
            }
        }
        return map;
    }

    public void refundAllowed(UUID uid, String label) {
        Map<UUID, Map<String, Integer>> perRed;
        if (uid == null || label == null) {
            return;
        }
        String l = label.toLowerCase(Locale.ROOT);
        Map<UUID, Map<String, Integer>> perHeld = this.playerGemHeldUses.get(uid);
        if (perHeld != null) {
            for (Map<String, Integer> byLabel : perHeld.values()) {
                if (!byLabel.containsKey(l)) continue;
                int n = byLabel.getOrDefault(l, 0);
                byLabel.put(l, n + 1);
                this.saveGems();
                return;
            }
        }
        if ((perRed = this.playerGemRedeemUses.get(uid)) != null) {
            for (Map map : perRed.values()) {
                if (!map.containsKey(l)) continue;
                int v = map.getOrDefault(l, 0);
                map.put(l, v + 1);
                this.saveGems();
                return;
            }
        }
        Map glob = this.playerGlobalAllowedUses.computeIfAbsent(uid, k -> new HashMap());
        int n = glob.getOrDefault(l, 0);
        glob.put(l, n + 1);
        this.saveGems();
    }

    public AllowedCommand getAllowedCommand(UUID uid, String label) {
        if (uid == null || label == null) {
            return null;
        }
        String l = label.toLowerCase(Locale.ROOT);
        for (GemDefinition def : this.configManager.getGemDefinitions()) {
            for (AllowedCommand cmd : def.getAllowedCommands()) {
                if (!cmd.getLabel().equals(l)) continue;
                return cmd;
            }
        }
        for (AllowedCommand cmd : this.configManager.getRedeemAllAllowedCommands()) {
            if (!cmd.getLabel().equals(l)) continue;
            return cmd;
        }
        return null;
    }

    public int getRemainingAllowed(UUID uid, String label) {
        Integer n;
        Map<String, Integer> glob;
        Map<UUID, Map<String, Integer>> perRed;
        if (uid == null || label == null) {
            return 0;
        }
        String l = label.toLowerCase(Locale.ROOT);
        int sum = 0;
        Map<UUID, Map<String, Integer>> perHeld = this.playerGemHeldUses.get(uid);
        if (perHeld != null) {
            for (Map<String, Integer> byLabel : perHeld.values()) {
                Integer n2 = byLabel.get(l);
                if (n2 == null) continue;
                if (n2 < 0) {
                    return -1;
                }
                sum += n2.intValue();
            }
        }
        if ((perRed = this.playerGemRedeemUses.get(uid)) != null) {
            for (Map map : perRed.values()) {
                Integer v2 = (Integer)map.get(l);
                if (v2 == null) continue;
                if (v2 < 0) {
                    return -1;
                }
                sum += v2.intValue();
            }
        }
        if ((glob = this.playerGlobalAllowedUses.get(uid)) != null && (n = glob.get(l)) != null) {
            if (n < 0) {
                return -1;
            }
            sum += n.intValue();
        }
        return sum;
    }

    private void queueOfflineRevokes(UUID user, Collection<String> perms, Collection<String> groups) {
        Set set;
        if (user == null) {
            return;
        }
        if (perms != null && !perms.isEmpty()) {
            set = this.pendingPermRevokes.computeIfAbsent(user, k -> new HashSet());
            for (String p : perms) {
                if (p == null || p.trim().isEmpty()) continue;
                set.add(p);
            }
        }
        if (groups != null && !groups.isEmpty()) {
            set = this.pendingGroupRevokes.computeIfAbsent(user, k -> new HashSet());
            for (String g : groups) {
                if (g == null || g.trim().isEmpty()) continue;
                set.add(g);
            }
        }
        this.saveGems();
    }

    private void triggerScatterEffects(UUID gemId, Location location, String playerName) {
        this.triggerScatterEffects(gemId, location, playerName, true);
    }

    private void triggerScatterEffects(UUID gemId, Location location, String playerName, boolean allowFallback) {
        Map<String, String> placeholders;
        if (location == null) {
            return;
        }
        GemDefinition definition = this.findGemDefinition(this.gemUuidToKey.get(gemId));
        Map<String, String> map = placeholders = playerName == null ? Collections.emptyMap() : Collections.singletonMap("%player%", playerName);
        if (definition != null && definition.getOnScatter() != null) {
            this.effectUtils.executeCommands(definition.getOnScatter(), placeholders);
            this.effectUtils.playLocalSound(location, definition.getOnScatter(), 1.0f, 1.0f);
            this.effectUtils.playParticle(location, definition.getOnScatter());
            return;
        }
        if (allowFallback) {
            ExecuteConfig fallback = this.configManager.getGemScatterExecute();
            this.effectUtils.playLocalSound(location, fallback, 1.0f, 1.0f);
            this.effectUtils.playParticle(location, fallback);
        }
    }

    public boolean redeemAll(Player player) {
        List<AllowedCommand> extraAllows;
        List<String> extraPerms;
        boolean broadcast;
        if (!this.configManager.isFullSetGrantsAllEnabled()) {
            this.languageManager.sendMessage((CommandSender)player, "command.redeemall.disabled");
            return true;
        }
        List<GemDefinition> defs = this.configManager.getGemDefinitions();
        if (defs == null || defs.isEmpty()) {
            return false;
        }
        HashMap<String, UUID> keyToGemId = new HashMap<String, UUID>();
        for (ItemStack item : player.getInventory().getContents()) {
            UUID id;
            String key;
            if (!this.isRuleGem(item) || (key = this.gemUuidToKey.get(id = this.getGemUUID(item))) == null || keyToGemId.containsKey(key.toLowerCase())) continue;
            keyToGemId.put(key.toLowerCase(), id);
        }
        for (GemDefinition d : defs) {
            if (keyToGemId.containsKey(d.getGemKey().toLowerCase())) continue;
            return false;
        }
        UUID previousFull = this.fullSetOwner;
        this.fullSetOwner = player.getUniqueId();
        for (GemDefinition d : defs) {
            String normalizedKey = d.getGemKey().toLowerCase(Locale.ROOT);
            this.markGemRedeemed(player, d.getGemKey());
            UUID gid = (UUID)keyToGemId.get(normalizedKey);
            if (gid != null) {
                UUID old = this.gemIdToRedeemer.put(gid, player.getUniqueId());
                if (old != null && !old.equals(player.getUniqueId())) {
                    this.decrementOwnerKeyCount(old, normalizedKey, d);
                }
                this.incrementOwnerKeyCount(player.getUniqueId(), normalizedKey, d);
                this.applyRedeemRewards(player, d);
                this.reassignRedeemInstanceAllowance(gid, player.getUniqueId(), d, true);
            }
            if (gid == null) continue;
            this.removeGemItemFromInventory(player, gid);
            this.gemUuidToHolder.remove(gid);
            this.randomPlaceGem(gid);
        }
        String previousFullOwnerName = null;
        if (previousFull != null && !previousFull.equals(this.fullSetOwner)) {
            Player prev = Bukkit.getPlayer((UUID)previousFull);
            if (prev != null && prev.isOnline()) {
                previousFullOwnerName = prev.getName();
                for (GemDefinition d : defs) {
                    if (d.getPermissions() != null) {
                        this.revokeNodes(prev, d.getPermissions());
                    }
                    if (d.getVaultGroup() != null && !d.getVaultGroup().isEmpty() && this.plugin.getVaultPerms() != null) {
                        try {
                            this.plugin.getVaultPerms().playerRemoveGroup(prev, d.getVaultGroup());
                        }
                        catch (Exception old) {
                            // empty catch block
                        }
                    }
                    this.revokeAllowedCommands(previousFull, d);
                }
                prev.recalculatePermissions();
            } else {
                HashSet allPerms = new HashSet();
                HashSet<String> allGroups = new HashSet<String>();
                for (GemDefinition d : defs) {
                    if (d.getPermissions() != null) {
                        allPerms.addAll(d.getPermissions());
                    }
                    if (d.getVaultGroup() == null || d.getVaultGroup().isEmpty()) continue;
                    allGroups.add(d.getVaultGroup());
                }
                this.queueOfflineRevokes(previousFull, allPerms, allGroups);
                for (GemDefinition d : defs) {
                    this.revokeAllowedCommands(previousFull, d);
                }
            }
        }
        if (this.historyLogger != null) {
            ArrayList<String> allPermissions = new ArrayList<String>();
            for (GemDefinition d : defs) {
                if (d.getPermissions() == null) continue;
                allPermissions.addAll(d.getPermissions());
            }
            this.historyLogger.logFullSetRedeem(player, defs.size(), allPermissions, previousFullOwnerName);
        }
        boolean bl = broadcast = this.configManager.getRedeemAllBroadcastOverride() != null ? this.configManager.getRedeemAllBroadcastOverride().booleanValue() : this.configManager.isBroadcastRedeemTitle();
        if (broadcast) {
            List<String> title = this.configManager.getRedeemAllTitle();
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("player", player.getName());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (title != null && !title.isEmpty()) {
                    if (title.size() == 1) {
                        p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)this.languageManager.formatText(title.get(0), ph)), null, 10, 70, 20);
                        continue;
                    }
                    String l1 = this.languageManager.formatText(title.get(0), ph);
                    String l2 = this.languageManager.formatText(title.get(1), ph);
                    p.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)l1), ChatColor.translateAlternateColorCodes((char)'&', (String)l2), 10, 70, 20);
                    continue;
                }
                this.languageManager.showTitle(p, "gems_recollected", ph);
            }
        }
        if ((extraPerms = this.configManager.getRedeemAllPermissions()) != null && !extraPerms.isEmpty()) {
            this.grantRedeemPermissions(player, extraPerms);
        }
        if ((extraAllows = this.configManager.getRedeemAllAllowedCommands()) != null && !extraAllows.isEmpty()) {
            GemDefinition pseudo = new GemDefinition("ALL", Material.BEDROCK, "ALL", Particle.FLAME, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, null, null, null, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList(), false, extraAllows, Collections.emptyList(), 1, null, null);
            this.grantAllowedCommands(player, pseudo);
        }
        try {
            Sound s = Sound.valueOf((String)this.configManager.getRedeemAllSound());
            this.effectUtils.playGlobalSound(new ExecuteConfig(Collections.emptyList(), s.name(), null), 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Set<String> getAvailableCommandLabels(UUID uid) {
        HashSet<String> labels = new HashSet<String>();
        if (uid == null) {
            return labels;
        }
        this.collectActiveLabelsFromNestedMap(labels, this.playerGemHeldUses.get(uid));
        this.collectActiveLabelsFromNestedMap(labels, this.playerGemRedeemUses.get(uid));
        this.collectActiveLabelsFromFlatMap(labels, this.playerGlobalAllowedUses.get(uid));
        return labels;
    }

    private void collectActiveLabelsFromNestedMap(Set<String> labels, Map<UUID, Map<String, Integer>> nested) {
        if (nested == null || nested.isEmpty()) {
            return;
        }
        for (Map<String, Integer> inner : nested.values()) {
            this.collectActiveLabelsFromFlatMap(labels, inner);
        }
    }

    private void collectActiveLabelsFromFlatMap(Set<String> labels, Map<String, Integer> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String base;
            String key = entry.getKey();
            Integer remaining = entry.getValue();
            if (key == null || key.isBlank() || remaining == null || remaining == 0 || (base = key.split(" ")[0].toLowerCase(ROOT_LOCALE)).isEmpty()) continue;
            labels.add(base);
        }
    }

    public Map<UUID, Set<String>> getCurrentRulers() {
        HashMap<UUID, Set<String>> map = new HashMap<UUID, Set<String>>();
        if (this.fullSetOwner != null) {
            map.put(this.fullSetOwner, new HashSet<String>(Collections.singleton("ALL")));
        }
        for (Map.Entry<UUID, UUID> e : this.gemIdToRedeemer.entrySet()) {
            String k;
            UUID u = e.getValue();
            if (u == null || (k = this.gemUuidToKey.get(e.getKey())) == null) continue;
            map.computeIfAbsent(u, kk -> new HashSet()).add(k.toLowerCase(Locale.ROOT));
        }
        return map;
    }

    public UUID getFullSetOwner() {
        return this.fullSetOwner;
    }

    private String resolveGemKeyByNameOrKey(String input) {
        if (input == null) {
            return null;
        }
        String lc = input.toLowerCase();
        for (GemDefinition d : this.configManager.getGemDefinitions()) {
            if (d.getGemKey().equalsIgnoreCase(input)) {
                return d.getGemKey();
            }
            String name = d.getDisplayName();
            if (name == null || !ChatColor.stripColor((String)name).replace("\u00a7", "&").replace("&", "").toLowerCase().contains(lc)) continue;
            return d.getGemKey();
        }
        return null;
    }

    public Material getGemMaterial(UUID gemId) {
        String key = this.gemUuidToKey.get(gemId);
        if (key != null) {
            GemDefinition def = null;
            for (GemDefinition d : this.configManager.getGemDefinitions()) {
                if (!d.getGemKey().equalsIgnoreCase(key)) continue;
                def = d;
                break;
            }
            if (def != null && def.getMaterial() != null) {
                return def.getMaterial();
            }
        }
        return Material.RED_STAINED_GLASS;
    }

    public boolean isSupportRequired(Material mat) {
        if (mat == null) {
            return false;
        }
        String name = mat.name();
        if ("SCULK_CATALYST".equals(name)) {
            return true;
        }
        try {
            if (!mat.isSolid()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean hasBlockSupport(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return false;
        }
        Location below = loc.clone().add(0.0, -1.0, 0.0);
        Block b = below.getBlock();
        if (b == null) {
            return false;
        }
        Material m = b.getType();
        try {
            return m.isSolid();
        }
        catch (Throwable t) {
            return true;
        }
    }

    public UUID resolveGemIdentifier(String input) {
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        try {
            UUID id = UUID.fromString(input.trim());
            if (this.gemUuidToKey.containsKey(id)) {
                return id;
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        String key = this.resolveGemKeyByNameOrKey(input.trim());
        if (key == null) {
            return null;
        }
        for (Map.Entry<UUID, String> e : this.gemUuidToKey.entrySet()) {
            if (e.getValue() == null || !e.getValue().equalsIgnoreCase(key)) continue;
            return e.getKey();
        }
        return null;
    }

    public void forcePlaceGem(UUID gemId, Location target) {
        if (gemId == null || target == null) {
            return;
        }
        Location oldLoc = this.findLocationByGemId(gemId);
        Player holder = this.gemUuidToHolder.get(gemId);
        Location base = target.clone();
        SchedulerUtil.regionRun((Plugin)this.plugin, base, () -> {
            Location t;
            World world = base.getWorld();
            if (world == null) {
                return;
            }
            WorldBorder border = world.getWorldBorder();
            if (!border.isInside(t = base.getBlock().getLocation()) || t.getBlockY() < world.getMinHeight() || t.getBlockY() > world.getMaxHeight()) {
                return;
            }
            Material mat = this.getGemMaterial(gemId);
            if (this.isSupportRequired(mat) && !this.hasBlockSupport(t)) {
                return;
            }
            try {
                if (!t.getChunk().isLoaded()) {
                    t.getChunk().load();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            t.getBlock().setType(mat);
            this.locationToGemUuid.put(t, gemId);
            if (oldLoc != null) {
                this.unplaceRuleGem(oldLoc, gemId);
            }
            if (holder != null) {
                this.gemUuidToHolder.remove(gemId);
                this.removeGemItemFromInventory(holder, gemId);
                this.recalculateGrants(holder);
            }
        }, 0L, -1L);
    }
}

