/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.manager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.cubexmc.RuleGems;
import org.cubexmc.manager.LanguageManager;

public class HistoryLogger {
    private final RuleGems plugin;
    private final LanguageManager languageManager;
    private final File logsDirectory;
    private final SimpleDateFormat dateFormat;
    private final SimpleDateFormat fileNameFormat;

    public HistoryLogger(RuleGems plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.logsDirectory = new File(plugin.getDataFolder(), "history");
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.fileNameFormat = new SimpleDateFormat("yyyy-MM");
        if (!this.logsDirectory.exists()) {
            this.logsDirectory.mkdirs();
        }
    }

    public void logGemRedeem(Player player, String gemKey, String gemDisplayName, List<String> permissions, String vaultGroup, String previousOwner) {
        HashMap<String, String> sectionPlaceholders;
        StringBuilder logEntry = new StringBuilder();
        String timestamp = this.dateFormat.format(new Date());
        logEntry.append("[").append(timestamp).append("] ");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("player_uuid", player.getUniqueId().toString());
        String gemName = gemDisplayName != null ? gemDisplayName : gemKey;
        placeholders.put("gem_name", gemName);
        placeholders.put("gem_key", gemKey);
        Object previousOwnerSection = "";
        if (previousOwner != null && !previousOwner.isEmpty()) {
            HashMap<String, String> sectionPlaceholders2 = new HashMap<String, String>();
            sectionPlaceholders2.put("previous_owner", previousOwner);
            previousOwnerSection = this.formatHistoryMessage("history.redeem.previous_owner", sectionPlaceholders2);
            if (((String)previousOwnerSection).isEmpty()) {
                previousOwnerSection = " | \u524d\u4efb: " + previousOwner;
            }
        }
        Object permissionsSection = "";
        if (permissions != null && !permissions.isEmpty()) {
            String joined = String.join((CharSequence)", ", permissions);
            sectionPlaceholders = new HashMap<String, String>();
            sectionPlaceholders.put("permissions", joined);
            permissionsSection = this.formatHistoryMessage("history.redeem.permissions", sectionPlaceholders);
            if (((String)permissionsSection).isEmpty()) {
                permissionsSection = " | \u6743\u9650: [" + joined + "]";
            }
        }
        Object vaultGroupSection = "";
        if (vaultGroup != null && !vaultGroup.isEmpty()) {
            sectionPlaceholders = new HashMap();
            sectionPlaceholders.put("vault_group", vaultGroup);
            vaultGroupSection = this.formatHistoryMessage("history.redeem.vault_group", sectionPlaceholders);
            if (((String)vaultGroupSection).isEmpty()) {
                vaultGroupSection = " | \u6743\u9650\u7ec4: " + vaultGroup;
            }
        }
        placeholders.put("previous_owner_section", (String)previousOwnerSection);
        placeholders.put("permissions_section", (String)permissionsSection);
        placeholders.put("vault_group_section", (String)vaultGroupSection);
        String message = this.formatHistoryMessage("history.redeem.entry", placeholders);
        if (message.isEmpty()) {
            message = this.buildFallbackRedeem(player, gemKey, gemDisplayName, permissions, vaultGroup, previousOwner);
        }
        logEntry.append(message);
        this.writeLog(logEntry.toString());
    }

    public void logPermissionRevoke(String playerUuid, String playerName, String gemKey, String gemDisplayName, List<String> permissions, String vaultGroup, String reason) {
        HashMap<String, String> sectionPlaceholders;
        StringBuilder logEntry = new StringBuilder();
        String timestamp = this.dateFormat.format(new Date());
        logEntry.append("[").append(timestamp).append("] ");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player_name", playerName != null ? playerName : "\u672a\u77e5");
        placeholders.put("player_uuid", playerUuid);
        String gemName = gemDisplayName != null ? gemDisplayName : gemKey;
        placeholders.put("gem_name", gemName);
        placeholders.put("gem_key", gemKey);
        Object reasonSection = "";
        if (reason != null && !reason.isEmpty()) {
            HashMap<String, String> sectionPlaceholders2 = new HashMap<String, String>();
            sectionPlaceholders2.put("reason", reason);
            reasonSection = this.formatHistoryMessage("history.revoke.reason", sectionPlaceholders2);
            if (((String)reasonSection).isEmpty()) {
                reasonSection = " | \u539f\u56e0: " + reason;
            }
        }
        Object permissionsSection = "";
        if (permissions != null && !permissions.isEmpty()) {
            String joined = String.join((CharSequence)", ", permissions);
            sectionPlaceholders = new HashMap<String, String>();
            sectionPlaceholders.put("permissions", joined);
            permissionsSection = this.formatHistoryMessage("history.revoke.permissions", sectionPlaceholders);
            if (((String)permissionsSection).isEmpty()) {
                permissionsSection = " | \u64a4\u9500\u6743\u9650: [" + joined + "]";
            }
        }
        Object vaultGroupSection = "";
        if (vaultGroup != null && !vaultGroup.isEmpty()) {
            sectionPlaceholders = new HashMap();
            sectionPlaceholders.put("vault_group", vaultGroup);
            vaultGroupSection = this.formatHistoryMessage("history.revoke.vault_group", sectionPlaceholders);
            if (((String)vaultGroupSection).isEmpty()) {
                vaultGroupSection = " | \u64a4\u9500\u6743\u9650\u7ec4: " + vaultGroup;
            }
        }
        placeholders.put("reason_section", (String)reasonSection);
        placeholders.put("permissions_section", (String)permissionsSection);
        placeholders.put("vault_group_section", (String)vaultGroupSection);
        String message = this.formatHistoryMessage("history.revoke.entry", placeholders);
        if (message.isEmpty()) {
            message = this.buildFallbackRevoke(playerUuid, playerName, gemKey, gemDisplayName, permissions, vaultGroup, reason);
        }
        logEntry.append(message);
        this.writeLog(logEntry.toString());
    }

    public void logFullSetRedeem(Player player, int gemCount, List<String> permissions, String previousFullSetOwner) {
        StringBuilder logEntry = new StringBuilder();
        String timestamp = this.dateFormat.format(new Date());
        logEntry.append("[").append(timestamp).append("] ");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("player_uuid", player.getUniqueId().toString());
        placeholders.put("gem_count", String.valueOf(gemCount));
        Object previousOwnerSection = "";
        if (previousFullSetOwner != null && !previousFullSetOwner.isEmpty()) {
            HashMap<String, String> sectionPlaceholders = new HashMap<String, String>();
            sectionPlaceholders.put("previous_owner", previousFullSetOwner);
            previousOwnerSection = this.formatHistoryMessage("history.full_set.previous_owner", sectionPlaceholders);
            if (((String)previousOwnerSection).isEmpty()) {
                previousOwnerSection = " | \u524d\u4efb\u7edf\u6cbb\u8005: " + previousFullSetOwner;
            }
        }
        Object permissionsSection = "";
        if (permissions != null && !permissions.isEmpty()) {
            String joined = String.join((CharSequence)", ", permissions);
            HashMap<String, String> sectionPlaceholders = new HashMap<String, String>();
            sectionPlaceholders.put("permissions", joined);
            permissionsSection = this.formatHistoryMessage("history.full_set.permissions", sectionPlaceholders);
            if (((String)permissionsSection).isEmpty()) {
                permissionsSection = " | \u603b\u6743\u9650: [" + joined + "]";
            }
        }
        placeholders.put("previous_owner_section", (String)previousOwnerSection);
        placeholders.put("permissions_section", (String)permissionsSection);
        String message = this.formatHistoryMessage("history.full_set.entry", placeholders);
        if (message.isEmpty()) {
            message = this.buildFallbackFullSet(player, gemCount, permissions, previousFullSetOwner);
        }
        logEntry.append(message);
        this.writeLog(logEntry.toString());
    }

    public void logGemPlace(Player player, String gemKey, String location) {
        StringBuilder logEntry = new StringBuilder();
        String timestamp = this.dateFormat.format(new Date());
        logEntry.append("[").append(timestamp).append("] ");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("gem_key", gemKey);
        placeholders.put("location", location);
        String message = this.formatHistoryMessage("history.place.entry", placeholders);
        if (message.isEmpty()) {
            message = this.buildFallbackPlace(player, gemKey, location);
        }
        logEntry.append(message);
        this.writeLog(logEntry.toString());
    }

    public void logGemBreak(Player player, String gemKey, String location) {
        StringBuilder logEntry = new StringBuilder();
        String timestamp = this.dateFormat.format(new Date());
        logEntry.append("[").append(timestamp).append("] ");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("gem_key", gemKey);
        placeholders.put("location", location);
        String message = this.formatHistoryMessage("history.break.entry", placeholders);
        if (message.isEmpty()) {
            message = this.buildFallbackBreak(player, gemKey, location);
        }
        logEntry.append(message);
        this.writeLog(logEntry.toString());
    }

    private String formatHistoryMessage(String key, Map<String, String> placeholders) {
        if (this.languageManager == null) {
            return "";
        }
        String template = this.languageManager.getMessage(key);
        if (template == null || template.startsWith("Missing message")) {
            return "";
        }
        if (placeholders != null && !placeholders.isEmpty()) {
            template = this.languageManager.formatText(template, placeholders);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)template);
    }

    private String buildFallbackRedeem(Player player, String gemKey, String gemDisplayName, List<String> permissions, String vaultGroup, String previousOwner) {
        StringBuilder builder = new StringBuilder("\u00a7e\u3010\u5b9d\u77f3\u5151\u6362\u3011 ");
        builder.append("\u73a9\u5bb6: ").append(player.getName()).append(" (").append(player.getUniqueId()).append(") ");
        builder.append("| \u5b9d\u77f3: ").append(gemDisplayName != null ? gemDisplayName : gemKey).append(" (").append(gemKey).append(")");
        if (previousOwner != null && !previousOwner.isEmpty()) {
            builder.append(" | \u524d\u4efb: ").append(previousOwner);
        }
        if (permissions != null && !permissions.isEmpty()) {
            builder.append(" | \u6743\u9650: [").append(String.join((CharSequence)", ", permissions)).append("]");
        }
        if (vaultGroup != null && !vaultGroup.isEmpty()) {
            builder.append(" | \u6743\u9650\u7ec4: ").append(vaultGroup);
        }
        return builder.toString();
    }

    private String buildFallbackRevoke(String playerUuid, String playerName, String gemKey, String gemDisplayName, List<String> permissions, String vaultGroup, String reason) {
        StringBuilder builder = new StringBuilder("\u00a7c\u3010\u6743\u9650\u64a4\u9500\u3011 ");
        builder.append("\u73a9\u5bb6: ").append(playerName != null ? playerName : "\u672a\u77e5").append(" (").append(playerUuid).append(") ");
        builder.append("| \u5b9d\u77f3: ").append(gemDisplayName != null ? gemDisplayName : gemKey).append(" (").append(gemKey).append(")");
        if (reason != null && !reason.isEmpty()) {
            builder.append(" | \u539f\u56e0: ").append(reason);
        }
        if (permissions != null && !permissions.isEmpty()) {
            builder.append(" | \u64a4\u9500\u6743\u9650: [").append(String.join((CharSequence)", ", permissions)).append("]");
        }
        if (vaultGroup != null && !vaultGroup.isEmpty()) {
            builder.append(" | \u64a4\u9500\u6743\u9650\u7ec4: ").append(vaultGroup);
        }
        return builder.toString();
    }

    private String buildFallbackFullSet(Player player, int gemCount, List<String> permissions, String previousFullSetOwner) {
        StringBuilder builder = new StringBuilder("\u00a76\u3010\u96c6\u9f50\u5168\u5957\u3011 ");
        builder.append("\u73a9\u5bb6: ").append(player.getName()).append(" (").append(player.getUniqueId()).append(") ");
        builder.append("| \u5b9d\u77f3\u6570\u91cf: ").append(gemCount);
        if (previousFullSetOwner != null && !previousFullSetOwner.isEmpty()) {
            builder.append(" | \u524d\u4efb\u7edf\u6cbb\u8005: ").append(previousFullSetOwner);
        }
        if (permissions != null && !permissions.isEmpty()) {
            builder.append(" | \u603b\u6743\u9650: [").append(String.join((CharSequence)", ", permissions)).append("]");
        }
        return builder.toString();
    }

    private String buildFallbackPlace(Player player, String gemKey, String location) {
        return "\u00a7a\u3010\u5b9d\u77f3\u653e\u7f6e\u3011 \u73a9\u5bb6: " + player.getName() + " | \u5b9d\u77f3: " + gemKey + " | \u4f4d\u7f6e: " + location;
    }

    private String buildFallbackBreak(Player player, String gemKey, String location) {
        return "\u00a7c\u3010\u5b9d\u77f3\u7834\u574f\u3011 \u73a9\u5bb6: " + player.getName() + " | \u5b9d\u77f3: " + gemKey + " | \u4f4d\u7f6e: " + location;
    }

    private void writeLog(String logEntry) {
        String fileName = this.fileNameFormat.format(new Date()) + ".log";
        File logFile = new File(this.logsDirectory, fileName);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));){
            String cleanEntry = logEntry.replaceAll("\u00a7[0-9a-fk-or]", "");
            writer.write(cleanEntry);
            writer.newLine();
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u5199\u5165\u5386\u53f2\u65e5\u5fd7: " + e.getMessage());
        }
    }

    public HistoryPage getRecentHistoryPage(int page, int pageSize) {
        ArrayList<String> entries = new ArrayList<String>();
        int total = 0;
        int startIndex = Math.max(0, (page - 1) * pageSize);
        int endIndex = startIndex + pageSize;
        try {
            File[] logFiles = this.logsDirectory.listFiles((dir, name) -> name.endsWith(".log"));
            if (logFiles == null || logFiles.length == 0) {
                return new HistoryPage(entries, total);
            }
            Arrays.sort(logFiles, (a, b) -> b.getName().compareTo(a.getName()));
            for (File logFile : logFiles) {
                List fileLines;
                try (Stream<String> stream = Files.lines(logFile.toPath());){
                    fileLines = stream.collect(Collectors.toList());
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("\u8bfb\u53d6\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25: " + logFile.getName());
                    continue;
                }
                for (int i = fileLines.size() - 1; i >= 0; --i) {
                    String line = (String)fileLines.get(i);
                    if (total >= startIndex && total < endIndex) {
                        entries.add(line);
                    }
                    ++total;
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bfb\u53d6\u5386\u53f2\u8bb0\u5f55\u5931\u8d25: " + e.getMessage());
        }
        return new HistoryPage(entries, total);
    }

    public HistoryPage getPlayerHistoryPage(String playerName, int page, int pageSize) {
        ArrayList<String> entries = new ArrayList<String>();
        int total = 0;
        int startIndex = Math.max(0, (page - 1) * pageSize);
        int endIndex = startIndex + pageSize;
        String lowerPlayer = playerName.toLowerCase(Locale.ROOT);
        try {
            File[] logFiles = this.logsDirectory.listFiles((dir, name) -> name.endsWith(".log"));
            if (logFiles == null || logFiles.length == 0) {
                return new HistoryPage(entries, total);
            }
            Arrays.sort(logFiles, (a, b) -> b.getName().compareTo(a.getName()));
            for (File logFile : logFiles) {
                List fileLines;
                try (Stream<String> stream = Files.lines(logFile.toPath());){
                    fileLines = stream.collect(Collectors.toList());
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("\u8bfb\u53d6\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25: " + logFile.getName());
                    continue;
                }
                for (int i = fileLines.size() - 1; i >= 0; --i) {
                    String line = (String)fileLines.get(i);
                    if (!this.lineMatchesPlayer(line, lowerPlayer)) continue;
                    if (total >= startIndex && total < endIndex) {
                        entries.add(line);
                    }
                    ++total;
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bfb\u53d6\u73a9\u5bb6\u5386\u53f2\u8bb0\u5f55\u5931\u8d25: " + e.getMessage());
        }
        return new HistoryPage(entries, total);
    }

    public List<String> getRecentHistory(int lines) {
        HistoryPage page = this.getRecentHistoryPage(1, Math.max(1, lines));
        return page.getEntries();
    }

    public List<String> getPlayerHistory(String playerName, int lines) {
        HistoryPage page = this.getPlayerHistoryPage(playerName, 1, Math.max(1, lines));
        return page.getEntries();
    }

    private boolean lineMatchesPlayer(String line, String lowerPlayer) {
        if (line == null || line.isEmpty()) {
            return false;
        }
        String lowerLine = line.toLowerCase(Locale.ROOT);
        return lowerLine.contains("player: " + lowerPlayer) || lowerLine.contains("\u73a9\u5bb6: " + lowerPlayer) || lowerLine.contains(lowerPlayer + " (") || lowerLine.contains("| " + lowerPlayer + " |");
    }

    public static final class HistoryPage {
        private final List<String> entries;
        private final int totalCount;

        public HistoryPage(List<String> entries, int totalCount) {
            this.entries = entries;
            this.totalCount = totalCount;
        }

        public List<String> getEntries() {
            return this.entries;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }
}

