/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.cubexmc.RuleGems;
import org.cubexmc.update.LanguageUpdater;
import org.cubexmc.utils.SchedulerUtil;

public class LanguageManager {
    private final RuleGems plugin;
    private String language;
    private FileConfiguration langConfig;
    private String prefix;
    private static final String[] BUNDLED_LANGUAGES = new String[]{"en_US", "zh_CN"};

    public LanguageManager(RuleGems plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyLangFileIfNotExists(String lang) {
        File outFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".yml");
        if (outFile.exists()) return true;
        File parent = outFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (InputStream resource = this.plugin.getResource("lang/" + lang + ".yml");){
            if (resource == null) {
                this.plugin.getLogger().warning("Bundled language file missing from jar: lang/" + lang + ".yml");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.plugin.saveResource("lang/" + lang + ".yml", false);
        return true;
    }

    private void ensureLanguageUpdated(String lang) {
        if (!this.copyLangFileIfNotExists(lang)) {
            return;
        }
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".yml");
        LanguageUpdater.merge(this.plugin, langFile, "lang/" + lang + ".yml");
    }

    public void updateBundledLanguages() {
        for (String lang : BUNDLED_LANGUAGES) {
            this.ensureLanguageUpdated(lang);
        }
    }

    public void loadLanguage() {
        this.language = this.plugin.getConfig().getString("language", "zh_CN");
        this.ensureLanguageUpdated(this.language);
        this.loadLangConfig(this.language);
        if (this.langConfig == null) {
            this.language = "zh_CN";
            if (this.copyLangFileIfNotExists("zh_CN")) {
                this.ensureLanguageUpdated("zh_CN");
                this.loadLangConfig("zh_CN");
            }
        }
        this.prefix = this.langConfig != null ? this.langConfig.getString("prefix", "&7[&6RuleGems&7] ") : "&7[&6RuleGems&7] ";
    }

    private void loadLangConfig(String lang) {
        if (!this.copyLangFileIfNotExists(lang)) {
            return;
        }
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".yml");
        if (langFile.exists()) {
            this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        }
    }

    public String getMessage(String path) {
        return this.getMessage(path, this.language);
    }

    public String getMessage(String path, String lang) {
        if (this.langConfig == null) {
            return "Missing language file: " + lang;
        }
        String message = this.langConfig.getString(path);
        return message != null ? message : "Missing message: " + path;
    }

    public String formatMessage(String path, Map<String, String> placeholders) {
        return this.formatMessage(path, this.language, placeholders);
    }

    public String formatMessage(String path, String lang, Map<String, String> placeholders) {
        String message = this.getMessage(path, lang);
        if ((message = this.formatText(message, placeholders)) != null && this.prefix != null) {
            message = message.replace("%prefix%", this.prefix);
        }
        return message;
    }

    public String formatText(String message, Map<String, String> placeholders) {
        if (placeholders != null && message != null) {
            for (String key : placeholders.keySet()) {
                String value = placeholders.get(key);
                if (value == null) continue;
                message = message.replace("%" + key + "%", value);
            }
        }
        return message;
    }

    public void sendMessage(CommandSender sender, String path) {
        this.sendMessage(sender, path, new HashMap<String, String>());
    }

    public void sendMessage(CommandSender sender, String path, Map<String, String> placeholders) {
        String message = this.formatMessage("messages." + path, placeholders);
        sender.sendMessage(this.translateColorCodes(message));
    }

    public void logMessage(String path) {
        this.logMessage(path, new HashMap<String, String>());
    }

    public void logMessage(String path, Map<String, String> placeholders) {
        Object key = path.startsWith("logger.") ? path : "logger." + path;
        String message = this.formatMessage((String)key, placeholders);
        if (message == null) {
            return;
        }
        if (this.plugin.getServer() != null && this.plugin.getServer().getConsoleSender() != null) {
            this.plugin.getServer().getConsoleSender().sendMessage(this.translateColorCodes(message));
            return;
        }
        Logger logger = this.plugin.getLogger();
        logger.info(ChatColor.stripColor((String)this.translateColorCodes(message)));
    }

    private String translateColorCodes(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getLanguage() {
        return this.language;
    }

    public void showTitle(Player player, String path, Map<String, String> placeholders) {
        if (this.langConfig == null) {
            return;
        }
        List titleMessages = this.langConfig.getStringList("title." + path);
        if (titleMessages.size() == 1) {
            SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)player, () -> player.sendTitle(this.translateColorCodes(this.formatText((String)titleMessages.get(0), placeholders)), null, 10, 70, 20), 0L, -1L);
        } else if (titleMessages.size() == 2) {
            SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)player, () -> player.sendTitle(this.translateColorCodes(this.formatText((String)titleMessages.get(0), placeholders)), this.translateColorCodes(this.formatText((String)titleMessages.get(1), placeholders)), 10, 70, 20), 0L, -1L);
        }
    }
}

