/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.model;

import java.util.Collections;
import java.util.List;

public class AllowedCommand {
    private final String label;
    private final int uses;
    private final List<String> executeCommands;
    private final int cooldown;

    public AllowedCommand(String label, int uses, List<String> executeCommands, int cooldown) {
        this.label = label;
        this.uses = Math.max(-1, uses);
        this.executeCommands = executeCommands != null && !executeCommands.isEmpty() ? executeCommands : Collections.singletonList(label);
        this.cooldown = Math.max(0, cooldown);
    }

    public String getLabel() {
        return this.label;
    }

    public int getUses() {
        return this.uses;
    }

    public List<String> getCommands() {
        return this.executeCommands;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isSimpleCommand() {
        return this.executeCommands.size() == 1 && !this.executeCommands.get(0).startsWith("console:") && !this.executeCommands.get(0).startsWith("player-op:") && this.executeCommands.get(0).equalsIgnoreCase(this.label);
    }

    public static String[] parseExecutor(String commandLine) {
        if (commandLine == null || commandLine.isEmpty()) {
            return new String[]{"player-op", ""};
        }
        String trimmed = commandLine.trim();
        if (trimmed.startsWith("console:")) {
            return new String[]{"console", trimmed.substring(8).trim()};
        }
        if (trimmed.startsWith("player-op:")) {
            return new String[]{"player-op", trimmed.substring(10).trim()};
        }
        return new String[]{"player-op", trimmed};
    }
}

