/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.model;

import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.cubexmc.model.AllowedCommand;
import org.cubexmc.model.ExecuteConfig;

public class GemDefinition {
    private final String gemKey;
    private final Material material;
    private final String displayName;
    private final Particle particle;
    private final Sound sound;
    private final ExecuteConfig onPickup;
    private final ExecuteConfig onScatter;
    private final ExecuteConfig onRedeem;
    private final List<String> permissions;
    private final String vaultGroup;
    private final List<String> lore;
    private final List<String> redeemTitle;
    private final boolean enchanted;
    private final List<AllowedCommand> allowedCommands;
    private final List<String> mutualExclusive;
    private final int count;
    private final Location randomPlaceCorner1;
    private final Location randomPlaceCorner2;

    public GemDefinition(String gemKey, Material material, String displayName, Particle particle, Sound sound, ExecuteConfig onPickup, ExecuteConfig onScatter, ExecuteConfig onRedeem, List<String> permissions, String vaultGroup, List<String> lore, List<String> redeemTitle, boolean enchanted, List<AllowedCommand> allowedCommands, List<String> mutualExclusive, int count, Location randomPlaceCorner1, Location randomPlaceCorner2) {
        this.gemKey = gemKey;
        this.material = material;
        this.displayName = displayName;
        this.particle = particle;
        this.sound = sound;
        this.onPickup = onPickup;
        this.onScatter = onScatter;
        this.onRedeem = onRedeem;
        this.permissions = permissions;
        this.vaultGroup = vaultGroup;
        this.lore = lore;
        this.redeemTitle = redeemTitle;
        this.enchanted = enchanted;
        this.allowedCommands = allowedCommands == null ? Collections.emptyList() : allowedCommands;
        this.mutualExclusive = mutualExclusive == null ? Collections.emptyList() : mutualExclusive;
        this.count = Math.max(1, count);
        this.randomPlaceCorner1 = randomPlaceCorner1;
        this.randomPlaceCorner2 = randomPlaceCorner2;
    }

    public String getGemKey() {
        return this.gemKey;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public Sound getSound() {
        return this.sound;
    }

    public ExecuteConfig getOnPickup() {
        return this.onPickup;
    }

    public ExecuteConfig getOnScatter() {
        return this.onScatter;
    }

    public ExecuteConfig getOnRedeem() {
        return this.onRedeem;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public String getVaultGroup() {
        return this.vaultGroup;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public List<String> getRedeemTitle() {
        return this.redeemTitle;
    }

    public boolean isEnchanted() {
        return this.enchanted;
    }

    public List<AllowedCommand> getAllowedCommands() {
        return this.allowedCommands;
    }

    public List<String> getMutualExclusive() {
        return this.mutualExclusive;
    }

    public int getCount() {
        return this.count;
    }

    public Location getRandomPlaceCorner1() {
        return this.randomPlaceCorner1;
    }

    public Location getRandomPlaceCorner2() {
        return this.randomPlaceCorner2;
    }
}

