/*
 * Decompiled with CFR 0.152.
 */
package me.hushu;

import me.hushu.commands.RulerGemCommand;
import me.hushu.commands.RulerGemTabCompleter;
import me.hushu.listeners.GemInventoryListener;
import me.hushu.listeners.GemPlaceListener;
import me.hushu.listeners.PlayerEventListener;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.GemManager;
import me.hushu.manager.LanguageManager;
import me.hushu.metrics.Metrics;
import me.hushu.utils.EffectUtils;
import me.hushu.utils.SchedulerUtil;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class RulerGem
extends JavaPlugin {
    private ConfigManager configManager;
    private GemManager gemManager;
    private EffectUtils effectUtils;
    private LanguageManager languageManager;
    private Permission vaultPerms;
    private Metrics metrics;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.effectUtils = new EffectUtils(this);
        this.gemManager = new GemManager(this, this.configManager, this.effectUtils, this.languageManager);
        this.metrics = new Metrics((Plugin)this, 27436);
        this.loadPlugin();
        RulerGemCommand rulerGemCommand = new RulerGemCommand(this, this.gemManager, this.configManager, this.languageManager);
        PluginCommand cmd = this.getCommand("rulergem");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)rulerGemCommand);
            cmd.setTabCompleter((TabCompleter)new RulerGemTabCompleter(this.configManager));
        } else {
            this.getLogger().warning("Command 'rulergem' not found in plugin.yml");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new GemPlaceListener(this, this.gemManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GemInventoryListener(this.gemManager, this.languageManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerEventListener(this, this.gemManager), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            try {
                RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
                if (rsp != null) {
                    this.vaultPerms = (Permission)rsp.getProvider();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SchedulerUtil.globalRun((Plugin)this, () -> this.gemManager.checkPlayersNearRulerGems(), 20L, 20L);
        this.gemManager.startParticleEffectTask(Particle.FLAME);
        SchedulerUtil.globalRun((Plugin)this, () -> this.gemManager.saveGems(), 72000L, 72000L);
        this.languageManager.logMessage("plugin_enabled");
    }

    public void onDisable() {
        this.gemManager.saveGems();
        this.languageManager.logMessage("plugin_disabled");
    }

    public void loadPlugin() {
        this.saveDefaultConfig();
        this.languageManager.loadLanguage();
        this.configManager.initGemFile();
        this.configManager.loadConfigs();
        this.configManager.getGemsData();
        this.gemManager.loadGems();
        this.gemManager.initializePlacedGemBlocks();
        this.gemManager.ensureConfiguredGemsPresent();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GemManager getGemManager() {
        return this.gemManager;
    }

    public EffectUtils getEffectUtils() {
        return this.effectUtils;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public Permission getVaultPerms() {
        return this.vaultPerms;
    }
}

