/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.hushu.RulerGem;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.GemManager;
import me.hushu.manager.LanguageManager;
import me.hushu.utils.SchedulerUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RulerGemCommand
implements CommandExecutor {
    private final RulerGem plugin;
    private final GemManager gemManager;
    private final ConfigManager configManager;
    private final LanguageManager languageManager;

    public RulerGemCommand(RulerGem plugin, GemManager gemManager, ConfigManager configManager, LanguageManager languageManager) {
        this.plugin = plugin;
        this.gemManager = gemManager;
        this.configManager = configManager;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("rulergem")) {
            return false;
        }
        if (args.length == 0) {
            this.languageManager.sendMessage(sender, "command.usage");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                this.gemManager.saveGems();
                this.configManager.reloadConfigs();
                this.languageManager.loadLanguage();
                this.plugin.loadPlugin();
                this.languageManager.sendMessage(sender, "command.reload_success");
                return true;
            }
            case "rulers": {
                if (this.require(sender, "rulergem.rulers")) {
                    return true;
                }
                Map<UUID, Set<String>> holders = this.gemManager.getCurrentPowerHolders();
                if (holders.isEmpty()) {
                    this.languageManager.sendMessage(sender, "command.no_rulers");
                    return true;
                }
                for (Map.Entry<UUID, Set<String>> e : holders.entrySet()) {
                    Player p = Bukkit.getPlayer((UUID)e.getKey());
                    String name = p != null ? p.getName() : e.getKey().toString();
                    String extra = e.getValue().contains("ALL") ? "ALL" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)e.getValue());
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", name + " (" + extra + ")");
                    this.languageManager.sendMessage(sender, "command.rulers_status", placeholders);
                }
                return true;
            }
            case "gems": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                this.gemManager.gemStatus(sender);
                return true;
            }
            case "tp": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                return this.handleTpCommand(sender, args);
            }
            case "scatter": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                this.gemManager.scatterGems();
                this.languageManager.sendMessage(sender, "command.scatter_success");
                return true;
            }
            case "redeem": {
                if (this.require(sender, "rulergem.redeem")) {
                    return true;
                }
                if (!this.configManager.isRedeemEnabled()) {
                    this.languageManager.sendMessage(sender, "command.redeem.disabled");
                    return true;
                }
                return this.handleRedeem(sender, args);
            }
            case "redeemall": {
                if (this.require(sender, "rulergem.redeemall")) {
                    return true;
                }
                if (!this.configManager.isFullSetGrantsAllEnabled()) {
                    this.languageManager.sendMessage(sender, "command.redeemall.disabled");
                    return true;
                }
                return this.handleRedeemAll(sender);
            }
            case "place": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                return this.handlePlaceCommand(sender, args);
            }
            case "revoke": {
                if (this.require(sender, "rulergem.admin")) {
                    return true;
                }
                return this.handleRevokeCommand(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        this.languageManager.sendMessage(sender, "command.unknown_subcommand");
        return true;
    }

    private boolean require(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            this.languageManager.sendMessage(sender, "command.no_permission");
            return true;
        }
        return false;
    }

    private void sendHelp(CommandSender sender) {
        this.languageManager.sendMessage(sender, "command.help.header");
        this.languageManager.sendMessage(sender, "command.help.place");
        this.languageManager.sendMessage(sender, "command.help.revoke");
        this.languageManager.sendMessage(sender, "command.help.reload");
        this.languageManager.sendMessage(sender, "command.help.rulers");
        this.languageManager.sendMessage(sender, "command.help.gems");
        this.languageManager.sendMessage(sender, "command.help.scatter");
        this.languageManager.sendMessage(sender, "command.help.redeem");
        this.languageManager.sendMessage(sender, "command.help.redeemall");
        this.languageManager.sendMessage(sender, "command.help.help");
        this.languageManager.sendMessage(sender, "command.help.footer");
    }

    private boolean handleTpCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u8be5\u6307\u4ee4\u4ec5\u9650\u73a9\u5bb6\u4f7f\u7528\u3002");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u7528\u6cd5: /rulergem tp <gemId\u6216key>");
            return true;
        }
        Player p = (Player)sender;
        UUID gemId = this.gemManager.resolveGemIdentifier(args[1]);
        if (gemId == null) {
            sender.sendMessage("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9d\u77f3\u3002");
            return true;
        }
        Player realHolder = this.gemManager.getGemHolder(gemId);
        if (realHolder != null && realHolder.isOnline()) {
            Location dest = realHolder.getLocation();
            SchedulerUtil.safeTeleport((Plugin)this.plugin, p, dest);
            return true;
        }
        Location loc = this.gemManager.getGemLocation(gemId);
        if (loc != null) {
            Location dest = loc.clone().add(0.5, 1.0, 0.5);
            SchedulerUtil.safeTeleport((Plugin)this.plugin, p, dest);
            return true;
        }
        sender.sendMessage("\u8be5\u5b9d\u77f3\u65e2\u672a\u88ab\u6301\u6709\u4e5f\u672a\u653e\u7f6e\u3002");
        return true;
    }

    private boolean handlePlaceCommand(CommandSender sender, String[] args) {
        Material m;
        double z;
        double y;
        double x;
        if (args.length < 5) {
            this.languageManager.sendMessage(sender, "command.place.usage");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.place.player_only");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        String gemIdentifier = args[1];
        if (args[2].equals("~")) {
            args[2] = String.valueOf(player.getLocation().getX());
        }
        if (args[3].equals("~")) {
            args[3] = String.valueOf(player.getLocation().getY());
        }
        if (args[4].equals("~")) {
            args[4] = String.valueOf(player.getLocation().getZ());
        }
        try {
            x = Double.parseDouble(args[2]);
            y = Double.parseDouble(args[3]);
            z = Double.parseDouble(args[4]);
        }
        catch (NumberFormatException e) {
            this.languageManager.sendMessage(sender, "command.place.invalid_coordinates");
            return true;
        }
        UUID gemId = this.gemManager.resolveGemIdentifier(gemIdentifier);
        if (gemId == null) {
            this.languageManager.sendMessage(sender, "command.place.invalid_gem");
            return true;
        }
        Location loc = new Location(world, x, y, z);
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load();
        }
        if (this.gemManager.isSupportRequired(m = this.gemManager.getGemMaterial(gemId)) && !this.gemManager.hasBlockSupport(loc)) {
            this.languageManager.sendMessage(sender, "command.place.failed_unsupported");
            return true;
        }
        this.gemManager.forcePlaceGem(gemId, loc);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("x", String.valueOf(x));
        placeholders.put("y", String.valueOf(y));
        placeholders.put("z", String.valueOf(z));
        this.languageManager.sendMessage(sender, "command.place.success", placeholders);
        return true;
    }

    private boolean handleRedeem(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.redeem.player_only");
            return true;
        }
        Player player = (Player)sender;
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            this.languageManager.sendMessage(sender, "command.redeem.no_item_in_hand");
            return true;
        }
        if (!this.gemManager.isRulerGem(inHand)) {
            this.languageManager.sendMessage(sender, "command.redeem.not_a_gem");
            return true;
        }
        boolean ok = this.gemManager.redeemGemInHand(player);
        if (!ok) {
            this.languageManager.sendMessage(sender, "command.redeem.failed");
            return true;
        }
        this.languageManager.sendMessage(sender, "command.redeem.success");
        return true;
    }

    private boolean handleRedeemAll(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.redeem.player_only");
            return true;
        }
        Player player = (Player)sender;
        boolean ok = this.gemManager.redeemAll(player);
        if (!ok) {
            this.languageManager.sendMessage(sender, "command.redeemall.failed");
            return true;
        }
        this.languageManager.sendMessage(sender, "command.redeemall.success");
        return true;
    }

    private boolean handleRevokeCommand(CommandSender sender) {
        if (this.gemManager.getPowerPlayer() == null) {
            this.languageManager.sendMessage(sender, "command.revoke.no_power_player");
            return true;
        }
        this.gemManager.revokePermission(sender);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", this.gemManager.getPowerPlayer().getName());
        this.languageManager.sendMessage(sender, "command.revoke.success", placeholders);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.languageManager.showTitle(player, "power_revoked", placeholders);
        }
        return true;
    }
}

