/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.hushu.RulerGem;
import me.hushu.model.ExecuteConfig;
import me.hushu.utils.SchedulerUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EffectUtils {
    private final RulerGem plugin;

    public EffectUtils(RulerGem plugin) {
        this.plugin = plugin;
    }

    public void executeCommands(ExecuteConfig execCfg, Map<String, String> placeholders) {
        if (execCfg == null) {
            return;
        }
        List<String> commands = execCfg.getCommands();
        if (commands == null || commands.isEmpty()) {
            return;
        }
        Map<Object, Object> ph = placeholders == null ? Collections.emptyMap() : placeholders;
        for (String original : commands) {
            if (original == null || original.trim().isEmpty()) continue;
            String replaced = original;
            for (Map.Entry<Object, Object> entry : ph.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key == null || value == null) continue;
                if (!key.startsWith("%") || !key.endsWith("%")) {
                    replaced = replaced.replace("%" + key + "%", value);
                }
                replaced = replaced.replace(key, value);
            }
            if (replaced.matches(".*%[A-Za-z0-9_]+%.*")) {
                this.plugin.getLogger().log(Level.WARNING, "[RulerGem] \u8df3\u8fc7\u6267\u884c\u547d\u4ee4\uff0c\u672a\u89e3\u6790\u5360\u4f4d\u7b26: {0}", replaced);
                continue;
            }
            String cmdToRun = replaced;
            SchedulerUtil.globalRun((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmdToRun), 0L, -1L);
        }
    }

    public void playGlobalSound(ExecuteConfig execCfg, float volume, float pitch) {
        if (execCfg == null) {
            return;
        }
        if (execCfg.getSound() != null) {
            try {
                Sound sound = Sound.valueOf((String)execCfg.getSound());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)p, () -> p.playSound(p.getLocation(), sound, volume, pitch), 0L, -1L);
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.WARNING, "[RulerGem] \u65e0\u6548\u7684\u97f3\u6548\u540d\u79f0: {0}", execCfg.getSound());
            }
        }
    }

    public void playLocalSound(Location location, ExecuteConfig execCfg, float volume, float pitch) {
        if (execCfg == null) {
            return;
        }
        if (execCfg.getSound() != null) {
            try {
                Sound sound = Sound.valueOf((String)execCfg.getSound());
                SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> location.getWorld().playSound(location, sound, volume, pitch), 0L, -1L);
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.WARNING, "[RulerGem] \u65e0\u6548\u7684\u97f3\u6548\u540d\u79f0: {0}", execCfg.getSound());
            }
        }
    }

    public void playParticle(Location location, ExecuteConfig execCfg) {
        if (execCfg == null) {
            return;
        }
        if (execCfg.getParticle() != null) {
            try {
                Particle particle = Particle.valueOf((String)execCfg.getParticle());
                SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> location.getWorld().spawnParticle(particle, location, 1), 0L, -1L);
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.WARNING, "[RulerGem] \u65e0\u6548\u7684\u7c92\u5b50\u540d\u79f0: {0}", execCfg.getParticle());
            }
        }
    }
}

