/*
 * Decompiled with CFR 0.152.
 */
package me.hushu;

import me.hushu.commands.PowerGemCommand;
import me.hushu.commands.PowerGemTabCompleter;
import me.hushu.listeners.GemInventoryListener;
import me.hushu.listeners.GemPlaceListener;
import me.hushu.listeners.PlayerEventListener;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.GemManager;
import me.hushu.manager.LanguageManager;
import me.hushu.metrics.Metrics;
import me.hushu.utils.EffectUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PowerGem
extends JavaPlugin {
    private ConfigManager configManager;
    private GemManager gemManager;
    private EffectUtils effectUtils;
    private LanguageManager languageManager;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.effectUtils = new EffectUtils(this);
        this.gemManager = new GemManager(this, this.configManager, this.effectUtils, this.languageManager);
        Metrics metrics = new Metrics((Plugin)this, 24346);
        this.loadPlugin();
        PowerGemCommand powerGemCommand = new PowerGemCommand(this, this.gemManager, this.configManager, this.languageManager);
        this.getCommand("powergem").setExecutor((CommandExecutor)powerGemCommand);
        this.getCommand("powergem").setTabCompleter((TabCompleter)new PowerGemTabCompleter());
        Bukkit.getPluginManager().registerEvents((Listener)new GemPlaceListener(this, this.gemManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GemInventoryListener(this.gemManager, this.languageManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerEventListener(this, this.gemManager), (Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.gemManager.checkPlayersNearPowerGems(), 20L, 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.gemManager.saveGems(), 72000L, 72000L);
        this.gemManager.startParticleEffectTask(this.configManager.getGemParticle());
        this.languageManager.logMessage("plugin_enabled");
    }

    public void onDisable() {
        this.gemManager.saveGems();
        this.languageManager.logMessage("plugin_disabled");
    }

    public void loadPlugin() {
        this.saveDefaultConfig();
        this.languageManager.loadLanguage();
        this.configManager.initGemFile();
        this.configManager.loadConfigs();
        this.configManager.getGemsData();
        this.gemManager.loadGems();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GemManager getGemManager() {
        return this.gemManager;
    }

    public EffectUtils getEffectUtils() {
        return this.effectUtils;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }
}

