/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.commands;

import java.util.HashMap;
import java.util.UUID;
import me.hushu.PowerGem;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.GemManager;
import me.hushu.manager.LanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PowerGemCommand
implements CommandExecutor {
    private final PowerGem plugin;
    private final GemManager gemManager;
    private final ConfigManager configManager;
    private final LanguageManager languageManager;

    public PowerGemCommand(PowerGem plugin, GemManager gemManager, ConfigManager configManager, LanguageManager languageManager) {
        this.plugin = plugin;
        this.gemManager = gemManager;
        this.configManager = configManager;
        this.languageManager = languageManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("powergem")) {
            return false;
        }
        if (args.length == 0) {
            this.languageManager.sendMessage(sender, "command.usage");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.gemManager.saveGems();
                this.configManager.reloadConfigs();
                this.languageManager.loadLanguage();
                this.plugin.loadPlugin();
                this.languageManager.sendMessage(sender, "command.reload_success");
                return true;
            }
            case "powerplayer": {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                Player pp = this.gemManager.getPowerPlayer();
                if (pp == null) {
                    this.languageManager.sendMessage(sender, "command.no_power_player");
                    return true;
                }
                placeholders.put("player", this.gemManager.getPowerPlayer().getName());
                this.languageManager.sendMessage(sender, "command.powerplayer_status", placeholders);
                return true;
            }
            case "gems": {
                this.gemManager.gemStatus(sender);
                return true;
            }
            case "scatter": {
                this.gemManager.scatterGems();
                this.languageManager.sendMessage(sender, "command.scatter_success");
                return true;
            }
            case "place": {
                return this.handlePlaceCommand(sender, args);
            }
            case "revoke": {
                return this.handleRevokeCommand(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        this.languageManager.sendMessage(sender, "command.unknown_subcommand");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        this.languageManager.sendMessage(sender, "command.help.header");
        this.languageManager.sendMessage(sender, "command.help.place");
        this.languageManager.sendMessage(sender, "command.help.revoke");
        this.languageManager.sendMessage(sender, "command.help.reload");
        this.languageManager.sendMessage(sender, "command.help.powerplayer");
        this.languageManager.sendMessage(sender, "command.help.gems");
        this.languageManager.sendMessage(sender, "command.help.scatter");
        this.languageManager.sendMessage(sender, "command.help.help");
        this.languageManager.sendMessage(sender, "command.help.footer");
    }

    private boolean handlePlaceCommand(CommandSender sender, String[] args) {
        double z;
        double y;
        double x;
        if (args.length < 4) {
            this.languageManager.sendMessage(sender, "command.place.usage");
            return true;
        }
        if (!(sender instanceof Player)) {
            this.languageManager.sendMessage(sender, "command.place.player_only");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (args[1].equals("~")) {
            args[1] = String.valueOf(player.getLocation().getX());
        }
        if (args[2].equals("~")) {
            args[2] = String.valueOf(player.getLocation().getY());
        }
        if (args[3].equals("~")) {
            args[3] = String.valueOf(player.getLocation().getZ());
        }
        try {
            x = Double.parseDouble(args[1]);
            y = Double.parseDouble(args[2]);
            z = Double.parseDouble(args[3]);
        }
        catch (NumberFormatException e) {
            this.languageManager.sendMessage(sender, "command.place.invalid_coordinates");
            return true;
        }
        if (this.gemManager.getTotalGemCount() >= this.configManager.getRequiredCount()) {
            this.languageManager.sendMessage(sender, "command.place.gem_limit_reached");
            return false;
        }
        Location loc = new Location(world, x, y, z);
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load();
        }
        UUID newGemId = UUID.randomUUID();
        this.gemManager.placePowerGem(loc, newGemId);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("x", String.valueOf(x));
        placeholders.put("y", String.valueOf(y));
        placeholders.put("z", String.valueOf(z));
        this.languageManager.sendMessage(sender, "command.place.success", placeholders);
        return true;
    }

    private boolean handleRevokeCommand(CommandSender sender) {
        if (this.gemManager.getPowerPlayer() == null) {
            this.languageManager.sendMessage(sender, "command.revoke.no_power_player");
            return true;
        }
        this.gemManager.revokePermission(sender);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", this.gemManager.getPowerPlayer().getName());
        this.languageManager.sendMessage(sender, "command.revoke.success", placeholders);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.languageManager.showTitle(player, "power_revoked", placeholders);
        }
        return true;
    }
}

