/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.manager;

import java.io.File;
import me.hushu.PowerGem;
import me.hushu.model.ExecuteConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final PowerGem plugin;
    private FileConfiguration config;
    private FileConfiguration gemsData;
    private File gemsFile;
    private int requiredCount;
    private ExecuteConfig gemUnionExecute;
    private ExecuteConfig gemScatterExecute;
    private ExecuteConfig powerRevokeExecute;
    private Material gemMaterial;
    private String gemName;
    private Particle gemParticle;
    private Sound gemSound;
    private boolean useRequiredLoc;
    private Location requiredLocCenter;
    private int requiredLocRadius;
    private Location randomPlaceCorner1;
    private Location randomPlaceCorner2;
    private String language;

    public ConfigManager(PowerGem plugin) {
        this.plugin = plugin;
    }

    public void loadConfigs() {
        String worldName;
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.language = this.plugin.getConfig().getString("language", "zh");
        this.requiredCount = this.config.getInt("required_count", 5);
        String matStr = this.config.getString("gem_material", "RED_STAINED_GLASS").toUpperCase();
        try {
            this.gemMaterial = Material.valueOf((String)matStr);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("[PowerGem] \u65e0\u6548\u7684 gem_material: " + matStr + "\uff0c\u5c06\u4f7f\u7528RED_STAINED_GLASS\u4ee3\u66ff\u3002");
            this.gemMaterial = Material.RED_STAINED_GLASS;
        }
        String gemNameStr = this.config.getString("gem_name", "&c\u6743\u529b\u5b9d\u77f3");
        this.gemName = ChatColor.translateAlternateColorCodes((char)'&', (String)gemNameStr);
        this.gemParticle = Particle.valueOf((String)this.config.getString("gem_particle", "FLAME"));
        this.gemSound = Sound.valueOf((String)this.config.getString("gem_sound", "ENTITY_EXPERIENCE_ORB_PICKUP"));
        this.useRequiredLoc = this.config.getBoolean("use_required_location", false);
        if (this.useRequiredLoc) {
            ConfigurationSection locsSection = this.config.getConfigurationSection("required_locations");
            worldName = locsSection.getString("world");
            this.requiredLocRadius = locsSection.getInt("radius");
            World w = Bukkit.getWorld((String)worldName);
            if (w != null) {
                this.requiredLocCenter = this.getLocationFromConfig(locsSection, "center", w);
            } else {
                this.plugin.getLogger().warning("\u8bfb\u53d6\u5230\u65e0\u6548\u4e16\u754c: " + worldName);
            }
            this.plugin.getLogger().info(String.format("\u542f\u7528\u6307\u5b9a\u653e\u7f6e\u5750\u6807: %.2f %.2f %.2f", this.requiredLocCenter.getX(), this.requiredLocCenter.getY(), this.requiredLocCenter.getZ()));
        } else {
            this.plugin.getLogger().info("\u672a\u542f\u7528\u6307\u5b9a\u5750\u6807\u653e\u7f6e\u6a21\u5f0f\u3002");
        }
        ConfigurationSection randomPlaceRange = this.getConfig().getConfigurationSection("random_place_range");
        if (randomPlaceRange == null) {
            this.plugin.getLogger().severe("\u914d\u7f6e\u6587\u4ef6\u4e2d\u7f3a\u5c11 random_place_range \u90e8\u5206\u3002");
            return;
        }
        worldName = randomPlaceRange.getString("world");
        if (worldName == null) {
            this.plugin.getLogger().severe("random_place_range \u4e2d\u7f3a\u5c11 world \u540d\u79f0\u3002");
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u7684\u4e16\u754c: " + worldName);
            return;
        }
        this.randomPlaceCorner1 = this.getLocationFromConfig(randomPlaceRange, "corner1", world);
        this.randomPlaceCorner2 = this.getLocationFromConfig(randomPlaceRange, "corner2", world);
        if (this.randomPlaceCorner1 == null || this.randomPlaceCorner2 == null) {
            this.plugin.getLogger().severe("random_place_range \u4e2d\u7684 corner1 \u6216 corner2 \u914d\u7f6e\u65e0\u6548\u3002");
            return;
        }
        this.gemUnionExecute = this.loadExecuteConfig("gem_union_execute");
        this.gemScatterExecute = this.loadExecuteConfig("gem_scatter_execute");
        this.powerRevokeExecute = this.loadExecuteConfig("power_revoke_execute");
    }

    public void initGemFile() {
        this.gemsFile = new File(this.plugin.getDataFolder(), "powergems.yml");
        if (!this.gemsFile.exists()) {
            this.gemsFile.getParentFile().mkdirs();
            this.plugin.saveResource("powergems.yml", false);
        }
    }

    private ExecuteConfig loadExecuteConfig(String path) {
        ExecuteConfig execCfg = new ExecuteConfig(this.config.getStringList(path + ".commands"), this.config.getString(path + ".sound"), this.config.getString(path + ".particle"));
        return execCfg;
    }

    private Location getLocationFromConfig(ConfigurationSection configSection, String path, World world) {
        ConfigurationSection locSection = configSection.getConfigurationSection(path);
        if (locSection == null) {
            this.plugin.getLogger().severe("\u914d\u7f6e\u4e2d\u7f3a\u5c11 " + path + " \u8282\u3002");
            return null;
        }
        double x = locSection.getDouble("x");
        double y = locSection.getDouble("y");
        double z = locSection.getDouble("z");
        return new Location(world, x, y, z);
    }

    public void reloadConfigs() {
        this.plugin.reloadConfig();
        this.loadConfigs();
    }

    public void saveGemData(FileConfiguration data) {
        try {
            data.save(this.gemsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration readGemsData() {
        this.initGemFile();
        this.gemsData = YamlConfiguration.loadConfiguration((File)this.gemsFile);
        return this.gemsData;
    }

    public FileConfiguration getGemsData() {
        if (this.gemsData == null) {
            this.readGemsData();
        }
        return this.gemsData;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public ExecuteConfig getGemUnionExecute() {
        return this.gemUnionExecute;
    }

    public ExecuteConfig getGemScatterExecute() {
        return this.gemScatterExecute;
    }

    public ExecuteConfig getPowerRevokeExecute() {
        return this.powerRevokeExecute;
    }

    public Location getRandomPlaceCorner1() {
        return this.randomPlaceCorner1;
    }

    public Location getRandomPlaceCorner2() {
        return this.randomPlaceCorner2;
    }

    public Sound getGemSound() {
        return this.gemSound;
    }

    public Particle getGemParticle() {
        return this.gemParticle;
    }

    public Material getGemMaterial() {
        return this.gemMaterial;
    }

    public String getGemName() {
        return this.gemName;
    }

    public boolean isUseRequiredLoc() {
        return this.useRequiredLoc;
    }

    public Location getRequiredLocCenter() {
        return this.requiredLocCenter;
    }

    public int getRequiredLocRadius() {
        return this.requiredLocRadius;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getLanguage() {
        return this.language;
    }
}

