/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.hushu.PowerGem;
import me.hushu.manager.ConfigManager;
import me.hushu.manager.LanguageManager;
import me.hushu.model.ExecuteConfig;
import me.hushu.utils.EffectUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GemManager {
    private final PowerGem plugin;
    private final ConfigManager configManager;
    private final EffectUtils effectUtils;
    private final LanguageManager languageManager;
    private final NamespacedKey powerGemKey;
    private final NamespacedKey uniqueIdKey;
    private final Map<Location, UUID> locationToGemUuid = new HashMap<Location, UUID>();
    private final Map<UUID, Player> gemUuidToHolder = new HashMap<UUID, Player>();
    private Player powerPlayer;

    public GemManager(PowerGem plugin, ConfigManager configManager, EffectUtils effectUtils, LanguageManager languageManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.effectUtils = effectUtils;
        this.languageManager = languageManager;
        this.powerGemKey = new NamespacedKey((Plugin)plugin, "power_gem");
        this.uniqueIdKey = new NamespacedKey((Plugin)plugin, "unique_id");
    }

    public void loadGems() {
        ConfigurationSection heldGemsSection;
        ConfigurationSection placedGemsSection;
        String uuidStr;
        FileConfiguration gemsData = this.configManager.readGemsData();
        if (gemsData == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u52a0\u8f7d gemsData \u914d\u7f6e\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3002");
            return;
        }
        ConfigurationSection powerPlayerSection = gemsData.getConfigurationSection("power_player");
        if (powerPlayerSection != null && (uuidStr = powerPlayerSection.getString("uuid")) != null) {
            UUID powerPlayerUUID = UUID.fromString(uuidStr);
            this.powerPlayer = Bukkit.getPlayer((UUID)powerPlayerUUID);
        }
        if ((placedGemsSection = gemsData.getConfigurationSection("placed-gems")) != null) {
            for (Object uuidStr2 : placedGemsSection.getKeys(false)) {
                String worldName = placedGemsSection.getString((String)uuidStr2 + ".world");
                double x = placedGemsSection.getDouble((String)uuidStr2 + ".x");
                double y = placedGemsSection.getDouble((String)uuidStr2 + ".y");
                double z = placedGemsSection.getDouble((String)uuidStr2 + ".z");
                World w = Bukkit.getWorld((String)worldName);
                if (w == null || uuidStr2 == null) continue;
                Location loc = new Location(w, x, y, z);
                UUID gemId = UUID.fromString((String)uuidStr2);
                this.locationToGemUuid.put(loc, gemId);
            }
        }
        if ((heldGemsSection = gemsData.getConfigurationSection("held-gems")) != null) {
            for (String uuidStr3 : heldGemsSection.getKeys(false)) {
                String playerUUIDStr = heldGemsSection.getString(uuidStr3 + ".player_uuid");
                UUID playerUUID = UUID.fromString(playerUUIDStr);
                UUID gemId = UUID.fromString(uuidStr3);
                Player player = Bukkit.getPlayer((UUID)playerUUID);
                if (player == null) continue;
                if (!player.isOnline()) {
                    PlayerInventory inv = player.getInventory();
                    for (ItemStack item : inv.getContents()) {
                        if (!this.isPowerGem(item) || !this.getGemUUID(item).equals(gemId)) continue;
                        inv.remove(item);
                    }
                    this.placePowerGem(player.getLocation(), gemId);
                    continue;
                }
                this.gemUuidToHolder.put(gemId, player);
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("placed_count", String.valueOf(this.locationToGemUuid.size()));
        placeholders.put("held_count", String.valueOf(this.gemUuidToHolder.size()));
        this.languageManager.logMessage("gems_loaded", placeholders);
        this.languageManager.logMessage("gems_held_loaded", placeholders);
    }

    public void saveGems() {
        FileConfiguration gemsData = this.configManager.getGemsData();
        gemsData.set("placed-gems", null);
        gemsData.set("held-gems", null);
        gemsData.set("power_player", null);
        for (Location loc : this.locationToGemUuid.keySet()) {
            String path = "placed-gams." + this.locationToGemUuid.get(loc).toString();
            gemsData.set(path + ".world", (Object)loc.getWorld().getName());
            gemsData.set(path + ".x", (Object)loc.getX());
            gemsData.set(path + ".y", (Object)loc.getY());
            gemsData.set(path + ".z", (Object)loc.getZ());
        }
        for (UUID gemId : this.gemUuidToHolder.keySet()) {
            Player player = this.gemUuidToHolder.get(gemId);
            String path = "held-gems." + gemId.toString();
            gemsData.set(path + ".player", (Object)player.getName());
            gemsData.set(path + ".player_uuid", (Object)player.getUniqueId().toString());
        }
        if (this.powerPlayer != null) {
            gemsData.set("power_player.uuid", (Object)this.powerPlayer.getUniqueId().toString());
        }
        this.configManager.saveGemData(gemsData);
    }

    @EventHandler
    public void onGemPlaced(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack inHand = event.getItemInHand();
        if (!this.isPowerGem(inHand)) {
            return;
        }
        UUID gemId = this.getGemUUID(inHand);
        if (gemId == null) {
            gemId = UUID.randomUUID();
        }
        Block block = event.getBlockPlaced();
        Location placedLoc = block.getLocation();
        this.gemUuidToHolder.remove(gemId);
        this.locationToGemUuid.put(placedLoc, gemId);
        if (this.checkWinCondition()) {
            if (this.powerPlayer != null) {
                this.revokePermission((CommandSender)this.powerPlayer);
            }
            this.powerPlayer = player;
            ExecuteConfig gemUnionExecute = this.configManager.getGemUnionExecute();
            this.effectUtils.executeCommands(gemUnionExecute, Collections.singletonMap("%player%", player.getName()));
            this.effectUtils.playGlobalSound(gemUnionExecute, 1.0f, 1.0f);
            this.effectUtils.playParticle(placedLoc, gemUnionExecute);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.languageManager.showTitle(p, "gems_recollected", placeholders);
            }
        }
    }

    @EventHandler
    public void onGemBroken(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (this.locationToGemUuid.containsKey(block.getLocation())) {
            UUID gemId = this.locationToGemUuid.get(block.getLocation());
            Player player = event.getPlayer();
            PlayerInventory inv = player.getInventory();
            if (inv.firstEmpty() == -1) {
                this.languageManager.logMessage("inventory_full");
                event.setCancelled(true);
                this.placePowerGem(block.getLocation(), gemId);
            } else {
                ItemStack gemItem = this.createPowerGem(gemId);
                inv.addItem(new ItemStack[]{gemItem});
                this.gemUuidToHolder.put(gemId, player);
                this.unplacePowerGem(block.getLocation(), gemId);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!this.isPowerGem(item)) continue;
            UUID gemId = this.getGemUUID(item);
            inv.remove(item);
            Location loc = player.getLocation();
            this.gemUuidToHolder.remove(gemId);
            this.placePowerGem(loc, gemId);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        UUID gemId = this.getGemUUID(item);
        if (this.isPowerGem(item)) {
            event.getItemDrop().remove();
            this.gemUuidToHolder.remove(gemId);
            this.placePowerGem(event.getItemDrop().getLocation(), gemId);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (!this.isPowerGem(item)) continue;
            UUID gemId = this.getGemUUID(item);
            inv.remove(item);
            this.gemUuidToHolder.remove(gemId);
            Location deathLocation = player.getLocation();
            if (deathLocation == null) continue;
            Location safeLocation = this.findSafeLocationAround(deathLocation, 50, 10);
            if (safeLocation != null) {
                this.placePowerGem(deathLocation, gemId);
                continue;
            }
            this.randomPlaceGem(gemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            UUID gemId;
            if (!this.isPowerGem(item) || this.gemUuidToHolder.containsKey(gemId = this.getGemUUID(item))) continue;
            inv.remove(item);
            this.gemUuidToHolder.remove(gemId);
        }
    }

    public void scatterGems() {
        this.languageManager.logMessage("scatter_start");
        HashSet<Location> locCopy = new HashSet<Location>(this.locationToGemUuid.keySet());
        for (Location loc : locCopy) {
            this.unplacePowerGem(loc, this.locationToGemUuid.get(loc));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerInventory inv = player.getInventory();
            for (ItemStack item : inv.getContents()) {
                if (!this.isPowerGem(item)) continue;
                inv.remove(item);
            }
        }
        this.languageManager.logMessage("gems_recollected");
        for (int i = 0; i < this.configManager.getRequiredCount(); ++i) {
            UUID gemId = UUID.randomUUID();
            this.randomPlaceGem(gemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(this.configManager.getRequiredCount()));
        this.languageManager.logMessage("gems_scattered", placeholders);
        if (this.powerPlayer != null) {
            placeholders.put("player", this.powerPlayer.getName());
            this.powerPlayer = null;
        }
        ExecuteConfig gemScatterExecute = this.configManager.getGemScatterExecute();
        this.effectUtils.executeCommands(gemScatterExecute, placeholders);
        this.effectUtils.playGlobalSound(gemScatterExecute, 1.0f, 1.0f);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.languageManager.showTitle(p, "gems_scattered", placeholders);
        }
        this.saveGems();
    }

    public void gemStatus(CommandSender sender) {
        HashMap<String, Integer> gemHolders = new HashMap<String, Integer>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlayerInventory inv = p.getInventory();
            for (ItemStack item : inv.getContents()) {
                if (!this.isPowerGem(item)) continue;
                if (gemHolders.containsKey(p.getName())) {
                    gemHolders.put(p.getName(), (Integer)gemHolders.get(p.getName()) + 1);
                    continue;
                }
                gemHolders.put(p.getName(), 1);
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(this.configManager.getRequiredCount()));
        placeholders.put("placed_count", String.valueOf(this.locationToGemUuid.size()));
        placeholders.put("held_count", String.valueOf(this.gemUuidToHolder.size()));
        this.languageManager.sendMessage(sender, "gem_status.total_expected", placeholders);
        this.languageManager.sendMessage(sender, "gem_status.total_counts", placeholders);
        for (Location loc : this.locationToGemUuid.keySet()) {
            placeholders = new HashMap();
            placeholders.put("x", String.valueOf(loc.getBlockX()));
            placeholders.put("y", String.valueOf(loc.getBlockY()));
            placeholders.put("z", String.valueOf(loc.getBlockZ()));
            placeholders.put("world", loc.getWorld().getName());
            this.languageManager.sendMessage(sender, "gem_status.gem_location", placeholders);
        }
        for (String p : gemHolders.keySet()) {
            placeholders = new HashMap();
            placeholders.put("player", p);
            placeholders.put("count", String.valueOf(gemHolders.get(p)));
            this.languageManager.sendMessage(sender, "gem_status.player_holding", placeholders);
        }
        for (UUID gemId : this.gemUuidToHolder.keySet()) {
            Player player = this.gemUuidToHolder.get(gemId);
            placeholders = new HashMap();
            placeholders.put("player", player.getName());
            placeholders.put("uuid", gemId.toString());
            this.languageManager.sendMessage(sender, "gem_status.player_gem_uuid", placeholders);
        }
    }

    public boolean isPowerGem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
        return pdc.has(this.powerGemKey, PersistentDataType.BYTE);
    }

    private boolean isPowerGem(Block block) {
        if (block.getType() == this.configManager.getGemMaterial()) {
            Location loc = block.getLocation();
            return this.locationToGemUuid.keySet().contains(loc);
        }
        return false;
    }

    public ItemStack createPowerGem(UUID gemId) {
        ItemStack powerGem = new ItemStack(this.configManager.getGemMaterial(), 1);
        ItemMeta meta = powerGem.getItemMeta();
        meta.setDisplayName(this.configManager.getGemName());
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(this.powerGemKey, PersistentDataType.BYTE, (Object)1);
        pdc.set(this.uniqueIdKey, PersistentDataType.STRING, (Object)gemId.toString());
        powerGem.setItemMeta(meta);
        return powerGem;
    }

    public int getTotalGemCount() {
        return this.locationToGemUuid.size() + this.gemUuidToHolder.size();
    }

    public void placePowerGem(Location loc, UUID gemId) {
        if (this.getTotalGemCount() >= this.configManager.getRequiredCount()) {
            this.languageManager.logMessage("gem_limit_reached");
            return;
        }
        Block block = loc.getBlock();
        if (block.getType().isSolid()) {
            loc.add(0.0, 1.0, 0.0);
        }
        if (!this.isSafeLocation(loc)) {
            loc = this.findSafeLocationAround(loc, 10, 10);
        }
        if (loc == null) {
            this.randomPlaceGem(gemId, this.configManager.getRandomPlaceCorner1(), this.configManager.getRandomPlaceCorner2());
        }
        loc.getBlock().setType(this.configManager.getGemMaterial());
        this.locationToGemUuid.put(loc, gemId);
    }

    public void unplacePowerGem(Location loc, UUID gemId) {
        loc.getBlock().setType(Material.AIR);
        this.locationToGemUuid.remove(loc, gemId);
    }

    private void randomPlaceGem(UUID gemId, Location corner1, Location corner2) {
        Location loc = this.findSafeLocation(corner1, corner2, 10);
        if (loc != null) {
            this.placePowerGem(loc, gemId);
        }
    }

    private boolean isSafeLocation(Location loc) {
        WorldBorder border = loc.getWorld().getWorldBorder();
        int maxHeight = loc.getWorld().getMaxHeight();
        int minHeight = loc.getWorld().getMinHeight();
        if (!border.isInside(loc)) {
            return false;
        }
        if (loc.getBlockY() < minHeight || loc.getBlockY() > maxHeight) {
            return false;
        }
        Block block = loc.getBlock();
        return block.getType() == Material.AIR && !this.locationToGemUuid.keySet().contains(loc);
    }

    private Location findSafeLocationAround(Location startLoc, int radius, int maxAttempts) {
        Location corner1 = new Location(startLoc.getWorld(), (double)(startLoc.getBlockX() - radius), (double)(startLoc.getBlockY() - radius), (double)(startLoc.getBlockZ() - radius));
        Location corner2 = new Location(startLoc.getWorld(), (double)(startLoc.getBlockX() + radius), (double)(startLoc.getBlockY() + radius), (double)(startLoc.getBlockZ() + radius));
        return this.findSafeLocation(corner1, corner2, maxAttempts);
    }

    private Location findSafeLocation(Location corner1, Location corner2, int maxAttempts) {
        if (corner1.getWorld() != corner2.getWorld()) {
            this.plugin.getLogger().warning("\u4e24\u4e2a\u89d2\u843d\u7684\u4e16\u754c\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u9009\u62e9\u4f4d\u7f6e\u3002");
            return null;
        }
        World world = corner1.getWorld();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        Random rand = new Random();
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            int z;
            int y;
            int x = rand.nextInt(maxX - minX + 1) + minX;
            Location loc = new Location(world, (double)x, (double)(y = world.getHighestBlockYAt(x, z = rand.nextInt(maxZ - minZ + 1) + minZ) + 1), (double)z);
            if (!this.isSafeLocation(loc)) continue;
            return loc;
        }
        return null;
    }

    public void startParticleEffectTask(final Particle particle) {
        new BukkitRunnable(){

            public void run() {
                for (Location loc : GemManager.this.locationToGemUuid.keySet()) {
                    World world = loc.getWorld();
                    if (world == null) continue;
                    world.spawnParticle(particle, loc, 1);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void checkPlayersNearPowerGems() {
        if (this.locationToGemUuid.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location playerLoc = player.getLocation();
            World playerWorld = playerLoc.getWorld();
            for (Location blockLoc : this.locationToGemUuid.keySet()) {
                double distance;
                if (!blockLoc.getWorld().equals(playerWorld) || !((distance = playerLoc.distance(blockLoc)) < 16.0)) continue;
                float volume = (float)(1.0 - distance / 16.0);
                float pitch = 1.0f;
                player.playSound(playerLoc, this.configManager.getGemSound(), volume, pitch);
            }
        }
    }

    private boolean checkWinCondition() {
        if (this.locationToGemUuid.size() < this.configManager.getRequiredCount()) {
            return false;
        }
        if (this.configManager.isUseRequiredLoc()) {
            for (Location loc : this.locationToGemUuid.keySet()) {
                if (this.isInCube(loc, this.configManager.getRequiredLocCenter(), this.configManager.getRequiredLocRadius())) continue;
                return false;
            }
            return true;
        }
        return this.isAllConnected(this.locationToGemUuid.keySet());
    }

    public boolean isAllConnected(Set<Location> locations) {
        if (locations.size() <= 1) {
            return true;
        }
        Location start = locations.iterator().next();
        int visitedCount = this.bfsCount(start, locations);
        return visitedCount == locations.size();
    }

    private int bfsCount(Location start, Set<Location> locations) {
        LinkedList<Location> queue = new LinkedList<Location>();
        HashSet<Location> visited = new HashSet<Location>();
        queue.offer(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Location current = (Location)queue.poll();
            for (Location neighbor : this.getNeighbors(current)) {
                if (!locations.contains(neighbor) || visited.contains(neighbor)) continue;
                visited.add(neighbor);
                queue.offer(neighbor);
            }
        }
        return visited.size();
    }

    private List<Location> getNeighbors(Location loc) {
        ArrayList<Location> neighbors = new ArrayList<Location>(6);
        neighbors.add(loc.clone().add(0.0, 1.0, 0.0));
        neighbors.add(loc.clone().add(0.0, -1.0, 0.0));
        neighbors.add(loc.clone().add(0.0, 0.0, 1.0));
        neighbors.add(loc.clone().add(0.0, 0.0, -1.0));
        neighbors.add(loc.clone().add(1.0, 0.0, 0.0));
        neighbors.add(loc.clone().add(-1.0, 0.0, 0.0));
        return neighbors;
    }

    private boolean isInCube(Location loc, Location center, double radius) {
        if (!loc.getWorld().equals(center.getWorld())) {
            return false;
        }
        double dx = Math.abs(loc.getX() - center.getX());
        double dy = Math.abs(loc.getY() - center.getY());
        double dz = Math.abs(loc.getZ() - center.getZ());
        return dx <= radius && dy <= radius && dz <= radius;
    }

    public void revokePermission(CommandSender sender) {
        if (this.powerPlayer == null) {
            this.languageManager.sendMessage(sender, "command.revoke.no_power_player");
            return;
        }
        ExecuteConfig revokeExecute = this.configManager.getPowerRevokeExecute();
        this.effectUtils.executeCommands(revokeExecute, Collections.singletonMap("%player%", this.powerPlayer.getName()));
        this.effectUtils.playGlobalSound(revokeExecute, 1.0f, 1.0f);
        if (this.powerPlayer.isOnline()) {
            this.effectUtils.playParticle(this.powerPlayer.getLocation(), revokeExecute);
            this.languageManager.sendMessage((CommandSender)this.powerPlayer, "command.revoke.success", Collections.singletonMap("player", this.powerPlayer.getName()));
        }
        this.powerPlayer = null;
        this.saveGems();
    }

    public UUID getGemUUID(ItemStack item) {
        if (!this.isPowerGem(item)) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        String uuidStr = (String)pdc.get(this.uniqueIdKey, PersistentDataType.STRING);
        if (uuidStr == null) {
            return null;
        }
        return UUID.fromString(uuidStr);
    }

    public UUID getGemUUID(Block block) {
        if (!this.isPowerGem(block)) {
            return null;
        }
        Location loc = block.getLocation();
        return this.locationToGemUuid.get(loc);
    }

    public Player getPowerPlayer() {
        return this.powerPlayer;
    }
}

