/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.manager;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import me.hushu.PowerGem;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LanguageManager {
    private final PowerGem plugin;
    private String language;
    private FileConfiguration langConfig;
    private String prefix;

    public LanguageManager(PowerGem plugin) {
        this.plugin = plugin;
    }

    private void copyLangFileIfNotExists(String lang) {
        File outFile = new File(this.plugin.getDataFolder(), "local/" + lang + ".yml");
        this.plugin.saveResource("local/" + lang + ".yml", false);
    }

    public void loadLanguage() {
        this.language = this.plugin.getConfig().getString("language", "zh");
        this.loadLangConfig(this.language);
        if (this.langConfig == null) {
            this.language = "zh";
            this.copyLangFileIfNotExists("zh");
            this.loadLangConfig("zh");
        }
        this.prefix = this.langConfig.getString("prefix", "&7[&6PowerGem&7] ");
    }

    private void loadLangConfig(String lang) {
        this.copyLangFileIfNotExists(this.language);
        File langFile = new File(this.plugin.getDataFolder(), "local/" + lang + ".yml");
        if (langFile.exists()) {
            this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        }
    }

    public String getMessage(String path) {
        return this.getMessage(path, this.language);
    }

    public String getMessage(String path, String lang) {
        if (this.langConfig == null) {
            return "Missing language file: " + lang;
        }
        String message = this.langConfig.getString(path);
        return message != null ? message : "Missing message: " + path;
    }

    public String formatMessage(String path, Map<String, String> placeholders) {
        return this.formatMessage(path, this.language, placeholders);
    }

    public String formatMessage(String path, String lang, Map<String, String> placeholders) {
        String message = this.getMessage(path, lang);
        if ((message = this.formatText(message, placeholders)) != null) {
            message = message.replace("%prefix%", this.prefix);
        }
        return message;
    }

    public String formatText(String message, Map<String, String> placeholders) {
        if (placeholders != null) {
            for (String key : placeholders.keySet()) {
                message = message.replace("%" + key + "%", placeholders.get(key));
            }
        }
        return message;
    }

    public void sendMessage(CommandSender sender, String path) {
        this.sendMessage(sender, path, new HashMap<String, String>());
    }

    public void sendMessage(CommandSender sender, String path, Map<String, String> placeholders) {
        String message = this.formatMessage("messages." + path, placeholders);
        sender.sendMessage(this.translateColorCodes(message));
    }

    public void logMessage(String path) {
        this.logMessage("logger." + path, new HashMap<String, String>());
    }

    public void logMessage(String path, Map<String, String> placeholders) {
        Logger logger = this.plugin.getLogger();
        String message = this.formatMessage(path, placeholders);
        logger.info(this.translateColorCodes(message));
    }

    private String translateColorCodes(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getLanguage() {
        return this.language;
    }

    public void showTitle(Player player, String path, Map<String, String> placeholders) {
        if (this.langConfig == null) {
            return;
        }
        List titleMessages = this.langConfig.getStringList("title." + path);
        if (titleMessages.size() == 1) {
            player.sendTitle(this.translateColorCodes(this.formatText((String)titleMessages.get(0), placeholders)), null, 10, 70, 20);
        } else if (titleMessages.size() == 2) {
            player.sendTitle(this.translateColorCodes(this.formatText((String)titleMessages.get(0), placeholders)), this.translateColorCodes(this.formatText((String)titleMessages.get(1), placeholders)), 10, 70, 20);
        }
    }
}

