/*
 * Decompiled with CFR 0.152.
 */
package me.hushu.utils;

import java.util.List;
import java.util.Map;
import me.hushu.PowerGem;
import me.hushu.model.ExecuteConfig;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EffectUtils {
    private final PowerGem plugin;

    public EffectUtils(PowerGem plugin) {
        this.plugin = plugin;
    }

    public void executeCommands(ExecuteConfig execCfg, Map<String, String> placeholders) {
        List<String> commands = execCfg.getCommands();
        if (commands == null || commands.isEmpty()) {
            return;
        }
        for (String cmd : commands) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                String placeholder = entry.getKey();
                String value = entry.getValue();
                cmd = cmd.replace(placeholder, value);
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
    }

    public void playGlobalSound(ExecuteConfig execCfg, float volume, float pitch) {
        if (execCfg.getSound() != null) {
            try {
                Sound sound = Sound.valueOf((String)execCfg.getSound());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.playSound(p.getLocation(), sound, volume, pitch);
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("[PowerGem] \u65e0\u6548\u7684\u97f3\u6548\u540d\u79f0: " + execCfg.getSound());
            }
        }
    }

    public void playLocalSound(Location location, ExecuteConfig execCfg, float volume, float pitch) {
        if (execCfg.getSound() != null) {
            try {
                Sound sound = Sound.valueOf((String)execCfg.getSound());
                location.getWorld().playSound(location, sound, volume, pitch);
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("[PowerGem] \u65e0\u6548\u7684\u97f3\u6548\u540d\u79f0: " + execCfg.getSound());
            }
        }
    }

    public void playParticle(Location location, ExecuteConfig execCfg) {
        if (execCfg.getParticle() != null) {
            try {
                Particle particle = Particle.valueOf((String)execCfg.getParticle());
                location.getWorld().spawnParticle(particle, location, 1);
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("[PowerGem] \u65e0\u6548\u7684\u7c92\u5b50\u540d\u79f0: " + execCfg.getParticle());
            }
        }
    }
}

