/*
 * Decompiled with CFR 0.152.
 */
package com.zhengzhengyiyimc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class PythonScriptManager {
    private static final String PYTHON_SCRIPT = "# generated by zhengzhengyiyimc\n\nimport ollama\nfrom argparse import ArgumentParser\n\ndef ask_ollama(prompt):\n    response = ollama.chat(\n        model=\"tinyllama\",\n        # format=\"json\",\n        messages=[\n            {\"role\": \"system\", \"content\": f\"You are an AI assisstant in Minecraft {version} by using a Minecraft JAVA mod, your name is ollama. Please answer it detaily. Try to get the point of the question, using simple language, and make your answer short. Do not talk about Minecraft download, and only talk about Minecraft.\"},\n            {\"role\": \"user\", \"content\": prompt}\n        ],\n    )\n    return response[\"message\"][\"content\"]\n\nif __name__ == '__main__':\n    parser = ArgumentParser(\"Run pretrained models on MineRL environment\")\n\n    parser.add_argument(\"--version\", type=str, required=True, help=\"pass into the Minecraft version\")\n    parser.add_argument(\"--prompt\", type=str, required=True, help=\"the thing that need to ask to ai\")\n\n    args = parser.parse_args()\n\n    version = args.version\n    prompt = args.prompt\n\n    print(ask_ollama(prompt), flush=True)\n";

    public static void ensurePythonScriptExists(Path scriptPath) throws IOException {
        Files.createDirectories(scriptPath.getParent(), new FileAttribute[0]);
        Files.writeString(scriptPath, (CharSequence)PYTHON_SCRIPT, StandardOpenOption.CREATE_NEW);
        System.out.println("python script made in: " + String.valueOf(scriptPath));
    }

    public static boolean checkScriptExists(Path scriptPath) {
        return Files.exists(scriptPath, new LinkOption[0]) && Files.isRegularFile(scriptPath, new LinkOption[0]);
    }
}

