/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.minecartspawnerrevived.fabric;

import com.mojang.serialization.DynamicOps;
import com.stevekung.minecartspawnerrevived.MinecartSpawnerRevived;
import com.stevekung.minecartspawnerrevived.RequestSpawnDataPacket;
import com.stevekung.minecartspawnerrevived.SendSpawnDataPacket;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1699;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class MinecartSpawnerRevivedFabric {
    public static void init() {
        MinecartSpawnerRevived.init();
        PayloadTypeRegistry.playC2S().register(RequestSpawnDataPacket.TYPE, RequestSpawnDataPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SendSpawnDataPacket.TYPE, SendSpawnDataPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestSpawnDataPacket.TYPE, MinecartSpawnerRevivedFabric::requestSpawnData);
    }

    public static void requestSpawnData(RequestSpawnDataPacket packet, ServerPlayNetworking.Context context) {
        int entityId = packet.entityId();
        class_3222 player = context.player();
        context.server().execute(() -> {
            class_1699 spawner = (class_1699)player.method_51469().method_8469(entityId);
            if (spawner != null) {
                class_1937 level = spawner.method_73183();
                MinecartSpawnerRevivedFabric.sendSpawnDataPacket(player, entityId, spawner.method_35216().method_46404(level, level.method_8409(), spawner.method_24515()));
            }
        });
    }

    public static void sendSpawnDataPacket(class_3222 player, int entityId, class_1952 spawnData) {
        if (spawnData.comp_64().method_33133()) {
            return;
        }
        class_2487 compound = new class_2487();
        compound.method_10566("SpawnData", (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)spawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)MinecartSpawnerRevived.SEND_SPAWNDATA)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SendSpawnDataPacket(entityId, compound));
        }
    }
}

