/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.stickynotes.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import io.github.dimaskama.stickynotes.client.Note;
import io.github.dimaskama.stickynotes.client.StickyNotes;
import io.github.dimaskama.stickynotes.client.screen.NotesListScreen;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4668;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class NotesManager {
    public static final double CLAMP_DIST = 16.0;
    public static final double CLAMP_SQUARED_DIST = 256.0;
    private static final float SIZE_IN_WORLD = 0.5f;
    private static final float HALF_SIZE_IN_WORLD = 0.25f;
    private static final class_1921 RENDER_LAYER = class_1921.method_24048((String)"stickynotes", (int)1536, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60655((String)"stickynotes", (String)"stickynotes")).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(class_2960.method_60656((String)"textures/atlas/map_decorations.png"), false)).method_23617(false));
    private static final class_1921 RENDER_LAYER_SEE_THROUGH = class_1921.method_24048((String)"stickynotes_see_through", (int)1536, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60655((String)"stickynotes", (String)"stickynotes_see_through")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(class_2960.method_60656((String)"textures/atlas/map_decorations.png"), false)).method_23617(false));
    @Nullable
    private Note targetedNote;
    private int noteTargetTime;

    public void tick(class_310 client) {
        class_1297 camera = client.method_1560();
        class_239 hitResult = client.field_1765;
        List<Note> notes = StickyNotes.getCurrentWorldNotes();
        Note targeted = null;
        if (camera != null && notes != null && !notes.isEmpty() && hitResult != null) {
            class_243 pos = camera.method_5836(1.0f);
            double hitLen = hitResult.method_17784().method_1020(pos).method_1027();
            boolean raycastedHitFar = hitResult.method_17783() != class_239.class_240.field_1333;
            class_243 raycastVec = camera.method_5720().method_1021(50.0);
            class_243 raycastPos = raycastVec.method_1019(pos);
            for (Note note : notes) {
                double len;
                Optional optional = (note.seeThrough ? note.getClampedBox(pos) : note.getBox()).method_992(pos, raycastPos);
                if (optional.isEmpty()) continue;
                if (!note.seeThrough && (len = ((class_243)optional.get()).method_1020(pos).method_1027()) > hitLen) {
                    if (raycastedHitFar) continue;
                    hitLen = Note.raycastPos(camera).method_1020(pos).method_1027();
                    raycastedHitFar = true;
                    if (len > hitLen) continue;
                }
                targeted = note;
                break;
            }
        }
        this.noteTargetTime = targeted == this.targetedNote ? this.noteTargetTime + 1 : 0;
        this.targetedNote = targeted;
        if (StickyNotes.OPEN_NOTES_LIST_KEY.method_1434() && notes != null) {
            client.method_1507((class_437)new NotesListScreen(client.field_1755, notes, true));
        }
    }

    public void renderAfterEntities(class_12075 camera, class_11659 queue) {
        NotesManager.renderNotes(camera, queue, StickyNotes.getCurrentWorldNotes(), false);
    }

    public void renderLast(class_12075 camera, class_11659 queue) {
        NotesManager.renderNotes(camera, queue, StickyNotes.getCurrentWorldNotes(), true);
    }

    private static void renderNotes(class_12075 camera, class_11659 queue, List<Note> notes, boolean seeThrough) {
        if (notes == null || notes.isEmpty()) {
            return;
        }
        class_1921 renderLayer = seeThrough ? RENDER_LAYER_SEE_THROUGH : RENDER_LAYER;
        class_4587 matrices = new class_4587();
        class_1059 atlas = class_310.method_1551().method_72703().method_73025(class_10725.field_56386);
        float viewDistanceSq = class_3532.method_27285((float)(class_310.method_1551().field_1773.method_3193() * 2.0f));
        class_4184 cameraObj = class_310.method_1551().field_1773.method_19418();
        Quaternionf rotation = new Quaternionf().rotationYXZ((float)Math.PI / 180 * (180.0f - cameraObj.method_19330()), (float)Math.PI / 180 * (-cameraObj.method_19329() * 0.4f), 0.0f);
        for (Note note : notes) {
            if (note.seeThrough != seeThrough || !seeThrough && (double)viewDistanceSq < note.pos.method_1020(camera.field_63078).method_1027()) continue;
            class_243 relPos = seeThrough ? note.getClampedRelativePos(camera.field_63078) : note.pos.method_1020(camera.field_63078);
            matrices.method_22903();
            matrices.method_22904(relPos.field_1352, relPos.field_1351, relPos.field_1350);
            matrices.method_22907((Quaternionfc)rotation);
            matrices.method_22904(-relPos.field_1352, -relPos.field_1351, -relPos.field_1350);
            float x1 = (float)relPos.field_1352 - 0.25f;
            float y1 = (float)relPos.field_1351 + 0.5f;
            float x2 = x1 + 0.5f;
            float y2 = (float)relPos.field_1351;
            float z = (float)relPos.field_1350;
            class_1058 sprite = atlas.method_4608(note.icon);
            float u1 = sprite.method_4594();
            float v1 = sprite.method_4593();
            float u2 = sprite.method_4577();
            float v2 = sprite.method_4575();
            queue.method_73483(matrices, renderLayer, (matrix, consumer) -> {
                consumer.method_56824(matrix, x1, y1, z).method_22913(u1, v1).method_39415(-1);
                consumer.method_56824(matrix, x1, y2, z).method_22913(u1, v2).method_39415(-1);
                consumer.method_56824(matrix, x2, y2, z).method_22913(u2, v2).method_39415(-1);
                consumer.method_56824(matrix, x2, y1, z).method_22913(u2, v1).method_39415(-1);
            });
            matrices.method_22909();
        }
    }

    public void renderHud(class_332 context, class_9779 tickCounter) {
        int descAlphaMask;
        int nameAlphaMask;
        Note note = this.targetedNote;
        if (note == null || class_310.method_1551().method_74187()) {
            return;
        }
        int time = this.noteTargetTime;
        float delta = tickCounter.method_60637(false);
        int n = nameAlphaMask = time < 10 ? (int)(class_3532.method_15363((float)(((float)(time - 6) + delta) / 4.0f), (float)0.0f, (float)1.0f) * 255.0f) : 255;
        if (nameAlphaMask < 4) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        int x = (context.method_51421() >>> 1) + 5;
        int y = (context.method_51443() >>> 1) + 5;
        context.method_27535(textRenderer, note.name, x, y, nameAlphaMask << 24 | 0xFFFFFF);
        y += 15;
        int n2 = descAlphaMask = time < 30 ? (int)(class_3532.method_15363((float)(((float)(time - 26) + delta) / 4.0f), (float)0.0f, (float)1.0f) * 255.0f) : 255;
        if (descAlphaMask < 4) {
            return;
        }
        context.method_51440(textRenderer, (class_5348)note.description, x, y, Math.max((int)((float)(context.method_51421() >>> 1) * 0.8f), 80), descAlphaMask << 24 | 0xFFFFFF, false);
    }
}

