/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.stickynotes.client.screen;

import io.github.dimaskama.stickynotes.client.Note;
import io.github.dimaskama.stickynotes.mixin.SpriteAtlasTextureAccessor;
import java.util.function.DoubleConsumer;
import net.minecraft.class_1047;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class NoteEditScreen
extends class_437 {
    private static final int WIDTH = 270;
    private final class_437 parent;
    private final Note note;
    private class_342 nameWidget;
    private class_342 descWidget;
    private boolean nameDirty;
    private boolean descDirty;
    private boolean posDirty;
    private double noteX;
    private double noteY;
    private double noteZ;
    private class_2960 hoveredIcon = null;

    public NoteEditScreen(@Nullable class_437 parent, Note note, boolean edit) {
        super((class_2561)class_2561.method_43471((String)(edit ? "stickynotes.edit_note" : "stickynotes.add_note")));
        this.parent = parent;
        this.note = note;
    }

    protected void method_25426() {
        this.noteX = this.note.pos.field_1352;
        this.noteY = this.note.pos.field_1351;
        this.noteZ = this.note.pos.field_1350;
        int left = this.field_22789 - 270 >> 1;
        int top = this.field_22790 >>> 2;
        class_5250 nameText = class_2561.method_43471((String)"stickynotes.note_name");
        int nameWidth = this.field_22793.method_27525((class_5348)nameText);
        this.method_37063((class_364)new class_7842(left, top + 5, nameWidth, 9, (class_2561)nameText, this.field_22793));
        if (this.nameWidget == null) {
            this.nameWidget = new class_342(this.field_22793, left + nameWidth + 4, top, 270 - (nameWidth + 4), 20, class_5244.field_39003);
            this.nameWidget.method_1852(this.note.name.getString());
            this.nameWidget.method_1863(s -> {
                this.nameDirty = true;
            });
        }
        this.method_37063((class_364)this.nameWidget);
        class_5250 descText = class_2561.method_43471((String)"stickynotes.note_desc");
        int descWidth = this.field_22793.method_27525((class_5348)descText);
        this.method_37063((class_364)new class_7842(left, top + 25 + 5, descWidth, 9, (class_2561)descText, this.field_22793));
        if (this.descWidget == null) {
            this.descWidget = new class_342(this.field_22793, left + descWidth + 4, top + 25, 270 - (descWidth + 4), 20, class_5244.field_39003);
            this.descWidget.method_1852(this.note.description.getString());
            this.descWidget.method_1880(256);
            this.descWidget.method_1863(s -> {
                this.descDirty = true;
            });
        }
        this.method_37063((class_364)this.descWidget);
        int iconsInRow = 27;
        int i = 0;
        for (class_2960 icon : ((SpriteAtlasTextureAccessor)this.field_22787.method_72703().method_73025(class_10725.field_56386)).stickynotes_getSprites().keySet()) {
            if (icon.equals((Object)class_1047.method_4539())) continue;
            this.method_37063((class_364)new IconButton(left + i % iconsInRow * 10, top + 50 + i / iconsInRow * 10, 10, icon));
            ++i;
        }
        class_5250 posText = class_2561.method_43471((String)"stickynotes.note_pos");
        int posWidth = this.field_22793.method_27525((class_5348)posText);
        this.method_37063((class_364)new class_7842(left, top + 75 + 5, posWidth, 9, (class_2561)posText, this.field_22793));
        int ww = (270 - posWidth - 4 - 50) / 3;
        this.addPosField(left + posWidth + 4, top + 75, ww, "X", this.noteX, d -> {
            this.noteX = d;
        });
        this.addPosField(left + posWidth + 4 + ww, top + 75, ww, "Y", this.noteY, d -> {
            this.noteY = d;
        });
        this.addPosField(left + posWidth + 4 + ww + ww, top + 75, ww, "Z", this.noteZ, d -> {
            this.noteZ = d;
        });
        boolean inWorld = this.field_22787.method_1560() != null;
        SquareButton moveToPlayerButton = new SquareButton(left + 270 - 45, top + 75, 0, () -> {
            class_1297 camera = this.field_22787.method_1560();
            if (camera == null) {
                return;
            }
            this.note.pos = camera.method_73189();
            this.method_41843();
        });
        moveToPlayerButton.field_22763 = inWorld;
        if (inWorld) {
            moveToPlayerButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"stickynotes.move_to_player")));
        }
        this.method_37063((class_364)moveToPlayerButton);
        SquareButton moveToLookPosButton = new SquareButton(left + 270 - 20, top + 75, 1, () -> {
            class_1297 camera = this.field_22787.method_1560();
            if (camera == null) {
                return;
            }
            this.note.pos = Note.raycastPos(camera);
            this.method_41843();
        });
        moveToLookPosButton.field_22763 = inWorld;
        if (inWorld) {
            moveToLookPosButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"stickynotes.move_to_look_pos")));
        }
        this.method_37063((class_364)moveToLookPosButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43469((String)"stickynotes.note_see_through", (Object[])new Object[]{this.boolText(this.note.seeThrough)}), button -> {
            this.note.seeThrough = !this.note.seeThrough;
            button.method_25355((class_2561)class_2561.method_43469((String)"stickynotes.note_see_through", (Object[])new Object[]{this.boolText(this.note.seeThrough)}));
        }).method_46434(left, top + 100, 270, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 - 80 >> 1, top + 135, 80, 20).method_46431());
    }

    private class_2561 boolText(boolean bool) {
        return bool ? class_5244.field_24332 : class_5244.field_24333;
    }

    private void addPosField(int x, int y, int width, String title, double value, DoubleConsumer consumer) {
        class_342 field = new class_342(this.field_22793, x, y, width, 20, class_5244.field_39003);
        field.method_1852(String.format("%.2f", value).replace(',', '.'));
        field.method_47404((class_2561)class_2561.method_43470((String)title));
        field.method_1863(string -> {
            this.posDirty = true;
            boolean changed = false;
            while (!string.isBlank()) {
                try {
                    consumer.accept(Double.parseDouble(string));
                    if (changed) {
                        field.method_1852(string);
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    string = string.substring(0, string.length() - 1);
                    changed = true;
                }
            }
            if (changed) {
                field.method_1852(string);
            }
            consumer.accept(0.0);
        });
        this.method_37063((class_364)field);
    }

    public void method_25432() {
        if (this.nameDirty) {
            this.note.name = class_2561.method_43470((String)this.nameWidget.method_1882());
        }
        if (this.descDirty) {
            this.note.description = class_2561.method_43470((String)this.descWidget.method_1882());
        }
        if (this.posDirty) {
            this.note.pos = new class_243(this.noteX, this.noteY, this.noteZ);
        }
        this.note.update();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 >>> 1, this.field_22790 / 20 - 5, -1);
        class_2960 icon = this.hoveredIcon != null ? this.hoveredIcon : this.note.icon;
        int iconSize = this.field_22790 / 10;
        Note.draw(context, this.field_22789 - iconSize >> 1, iconSize, iconSize, iconSize, icon);
        this.hoveredIcon = null;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private class IconButton
    extends class_339 {
        public final class_2960 icon;

        public IconButton(int x, int y, int sideSize, class_2960 icon) {
            super(x, y, sideSize, sideSize, class_5244.field_39003);
            this.icon = icon;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            if (this.method_49606()) {
                NoteEditScreen.this.hoveredIcon = this.icon;
            }
            Note.draw(context, this.method_46426() + 1, this.method_46427() + 1, this.method_25368() - 2, this.method_25364() - 2, this.icon);
            if (this.method_49606()) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x40FFFFFF);
            }
        }

        public void method_25348(class_11909 click, boolean doubled) {
            NoteEditScreen.this.note.icon = this.icon;
        }

        protected void method_47399(class_6382 builder) {
            this.method_37021(builder);
        }
    }

    private static class SquareButton
    extends class_339 {
        private static final class_2960 BUTTONS_TEXTURE = class_2960.method_60655((String)"stickynotes", (String)"textures/gui/buttons.png");
        private final Runnable clickAction;
        private final int u;

        public SquareButton(int x, int y, int texture, Runnable clickAction) {
            super(x, y, 20, 20, class_5244.field_39003);
            this.clickAction = clickAction;
            this.u = texture * 20;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25290(class_10799.field_56883, BUTTONS_TEXTURE, this.method_46426(), this.method_46427(), (float)this.u, this.field_22763 ? (this.method_49606() ? 20.0f : 0.0f) : 40.0f, 20, 20, 64, 64);
        }

        public void method_25348(class_11909 click, boolean doubled) {
            this.clickAction.run();
        }

        protected void method_47399(class_6382 builder) {
            this.method_37021(builder);
        }
    }
}

