/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.stickynotes.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.dimaskama.stickynotes.client.Note;
import io.github.dimaskama.stickynotes.config.JsonConfig;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;

public class NotesConfig
extends JsonConfig<Data> {
    public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Note.CODEC.listOf()).fieldOf("world_to_map").forGetter(d -> Multimaps.asMap(d.worldToNotes))).apply((Applicative)instance, Data::new));
    private boolean dirty;

    public NotesConfig(String path) {
        super(path);
    }

    @Override
    protected Codec<Data> getCodec() {
        return CODEC;
    }

    @Override
    protected Data createDefaultData() {
        return new Data(Map.of());
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void onClientStopping(class_310 client) {
        this.saveIfDirty(false);
    }

    public void saveIfDirty(boolean log) {
        if (this.dirty) {
            this.save(log);
            this.dirty = false;
        }
    }

    public static class Data {
        public ArrayListMultimap<String, Note> worldToNotes = ArrayListMultimap.create();

        public Data(Map<String, List<Note>> map) {
            map.forEach((key, value) -> this.worldToNotes.putAll(key, (Iterable)value));
        }
    }
}

