/*
 * Decompiled with CFR 0.152.
 */
package io.github.dimaskama.stickynotes.client.screen;

import com.google.common.collect.ArrayListMultimap;
import io.github.dimaskama.stickynotes.client.Note;
import io.github.dimaskama.stickynotes.client.StickyNotes;
import io.github.dimaskama.stickynotes.client.screen.NotesListScreen;
import io.github.dimaskama.stickynotes.config.NotesConfig;
import io.github.dimaskama.stickynotes.mixin.ClickableWidgetInvoker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class WorldsNotesList
extends class_4265<Entry> {
    private final class_437 screen;

    public WorldsNotesList(class_310 client, int width, int height, int y, class_437 screen) {
        super(client, width, height, y, 32);
        this.screen = screen;
    }

    public void init() {
        this.method_25339();
        ArrayListMultimap<String, Note> map = ((NotesConfig.Data)StickyNotes.CONFIG.getData()).worldToNotes;
        String currentId = StickyNotes.getCurrentWorldId();
        List<Note> currentList = StickyNotes.getCurrentWorldNotes();
        map.keySet().forEach(key -> this.method_25321((class_350.class_351)new Entry((String)key, map.get(key), (Consumer<List<Note>>)(currentList == null || key.equals(currentId) ? null : list -> {
            currentList.addAll((Collection<Note>)list);
            StickyNotes.CONFIG.markDirty();
        }))));
    }

    public int method_25322() {
        return 320;
    }

    public class Entry
    extends class_4265.class_4266<Entry> {
        private final class_2561 keyText;
        private final List<class_4185> buttons;
        private final int buttonsWidth;

        public Entry(String key, @Nullable List<Note> notes, Consumer<List<Note>> copyAction) {
            this.keyText = class_2561.method_43470((String)key);
            class_327 textRenderer = class_310.method_1551().field_1772;
            ArrayList<class_4185> list = new ArrayList<class_4185>();
            int widthCount = 0;
            if (copyAction != null) {
                class_5250 copyText = class_2561.method_43471((String)"stickynotes.world_notes_list.copy");
                int copyWidth = textRenderer.method_27525((class_5348)copyText) + 8;
                class_4185 copy = class_4185.method_46430((class_2561)copyText, button -> copyAction.accept(notes)).method_46437(copyWidth, 16).method_46431();
                copy.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"stickynotes.world_notes_list.copy.tooltip")));
                list.add(copy);
                widthCount += copyWidth + 2;
            }
            class_5250 editText = class_2561.method_43471((String)"stickynotes.world_notes_list.edit");
            int editWidth = textRenderer.method_27525((class_5348)editText) + 8;
            class_4185 editButton = class_4185.method_46430((class_2561)editText, button -> class_310.method_1551().method_1507((class_437)new NotesListScreen(WorldsNotesList.this.screen, notes, false))).method_46437(editWidth, 16).method_46431();
            list.add(editButton);
            widthCount += editWidth + 2;
            class_5250 deleteText = class_2561.method_43471((String)"stickynotes.world_notes_list.delete");
            int deleteWidth = textRenderer.method_27525((class_5348)deleteText) + 8;
            class_4185 deleteButton = class_4185.method_46430((class_2561)deleteText, button -> {
                notes.clear();
                StickyNotes.CONFIG.markDirty();
                WorldsNotesList.this.init();
            }).method_46437(deleteWidth, 16).method_46431();
            list.add(deleteButton);
            this.buttons = List.copyOf(list);
            this.buttonsWidth = widthCount += deleteWidth + 2;
        }

        public List<? extends class_6379> method_37025() {
            return this.buttons;
        }

        public List<? extends class_364> method_25396() {
            return this.buttons;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            context.method_25294(x, y, x + entryWidth, y + entryHeight, hovered ? 0x50FFFFFF : 0x20FFFFFF);
            class_327 textRenderer = class_310.method_1551().field_1772;
            int textX = x + 8;
            int textY = y + (entryHeight - 10 >> 1);
            int freeTextWidth = entryWidth - this.buttonsWidth - 8 - 8;
            if (freeTextWidth >= textRenderer.method_27525((class_5348)this.keyText)) {
                context.method_27535(textRenderer, this.keyText, textX, textY, -1);
            } else {
                ClickableWidgetInvoker.stickynotes_drawScrollableText(context, textRenderer, this.keyText, textX, textY, textX + freeTextWidth, textY + 10, -1);
            }
            int buttonX = x + entryWidth - this.buttonsWidth;
            int buttonY = y + (entryHeight - 16 >> 1);
            for (class_4185 button : this.buttons) {
                button.method_48229(buttonX, buttonY);
                button.method_25394(context, mouseX, mouseY, delta);
                buttonX += button.method_25368() + 2;
            }
        }
    }
}

