/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.bettertab.tabs;

import dev.anvilcraft.rg.bettertab.tabs.Tab;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import org.jetbrains.annotations.NotNull;

public class MobcapsTab
implements Tab {
    private static final MobCategory[] CACHED_MOBCATEGORY_VALUES = MobCategory.values();
    public static final HashMap<ResourceKey<Level>, Integer> CHUNK_COUNTS = new HashMap();
    public static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);

    @Override
    @NotNull
    public Component getMsg(@NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        ServerLevel serverLevel = player.level();
        if (!(serverLevel instanceof ServerLevel)) {
            return Component.empty();
        }
        ServerLevel level = serverLevel;
        ResourceKey dimension = level.dimension();
        NaturalSpawner.SpawnState lastSpawner = level.getChunkSource().getLastSpawnState();
        Object2IntMap dimCounts = null;
        if (lastSpawner != null) {
            dimCounts = lastSpawner.getMobCategoryCounts();
        }
        int chunkCount = CHUNK_COUNTS.getOrDefault(dimension, -1);
        if (dimCounts == null || chunkCount < 0) {
            MutableComponent component = Component.literal((String)"--UNAVAILABLE--").withStyle(ChatFormatting.GRAY);
            return component;
        }
        MutableComponent literal = Component.literal((String)"");
        int length = 0;
        for (MobCategory category : MobcapsTab.cachedMobCategories()) {
            int cur = dimCounts.getOrDefault((Object)category, -1);
            int max = (int)((double)chunkCount * ((double)category.getMaxInstancesPerChunk() / (double)MAGIC_NUMBER));
            ChatFormatting color = Tab.heatmapColor(cur, max);
            ChatFormatting mobColor = Tab.creatureTypeColor(category);
            if (length != 0) {
                literal.append((Component)Component.literal((String)",").withStyle(ChatFormatting.GRAY));
            }
            literal.append((Component)Component.literal((String)"%s".formatted(cur < 0 ? "-" : Integer.valueOf(cur))).withStyle(color)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"%s".formatted(max)).withStyle(mobColor));
            ++length;
        }
        MutableComponent component = length > 0 ? literal : Component.literal((String)"--UNAVAILABLE--").withStyle(ChatFormatting.GRAY);
        return component;
    }

    public static MobCategory[] cachedMobCategories() {
        return CACHED_MOBCATEGORY_VALUES;
    }
}

